/**************************************************************************/
/* GE56 ( 帳票エラーテーブル )                                            */
/*                                                                        */
/* Created : 2012/04/13 09:47:11                                          */
/**************************************************************************/
CREATE TABLE GE56 (
   SYSTEM_ID VARCHAR(10)                NOT NULL      /* 10  システムID       */
 , YKNO      NUMERIC(9)     DEFAULT 0   NOT NULL      /* 20  要求ＮＯ         */
 , ERRMSG    BLOB                                     /* 30  エラーメッセージ */
 , UNIQSEQ   BIGINT                     NOT NULL      /* 50  シーケンス番号   */
 , FGJ       VARCHAR(1)     DEFAULT '1' NOT NULL      /* 810 状態フラグ       */
 , DYSET     VARCHAR(14)                              /* 820 登録日時         */
 , PGSET     VARCHAR(10)                              /* 830 作成PG           */
 , PGPSET    VARCHAR(10)                              /* 840 作成親PG         */
 , USRSET    VARCHAR(10)                              /* 850 作成社員         */
 , DYUPD     VARCHAR(14)                              /* 860 更新日時         */
 , PGUPD     VARCHAR(10)                              /* 870 更新PG           */
 , PGPUPD    VARCHAR(10)                              /* 880 更新親PG         */
 , USRUPD    VARCHAR(10)                              /* 890 更新者           */
);

CREATE SEQUENCE GE56S00 ;


CREATE TRIGGER GE56T00 FOR GE56
  BEFORE INSERT 
  AS BEGIN 
    NEW.UNIQSEQ = GEN_ID( GE56S00,1 );
  END; 


