/**************************************************************************/
/* GF24 ( JAVADOCクラス定義ファイル )                                     */
/*                                                                        */
/* Created : 2012/04/13 09:46:58                                          */
/**************************************************************************/
CREATE TABLE GF24 (
   VERNO       VARCHAR2(10)                  NOT NULL      /* 10  バージョン   */
 , TAGCLASS    VARCHAR2(100)                 NOT NULL      /* 20  TAGクラス名  */
 , VALUENAME   VARCHAR2(30)                  NOT NULL      /* 30  属性名称     */
 , HTMLEXT     VARCHAR2(1)                                 /* 40  HTMLEXT      */
 , DESCRIPTION VARCHAR2(4000)                              /* 50  概要説明     */
 , CONTENTS    CLOB                                        /* 60  内容         */
 , UNIQ        NUMBER(9)         DEFAULT 0   NOT NULL      /* 800 ユニークキー */
 , FGJ         VARCHAR2(1)       DEFAULT '1' NOT NULL      /* 810 状態フラグ   */
 , DYSET       VARCHAR2(14)                                /* 820 登録日時     */
 , PGSET       VARCHAR2(10)                                /* 830 作成PG       */
 , PGPSET      VARCHAR2(10)                                /* 840 作成親PG     */
 , USRSET      VARCHAR2(10)                                /* 850 作成社員     */
 , DYUPD       VARCHAR2(14)                                /* 860 更新日時     */
 , PGUPD       VARCHAR2(10)                                /* 870 更新PG       */
 , PGPUPD      VARCHAR2(10)                                /* 880 更新親PG     */
 , USRUPD      VARCHAR2(10)                                /* 890 更新者       */
)
TABLESPACE GETBL01
STORAGE( INITIAL 39936K NEXT 16K PCTINCREASE 0 );


CREATE SEQUENCE GF24S00 
INCREMENT BY 1 START WITH 1 MAXVALUE 999999999 CYCLE NOCACHE;


CREATE OR REPLACE TRIGGER GF24T00 
BEFORE INSERT ON GF24
FOR EACH ROW 
BEGIN 
SELECT GF24S00.NEXTVAL INTO :NEW.UNIQ FROM DUAL; 
END; 
/

