/**************************************************************************/
/* GF72 ( 登録ボタン状態テーブル )                                        */
/*                                                                        */
/* Created : 2012/04/13 09:46:58                                          */
/**************************************************************************/
CREATE TABLE GF72 (
   SYSTEM_ID  VARCHAR2(10)                 NOT NULL      /* 10  システムID   */
 , ADDRESS    VARCHAR2(256)                              /* 20  アドレス     */
 , PRE_FIX    VARCHAR2(10)                 NOT NULL      /* 30  名前空間     */
 , FILENAME   VARCHAR2(60)                               /* 40  ファイル名   */
 , FILEPATH   VARCHAR2(256)                              /* 50  ファイルパス */
 , MODIFIED   VARCHAR2(14)                               /* 60  最終更新日   */
 , TAGNAME    VARCHAR2(30)                               /* 70  タグ名称     */
 , TO_GAMENID VARCHAR2(30)                               /* 80  先画面ID     */
 , HREF       VARCHAR2(256)                              /* 90  リンク先URL  */
 , TARGET     VARCHAR2(10)                               /* 100 ターゲット   */
 , P_KEYS     VARCHAR2(500)                              /* 110 引数キー     */
 , P_VALS     VARCHAR2(500)                              /* 120 引数値       */
 , COMMAND    VARCHAR2(30)                               /* 130 コマンド     */
 , LBLCD      VARCHAR2(60)                               /* 140 ラベルコード */
 , MSGCD      VARCHAR2(20)                               /* 150 メッセージID */
 , ONCLICK    VARCHAR2(200)                              /* 160 イベント     */
 , ROLES      VARCHAR2(500)                              /* 170 ロールズ     */
 , FGOMIT     VARCHAR2(1)      DEFAULT '0' NOT NULL      /* 180 除外フラグ   */
 , UNIQ       NUMBER(9)        DEFAULT 0   NOT NULL      /* 190 ユニークキー */
 , FGJ        VARCHAR2(1)      DEFAULT '1' NOT NULL      /* 200 状態フラグ   */
 , DYSET      VARCHAR2(14)                               /* 210 登録日時     */
 , PGSET      VARCHAR2(10)                               /* 220 作成PG       */
 , PGPSET     VARCHAR2(10)                               /* 230 作成親PG     */
 , USRSET     VARCHAR2(10)                               /* 240 作成社員     */
 , DYUPD      VARCHAR2(14)                               /* 250 更新日時     */
 , PGUPD      VARCHAR2(10)                               /* 260 更新PG       */
 , PGPUPD     VARCHAR2(10)                               /* 270 更新親PG     */
 , USRUPD     VARCHAR2(10)                               /* 280 更新者       */
)
TABLESPACE GETBL01
STORAGE( INITIAL 256K NEXT 16K PCTINCREASE 0 );


CREATE SEQUENCE GF72S00 
INCREMENT BY 1 START WITH 1 MAXVALUE 999999999 CYCLE NOCACHE;


CREATE OR REPLACE TRIGGER GF72T00 
BEFORE INSERT ON GF72
FOR EACH ROW 
BEGIN 
SELECT GF72S00.NEXTVAL INTO :NEW.UNIQ FROM DUAL; 
END; 
/

