/**************************************************************************/
/* GF74 ( QUERY状態テーブル )                                             */
/*                                                                        */
/* Created : 2012/04/13 09:46:58                                          */
/**************************************************************************/
CREATE TABLE GF74 (
   SYSTEM_ID VARCHAR2(10)                 NOT NULL      /* 10  システムID     */
 , ADDRESS   VARCHAR2(256)                              /* 20  アドレス       */
 , PRE_FIX   VARCHAR2(10)                 NOT NULL      /* 30  名前空間       */
 , FILENAME  VARCHAR2(60)                               /* 40  ファイル名     */
 , FILEPATH  VARCHAR2(256)                              /* 50  ファイルパス   */
 , MODIFIED  VARCHAR2(14)                               /* 60  最終更新日     */
 , TAGNAME   VARCHAR2(30)                               /* 70  タグ名称       */
 , CLMS      VARCHAR2(500)                              /* 80  カラム一覧     */
 , TABLEID   VARCHAR2(50)                               /* 90  テーブルID     */
 , DBID      VARCHAR2(20)                               /* 100 データベースID */
 , SQL_TYPE  VARCHAR2(20)                               /* 110 クエリータイプ */
 , JSP_SCOPE VARCHAR2(20)                               /* 120 スコープ       */
 , SQL_TEXT  CLOB                                       /* 130 検索           */
 , FGOMIT    VARCHAR2(1)      DEFAULT '0' NOT NULL      /* 140 除外フラグ     */
 , UNIQ      NUMBER(9)        DEFAULT 0   NOT NULL      /* 150 ユニークキー   */
 , FGJ       VARCHAR2(1)      DEFAULT '1' NOT NULL      /* 160 状態フラグ     */
 , DYSET     VARCHAR2(14)                               /* 170 登録日時       */
 , PGSET     VARCHAR2(10)                               /* 180 作成PG         */
 , PGPSET    VARCHAR2(10)                               /* 190 作成親PG       */
 , USRSET    VARCHAR2(10)                               /* 200 作成社員       */
 , DYUPD     VARCHAR2(14)                               /* 210 更新日時       */
 , PGUPD     VARCHAR2(10)                               /* 220 更新PG         */
 , PGPUPD    VARCHAR2(10)                               /* 230 更新親PG       */
 , USRUPD    VARCHAR2(10)                               /* 240 更新者         */
)
TABLESPACE GETBL01
STORAGE( INITIAL 2048K NEXT 16K PCTINCREASE 0 );


CREATE SEQUENCE GF74S00 
INCREMENT BY 1 START WITH 1 MAXVALUE 999999999 CYCLE NOCACHE;


CREATE OR REPLACE TRIGGER GF74T00 
BEFORE INSERT ON GF74
FOR EACH ROW 
BEGIN 
SELECT GF74S00.NEXTVAL INTO :NEW.UNIQ FROM DUAL; 
END; 
/

