/**************************************************************************/
/* GF81 ( ARG変数チェックテーブル )                                       */
/*                                                                        */
/* Created : 2012/04/13 09:46:58                                          */
/**************************************************************************/
CREATE TABLE GF81 (
   SYSTEM_ID  VARCHAR2(10)                 NOT NULL      /* 10  システムID     */
 , TBLSYU     VARCHAR2(1)                  NOT NULL      /* 20  テーブル種別   */
 , OBJ_NAME   VARCHAR2(30)                 NOT NULL      /* 30  オブジェクト名 */
 , SEQNO      NUMBER(7)        DEFAULT 0   NOT NULL      /* 40  表示順         */
 , CLM        VARCHAR2(30)                 NOT NULL      /* 50  項目           */
 , CLS_NAME   VARCHAR2(10)                 NOT NULL      /* 60  DBクラス       */
 , USE_LENGTH VARCHAR2(9)      DEFAULT '0' NOT NULL      /* 70  使用桁数       */
 , TABLE_NAME VARCHAR2(50)                 NOT NULL      /* 80  テーブル名     */
 , MAX_LENGTH VARCHAR2(20)                               /* 90  最大使用桁数   */
 , CLM_NAME   VARCHAR2(120)                              /* 100 項目名(漢字)   */
 , CDKH       VARCHAR2(1)                                /* 110 改廃コード     */
 , UNIQ       NUMBER(9)        DEFAULT 0   NOT NULL      /* 120 ユニークキー   */
 , FGJ        VARCHAR2(1)      DEFAULT '1' NOT NULL      /* 130 状態フラグ     */
 , DYSET      VARCHAR2(14)                               /* 140 登録日時       */
 , PGSET      VARCHAR2(10)                               /* 150 作成PG         */
 , PGPSET     VARCHAR2(10)                               /* 160 作成親PG       */
 , USRSET     VARCHAR2(10)                               /* 170 作成社員       */
 , DYUPD      VARCHAR2(14)                               /* 180 更新日時       */
 , PGUPD      VARCHAR2(10)                               /* 190 更新PG         */
 , PGPUPD     VARCHAR2(10)                               /* 200 更新親PG       */
 , USRUPD     VARCHAR2(10)                               /* 210 更新者         */
)
TABLESPACE GETBL01
STORAGE( INITIAL 384K NEXT 16K PCTINCREASE 0 );


CREATE SEQUENCE GF81S00 
INCREMENT BY 1 START WITH 1 MAXVALUE 999999999 CYCLE NOCACHE;


CREATE OR REPLACE TRIGGER GF81T00 
BEFORE INSERT ON GF81
FOR EACH ROW 
BEGIN 
SELECT GF81S00.NEXTVAL INTO :NEW.UNIQ FROM DUAL; 
END; 
/

