CREATE OR REPLACE PACKAGE GFP00030 AS
/********************************************************************************
*	Declare Package
********************************************************************************/
PROCEDURE GFP00030 (
	PI_SYSTEM_ID    IN		VARCHAR2,
	PI_PTN_ID       IN		VARCHAR2,
	PI_FROM_ID      IN		VARCHAR2,
	PI_TO_ID        IN		VARCHAR2,
	PI_CC_ID        IN		VARCHAR2,
	PI_BCC_ID       IN		VARCHAR2,
	PI_H_TXT        IN		VARCHAR2,
	PI_F_TXT        IN		VARCHAR2,
	PI_PARAM0       IN		VARCHAR2,
	PI_PARAM1       IN		VARCHAR2,
	PI_PARAM2       IN		VARCHAR2,
	PI_PARAM3       IN		VARCHAR2,
	PI_PARAM4       IN		VARCHAR2,
	PI_PARAM5       IN		VARCHAR2,
	PI_PARAM6       IN		VARCHAR2,
	PI_PARAM7       IN		VARCHAR2,
	PI_PARAM8       IN		VARCHAR2,
	PI_PARAM9       IN		VARCHAR2,
	PI_ATTACH1      IN		VARCHAR2,
	PI_ATTACH2      IN		VARCHAR2,
	PI_ATTACH3      IN		VARCHAR2,
	PI_ATTACH4      IN		VARCHAR2,
	PI_ATTACH5      IN		VARCHAR2,
	PO_STATUS		OUT		NUMBER  ,
	PO_ERR_CODE		OUT		VARCHAR2,
	PO_ERRMSG		OUT		VARCHAR2
);
END GFP00030;
/
SHOW ERR
CREATE OR REPLACE PACKAGE BODY GFP00030 AS
/********************************************************************************
*	VXe	F	GWWEBVXe
*	JOB		F	[MW[ob`MSPTv
*	JOBID		F	GFP00030
*	쐬		F	2009/03/12
*	쐬		F	S.Li
*	XV		F	
*	l		F	
********************************************************************************/
/********************************************************************************
*	Declare Package-Body
********************************************************************************/
PROCEDURE GFP00030 (
	PI_SYSTEM_ID    IN		VARCHAR2,
	PI_PTN_ID       IN		VARCHAR2,
	PI_FROM_ID      IN		VARCHAR2,
	PI_TO_ID        IN		VARCHAR2,
	PI_CC_ID        IN		VARCHAR2,
	PI_BCC_ID       IN		VARCHAR2,
	PI_H_TXT        IN		VARCHAR2,
	PI_F_TXT        IN		VARCHAR2,
	PI_PARAM0       IN		VARCHAR2,
	PI_PARAM1       IN		VARCHAR2,
	PI_PARAM2       IN		VARCHAR2,
	PI_PARAM3       IN		VARCHAR2,
	PI_PARAM4       IN		VARCHAR2,
	PI_PARAM5       IN		VARCHAR2,
	PI_PARAM6       IN		VARCHAR2,
	PI_PARAM7       IN		VARCHAR2,
	PI_PARAM8       IN		VARCHAR2,
	PI_PARAM9       IN		VARCHAR2,
	PI_ATTACH1      IN		VARCHAR2,
	PI_ATTACH2      IN		VARCHAR2,
	PI_ATTACH3      IN		VARCHAR2,
	PI_ATTACH4      IN		VARCHAR2,
	PI_ATTACH5      IN		VARCHAR2,
	PO_STATUS		OUT		NUMBER  ,
	PO_ERR_CODE		OUT		VARCHAR2,
	PO_ERRMSG		OUT		VARCHAR2
)
IS
/********************************************************************************
*	ϐ`
********************************************************************************/
	-- ʕϐ
	STEP_STATUS		NUMBER			:= 1;
	STEP_ERR_CODE	VARCHAR2(1000)	:= '';
	G_RTN			BOOLEAN			:=	TRUE;
	G_ERRCD			VARCHAR2(10)	:=	NULL;
	G_SQLCODE		VARCHAR2(10)	:=	NULL;
	G_ERRMSG		VARCHAR2(1000);

	G_ERR		EXCEPTION;

	-- SUB-ROUTINGS
	FUNCTION	ERROR_CHECK_SYAIN_RTN(
					 PI_SYAIN_ID			IN		VARCHAR2
					,PO_ERRCD				OUT		VARCHAR2
					,PO_SQLCODE 			OUT 	VARCHAR2
					,PO_ERRMSG 				OUT 	VARCHAR2	)	RETURN BOOLEAN;
	FUNCTION	ERROR_CHECK_GROUP_RTN(
					 PI_SYSTEM_ID			IN		VARCHAR2
					,PI_GROUP_ID			IN		VARCHAR2
					,PO_ERRCD				OUT		VARCHAR2
					,PO_SQLCODE 			OUT 	VARCHAR2
					,PO_ERRMSG 				OUT 	VARCHAR2	)	RETURN BOOLEAN;
	FUNCTION ERROR_CHECK_PATTERN_RTN (
					 PI_SYSTEM_ID			IN		VARCHAR2
					,PI_PTN_ID				IN		VARCHAR2
					,PO_ERRCD				OUT		VARCHAR2
					,PO_SQLCODE				OUT		VARCHAR2
					,PO_ERRMSG				OUT		VARCHAR2	)	RETURN BOOLEAN;
	FUNCTION	ERROR_CHECK_DST_RTN(
					 PI_SYS_ID			IN		VARCHAR2
					,PI_DST_ID				IN		VARCHAR2
					,PO_ERRCD				OUT		VARCHAR2
					,PO_SQLCODE 			OUT 	VARCHAR2
					,PO_ERRMSG 				OUT 	VARCHAR2	)	RETURN BOOLEAN;

/********************************************************************************
*   ERROR_CHECK_SYAIN_RTN         ЈIDs                            *
********************************************************************************/
FUNCTION ERROR_CHECK_SYAIN_RTN (
	 PI_SYAIN_ID	IN		VARCHAR2
	,PO_ERRCD		OUT		VARCHAR2
	,PO_SQLCODE		OUT		VARCHAR2
	,PO_ERRMSG		OUT		VARCHAR2
) RETURN BOOLEAN
IS
	L_COUNT	NUMBER;
BEGIN
	SELECT COUNT(*) INTO L_COUNT
	FROM GE35 
	WHERE 	USERID = PI_SYAIN_ID ;
	
	IF L_COUNT > 0 THEN
		RETURN TRUE;
	ELSE
		RETURN FALSE;
	END IF;
EXCEPTION
	WHEN OTHERS THEN
		PO_ERRCD	:=	'ERR';
		PO_SQLCODE	:=	TO_CHAR(SQLCODE);
		PO_ERRMSG	:=	SUBSTRB(SQLERRM, 1, 100);
		RETURN FALSE;
END ERROR_CHECK_SYAIN_RTN;

/********************************************************************************
*   ERROR_CHECK_GROUP_RTN         O[vIDs                        *
********************************************************************************/
FUNCTION ERROR_CHECK_GROUP_RTN (
	 PI_SYSTEM_ID	IN		VARCHAR2
	,PI_GROUP_ID	IN		VARCHAR2
	,PO_ERRCD		OUT		VARCHAR2
	,PO_SQLCODE		OUT		VARCHAR2
	,PO_ERRMSG		OUT		VARCHAR2
) RETURN BOOLEAN
IS
	L_COUNT	NUMBER;
BEGIN
	SELECT COUNT(*) INTO L_COUNT
	FROM GE33 
	WHERE 	SYSTEM_ID = PI_SYSTEM_ID
		AND	GROUP_ID  = PI_GROUP_ID ;
	
	IF L_COUNT > 0 THEN
		RETURN TRUE;
	ELSE
		RETURN FALSE;
	END IF;
EXCEPTION
	WHEN OTHERS THEN
		PO_ERRCD	:=	'ERR';
		PO_SQLCODE	:=	TO_CHAR(SQLCODE);
		PO_ERRMSG	:=	SUBSTRB(SQLERRM, 1, 100);
		RETURN FALSE;
END ERROR_CHECK_GROUP_RTN;

/********************************************************************************
*   ERROR_CHECK_PATTERN_RTN         ^IDs                        *
********************************************************************************/
FUNCTION ERROR_CHECK_PATTERN_RTN (
	 PI_SYSTEM_ID	IN		VARCHAR2
	,PI_PTN_ID		IN		VARCHAR2
	,PO_ERRCD		OUT		VARCHAR2
	,PO_SQLCODE		OUT		VARCHAR2
	,PO_ERRMSG		OUT		VARCHAR2
) RETURN BOOLEAN
IS
	L_COUNT	NUMBER;
BEGIN
	SELECT COUNT(*) INTO L_COUNT
	FROM GE31 
	WHERE 	SYSTEM_ID = PI_SYSTEM_ID
		AND	PTN_ID    = PI_PTN_ID ;
	
	IF L_COUNT > 0 THEN
		RETURN TRUE;
	ELSE
		RETURN FALSE;
	END IF;
EXCEPTION
	WHEN OTHERS THEN
		PO_ERRCD	:=	'ERR';
		PO_SQLCODE	:=	TO_CHAR(SQLCODE);
		PO_ERRMSG	:=	SUBSTRB(SQLERRM, 1, 100);
		RETURN FALSE;
END ERROR_CHECK_PATTERN_RTN;

/********************************************************************************
*   ERROR_CHECK_DST_RTN         IDs                            *
********************************************************************************/
FUNCTION ERROR_CHECK_DST_RTN (
	 PI_SYS_ID		IN		VARCHAR2
	,PI_DST_ID		IN		VARCHAR2
	,PO_ERRCD		OUT		VARCHAR2
	,PO_SQLCODE		OUT		VARCHAR2
	,PO_ERRMSG		OUT		VARCHAR2
) RETURN BOOLEAN
IS
	L_COUNT		NUMBER;
	L_POS		NUMBER;
	L_BUFSTR	VARCHAR2(4000);
	L_ID		VARCHAR2(10);
	L_RTN		BOOLEAN	:=	TRUE;
BEGIN
	L_BUFSTR := PI_DST_ID;
	LOOP
		L_POS := NVL( INSTR( L_BUFSTR, ',' ), 0 );
		IF L_POS > 0 THEN
			L_ID  := SUBSTR( L_BUFSTR ,1 , L_POS-1 );
			L_BUFSTR := SUBSTR( L_BUFSTR ,L_POS+1 , LENGTH( L_BUFSTR )-L_POS );
		ELSE
			L_ID  := L_BUFSTR;
		END IF;

		IF LENGTH( L_ID ) >0 THEN
			IF INSTR( L_ID, 'GP.' ) > 0 THEN
				L_ID  := SUBSTR( L_ID ,4 , LENGTH( L_ID )-3 );
				L_RTN := ERROR_CHECK_GROUP_RTN( PI_SYS_ID, L_ID, PO_ERRCD, PO_SQLCODE, PO_ERRMSG );
			ELSE
				L_RTN := ERROR_CHECK_SYAIN_RTN( L_ID, PO_ERRCD, PO_SQLCODE, PO_ERRMSG );
			END IF;
		END IF;
		
		IF ( NOT L_RTN ) OR ( L_POS = 0 ) THEN
			EXIT;
		END IF;
	END LOOP;
	
	RETURN L_RTN;
EXCEPTION
	WHEN OTHERS THEN
		PO_ERRCD	:=	'ERR';
		PO_SQLCODE	:=	TO_CHAR(SQLCODE);
		PO_ERRMSG	:=	SUBSTRB(SQLERRM, 1, 100);
		RETURN FALSE;
END ERROR_CHECK_DST_RTN;

/********************************************************************************
*	C
********************************************************************************/
BEGIN
/********************************************************************************
*	
********************************************************************************/
	PO_STATUS	:= 1;
	PO_ERR_CODE	:= '';
	PO_ERRMSG	:= '';
	
	--^ID̃`FbNs܂B
	G_RTN := ERROR_CHECK_PATTERN_RTN(PI_SYSTEM_ID, PI_PTN_ID, G_ERRCD, G_SQLCODE, G_ERRMSG);
	IF G_RTN = FALSE THEN
		RAISE G_ERR;
	END IF;
	--MID̃`FbNs܂B
	G_RTN := ERROR_CHECK_SYAIN_RTN(PI_FROM_ID, G_ERRCD, G_SQLCODE, G_ERRMSG);
	IF G_RTN = FALSE THEN
		RAISE G_ERR;
	END IF;
	--iTOj̃`FbN
	IF PI_TO_ID IS NOT NULL THEN
		G_RTN := ERROR_CHECK_DST_RTN( PI_SYSTEM_ID, PI_TO_ID, G_ERRCD, G_SQLCODE, G_ERRMSG);
		IF G_RTN = FALSE THEN
			RAISE G_ERR;
		END IF;
	END IF;
	--iCCj̃`FbN
	IF PI_CC_ID IS NOT NULL THEN
		G_RTN := ERROR_CHECK_DST_RTN( PI_SYSTEM_ID, PI_CC_ID, G_ERRCD, G_SQLCODE, G_ERRMSG);
		IF G_RTN = FALSE THEN
			RAISE G_ERR;
		END IF;
	END IF;
	--iBCCj̃`FbN
	IF PI_BCC_ID IS NOT NULL THEN
		G_RTN := ERROR_CHECK_DST_RTN( PI_SYSTEM_ID, PI_BCC_ID, G_ERRCD, G_SQLCODE, G_ERRMSG);
		IF G_RTN = FALSE THEN
			RAISE G_ERR;
		END IF;
	END IF;
	--p[^e[uINSERTB
	INSERT INTO GE30(
		 SYSTEM_ID
		,PTN_ID   
		,FGJ
		,FROM_ID  
		,TO_ID    
		,CC_ID    
		,BCC_ID   
		,H_TXT    
		,F_TXT    
		,PARAM0   
		,PARAM1   
		,PARAM2   
		,PARAM3   
		,PARAM4   
		,PARAM5   
		,PARAM6   
		,PARAM7   
		,PARAM8   
		,PARAM9   
		,ATTACH1  
		,ATTACH2  
		,ATTACH3  
		,ATTACH4  
		,ATTACH5  
		,DYSET    
		,USRSET   
		,PGUPD   
	) VALUES(
		 PI_SYSTEM_ID	--VXeID
		,PI_PTN_ID		--^ID
		,'1'			--󋵃tOF'o^iM҂j'
		,PI_FROM_ID		--MID
		,PI_TO_ID		--iTOj
		,PI_CC_ID		--iCCj
		,PI_BCC_ID		--iBCCj
		,PI_H_TXT		--wb_[R
		,PI_F_TXT		--tb^[R
		,PI_PARAM0		--p[^O
		,PI_PARAM1		--p[^P
		,PI_PARAM2		--p[^Q
		,PI_PARAM3		--p[^R
		,PI_PARAM4		--p[^S
		,PI_PARAM5		--p[^T
		,PI_PARAM6		--p[^U
		,PI_PARAM7		--p[^V
		,PI_PARAM8		--p[^W
		,PI_PARAM9		--p[^X
		,PI_ATTACH1		--Ytt@CP
		,PI_ATTACH2		--Ytt@CQ
		,PI_ATTACH3		--Ytt@CR
		,PI_ATTACH4		--Ytt@CS
		,PI_ATTACH5		--Ytt@CT
		,TO_CHAR(SYSDATE,'YYYYMMDDHH24MMSS')
		,'BATCH'
		,'GFP00030'
	);

	PO_STATUS :=0;

/********************************************************************************
*	EXCEPTION
********************************************************************************/
EXCEPTION
	WHEN G_ERR THEN
		ROLLBACK;
		PO_STATUS	:= 1;										--װү޺
		PO_ERR_CODE := G_SQLCODE;								--װ
		PO_ERRMSG	:= G_ERRMSG; 								--װү
		RETURN;
	WHEN OTHERS THEN
		ROLLBACK;
		PO_STATUS   := 1;
		PO_ERR_CODE := 'ORA' || TO_CHAR(SQLCODE, '09999');
		PO_ERRMSG	:= SUBSTRB(G_ERRMSG, 1, 255); 				--װү
		RETURN;

END GFP00030;
END GFP00030;
/
SHOW ERR
