<?xml version="1.0"  encoding="UTF-8" ?>
<jsp:root
	xmlns:jsp="http://java.sun.com/JSP/Page"
	xmlns:og="hybs-taglib.tld" 
	version="2.0">
<jsp:directive.page language="java" contentType="text/html; charset=UTF-8" />

<og:head headType="init" useRealTimeCheck="false"/>
<og:localResource systemId="GE" initLoad="false" />
<og:comment
	system	= "GE:エンジン標準"
	pgid	= "WHTSNEW"
	title	= "標準(新着情報登録)"
	date	= "2012/01/10"
	author	= "Son.I"
	text	= ""
	version	= "001"
/>

<!-- ﾌｧｲﾙｱｯﾌﾟﾛｰﾄﾞ-->
<og:upload
		fileURL		= "{@SYS.REAL_PATH}{@USER.FILEPATH}" scope="request"/>

<!-- エラー時の戻るボタン。書き換えないで下さい。-->
<!-- history.back() で戻るボタンを表示します。	-->
<jsp:directive.include file="/jsp/common/history_back.jsp" />

<!-- command="ENTRY"時は、nullCheckはcolumnEditorでmust指定したカラムをチェックします。-->
<!-- カラムに付いては、全カラムをチェックしています。-->
<og:columnCheck	command   = "ENTRY"/>

<!-- command="ENTRY"時は、リクエスト情報（カラム名__行番号)を、DBTableModelにセットします。-->
<!-- カラムに対して値をセットしない場合、ColumnSetTagは不要です。 -->
<og:entry command="ENTRY"/>

<!-- 前画面のSQL文を実行する場合に、tableUpdate の queryType="JDBCTableUpdate"を指定します。-->
<!-- 通常は変更する必要はありません。 -->
<og:equals val1="COPY|DELETE|INSERT" val2="{@sqlType}" contains="true">
	<og:tableUpdate command="ENTRY"
					queryType="JDBCTableUpdate" 
					debug="false">
				<og:tableUpdateParam
						sqlType  = "{@sqlType}"
						table  = "GE81"
						where  = "UNIQ = [UNIQ]"
						names = "SYSTEM_ID,SYSCODE,CDDEG,TITLE,NAIYO,DYSTRD,DYENDD,BUSHOD,MAND,TEL,MAILAD,FGJ,TAG,FILE1,FILE2,FILE3,FILEPATH"
						logicalDelete	=  "true"
						constObjKey ="GF"
				/>
	</og:tableUpdate>
</og:equals>

<og:equals val1="{@sqlType}" val2="MODIFY">
	<og:tableUpdate command="ENTRY"
					queryType="JDBCTableUpdate" 
					debug="false">
				<og:tableUpdateParam
						sqlType  = "{@sqlType}"
						table  = "GE81"
						where  = "UNIQ = [UNIQ]"
						names = "SYSTEM_ID,SYSCODE,CDDEG,TITLE,NAIYO,DYSTRD,DYENDD,BUSHOD,MAND,TEL,MAILAD,FGJ,TAG"
						logicalDelete	=  "true"
						constObjKey ="GF"
				/>
	</og:tableUpdate>
	<!-- 変更時、ﾌｧｲﾙ名更新	-->
	<og:tableUpdate
			command="ENTRY"
			queryType="JDBCTableUpdate"
			debug="true">
			UPDATE	GE81	SET
				 FILE1		=	DECODE([FILE1],NULL,FILE1,[FILE1])
				,FILE2		=	DECODE([FILE2],NULL,FILE2,[FILE2])
				,FILE3		=	DECODE([FILE3],NULL,FILE3,[FILE3])
			WHERE	UNIQ	=	[UNIQ]
	</og:tableUpdate>
</og:equals>


<og:forward page="result.jsp" keys="command" vals="RENEW" />
<jsp:directive.include file="/jsp/common/htmlend.jsp" />
</jsp:root>
