/*
 * Copyright (c) 2009 The openGion Project.
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND,
 * either express or implied. See the License for the specific language
 * governing permissions and limitations under the License.
 */
package org.opengion.plugin.column;

import org.opengion.hayabusa.db.AbstractRenderer;
import org.opengion.hayabusa.db.CellRenderer;
import org.opengion.hayabusa.db.DBColumn;
import org.opengion.hayabusa.db.Selection;

/**
 * MENU レンデラーは、カラムのデータをコードリソースに対応したラベルで
 * プルダウンメニュー表示する場合に使用するクラスです。
 *
 *  カラムの表示に必要な属性は, DBColumn オブジェクト より取り出します。
 * このクラスは、DBColumn オブジェクト毎に１つ作成されます。
 *
 * @og.group データ表示
 *
 * @version  4.0
 * @author   Kazuhiko Hasegawa
 * @since    JDK5.0,
 */
public class Renderer_MENU extends AbstractRenderer {
	//* このプログラムのVERSION文字列を設定します。	{@value} */
	private static final String VERSION = "4.0.0 (2005/08/31)" ;

	// 3.2.3.0 (2003/06/06) final を削除。サブクラスからアクセスできるように変更。
	private final Selection selection  ;
	private final String useSlabel ;	// 5.5.1.0 (2012/04/03)

	/**
	 * デフォルトコンストラクター。
	 * このコンストラクターで、基本オブジェクトを作成します。
	 *
	 * @og.rev 3.1.1.1 (2003/04/03) 各オブジェクトから自分のインスタンスを返すファクトリメソッドを追加。
	 * @og.rev 3.2.3.0 (2003/06/06) key 変数をローカル化。
	 * @og.rev 5.5.1.0 (2012/04/03) Slabel対応
	 *
	 */
	public Renderer_MENU() {
		selection  = null;
		useSlabel = "auto";		// 5.5.1.0 (2012/04/03)
	}

	/**
	 * デフォルトコンストラクター。
	 *
	 * @og.rev 3.1.1.1 (2003/04/03) 各オブジェクトから自分のインスタンスを返すファクトリメソッドを追加。
	 * @og.rev 3.2.3.0 (2003/06/06) key 変数をローカル化。
	 * @og.rev 3.3.1.1 (2003/07/03) CodeSelection の設定において、バグ修正。
	 * @og.rev 3.5.4.2 (2003/12/15) makeCodeSelection メソッドを CodeSelectionクラスに変更。
	 * @og.rev 3.5.5.7 (2004/05/10) SelectionFactory を使用して、オブジェクト作成
	 * @og.rev 4.0.0 (2005/01/31) Selection_CODE の作成の引数を CodeData に変更。
	 * @og.rev 4.0.0.0 (2007/11/07) SelectionオブジェクトをDBColumnから取得
	 * @og.rev 5.5.1.0 (2012/04/03) Slabel対応
	 *
	 * @param   clm DBColumn オブジェクト
	 */
	private Renderer_MENU( final DBColumn clm ) {
		selection = clm.getSelection();										// 4.0.0.0 (2007/11/07)
		useSlabel = clm.getUseSlabel() ;	// 5.5.1.0 (2012/04/03)
	}

	/**
	 * 各オブジェクトから自分のインスタンスを返します。
	 * 自分自身をキャッシュするのか、新たに作成するのかは、各サブクラスの実装に
	 * まかされます。
	 *
	 * @og.rev 3.1.1.1 (2003/04/03) 各オブジェクトから自分のインスタンスを返すファクトリメソッドを追加。
	 * @og.rev 3.1.2.1 (2003/04/10) synchronized を、削除します。
	 *
	 * @param   clm DBColumn オブジェクト
	 * @return  CellRenderer オブジェクト
	 */
	public CellRenderer newInstance( final DBColumn clm ) {
		return new Renderer_MENU( clm );
	}

	/**
	 * データの表示用文字列を返します。
	 *
	 * @og.rev 5.5.1.0 (2012/04/03) Slabel対応
	 * 
	 * @param   value String
	 * @return  データの表示用文字列
	 */
	public String getValue( final String value ) {
		final boolean uslbl = !"true".equals(useSlabel) ? false : true; // 5.5.1.0 (2012/04/03)
//		return selection.getValueLabel( value,false );
		return selection.getValueLabel( value,uslbl ); // 5.5.1.0 (2012/04/03)
	}

	/**
	 * name属性を変えた、データ表示/編集用のHTML文字列を作成します。
	 * テーブル上の name に 行番号を付加して、名前_行番号 で登録するキーを作成し,
	 * リクエスト情報を１つ毎のフィールドで処理できます。
	 *
	 * @og.rev 4.0.0 (2005/11/30) 一覧表示では、短縮ラベルを使用します。
	 * @og.rev 5.5.1.0 (2012/04/03) Slabel対応
	 *
	 * @param   row   int 行番号
	 * @param   value String
	 * @return  データ表示/編集用の文字列
	 */
	public String getValue( final int row,final String value ) {
		final boolean uslbl = ("auto".equals(useSlabel) || "true".equals(useSlabel) ) ? true : false; // 5.5.1.0 (2012/04/03)
//		return selection.getValueLabel( value,true )
		return selection.getValueLabel( value,uslbl );
	}
}
