/*
 * Decompiled with CFR 0.152.
 */
package org.opengion.hayabusa.resource;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Comparator;
import java.util.Hashtable;
import java.util.List;
import javax.naming.NamingEnumeration;
import javax.naming.NamingException;
import javax.naming.directory.Attribute;
import javax.naming.directory.Attributes;
import javax.naming.directory.DirContext;
import javax.naming.directory.InitialDirContext;
import javax.naming.directory.SearchControls;
import javax.naming.directory.SearchResult;
import org.opengion.fukurou.util.StringUtil;
import org.opengion.hayabusa.common.HybsSystem;
import org.opengion.hayabusa.common.HybsSystemException;

public class LDAPSearch {
    private String initctx = HybsSystem.sys("LDAP_INITIAL_CONTEXT_FACTORY");
    private String providerURL = HybsSystem.sys("LDAP_PROVIDER_URL");
    private String entrydn = HybsSystem.sys("LDAP_ENTRYDN");
    private String password = HybsSystem.sys("LDAP_PASSWORD");
    private String searchbase = HybsSystem.sys("LDAP_SEARCH_BASE");
    private String searchScope = HybsSystem.sys("LDAP_SEARCH_SCOPE");
    private static final long COUNTLIMIT = 0L;
    private int timeLimit = 0;
    private String[] attrs = null;
    private boolean returningObjFlag = false;
    private boolean derefLinkFlag = false;
    private int executeCount = 0;
    private int maxRowCount = 0;
    private SearchControls constraints = null;
    private DirContext ctx = null;
    private String[] orderBy = null;
    private boolean[] desc = null;

    public void init() {
        Hashtable<String, String> hashtable = new Hashtable<String, String>();
        hashtable.put("java.naming.factory.initial", this.initctx);
        hashtable.put("java.naming.provider.url", this.providerURL);
        if (!StringUtil.isNull((String)this.password)) {
            hashtable.put("java.naming.security.credentials", this.password.trim());
        }
        if (!StringUtil.isNull((String)this.entrydn)) {
            hashtable.put("java.naming.security.principal", this.entrydn);
        }
        try {
            this.ctx = new InitialDirContext(hashtable);
            this.constraints = new SearchControls(this.changeScopeString(this.searchScope), 0L, this.timeLimit, this.attrs, this.returningObjFlag, this.derefLinkFlag);
        }
        catch (NamingException namingException) {
            String string = "LDAP\u691c\u7d22\u7528\u30aa\u30d6\u30b8\u30a7\u30af\u30c8\u306e\u521d\u671f\u5316\u306b\u5931\u6557\u3057\u307e\u3057\u305f\u3002";
            throw new HybsSystemException(string, namingException);
        }
    }

    public List<String[]> search(String string) {
        ArrayList<String[]> arrayList = new ArrayList<String[]>();
        try {
            NamingEnumeration<SearchResult> namingEnumeration = this.ctx.search(this.searchbase, string, this.constraints);
            while (namingEnumeration != null && namingEnumeration.hasMore() && (this.maxRowCount <= 0 || this.maxRowCount > this.executeCount)) {
                String[] stringArray;
                SearchResult searchResult = namingEnumeration.next();
                Attributes attributes = searchResult.getAttributes();
                if (this.attrs == null) {
                    stringArray = attributes.getIDs();
                    ArrayList arrayList2 = new ArrayList();
                    while (stringArray.hasMore()) {
                        arrayList2.add(stringArray.next());
                    }
                    stringArray.close();
                    this.attrs = arrayList2.toArray(new String[arrayList2.size()]);
                }
                stringArray = new String[this.attrs.length];
                boolean bl = false;
                for (int i = 0; i < this.attrs.length && (this.maxRowCount <= 0 || this.maxRowCount > this.executeCount); ++i) {
                    Attribute attribute = attributes.get(this.attrs[i]);
                    if (attribute == null) continue;
                    NamingEnumeration<?> namingEnumeration2 = attribute.getAll();
                    StringBuilder stringBuilder = new StringBuilder();
                    if (namingEnumeration2.hasMore()) {
                        this.getDataChange(namingEnumeration2.next(), stringBuilder);
                    }
                    while (namingEnumeration2.hasMore()) {
                        stringBuilder.append(",");
                        this.getDataChange(namingEnumeration2.next(), stringBuilder);
                    }
                    stringArray[i] = stringBuilder.toString();
                    bl = true;
                }
                if (!bl) continue;
                arrayList.add(stringArray);
                ++this.executeCount;
            }
            if (namingEnumeration != null) {
                namingEnumeration.close();
            }
        }
        catch (NamingException namingException) {
            String string2 = "List \u30aa\u30d6\u30b8\u30a7\u30af\u30c8\u306e\u691c\u7d22\u306b\u5931\u6557\u3057\u307e\u3057\u305f\u3002" + HybsSystem.CR + "searchbase \u3084\u3001entrydn \u306e\u8a18\u8ff0\u3092\u3054\u78ba\u8a8d\u304f\u3060\u3055\u3044\u3002" + HybsSystem.CR + "searchbase:" + this.searchbase + " , entrydn:" + this.entrydn;
            throw new HybsSystemException(string2, namingException);
        }
        return this.sort(arrayList, this.attrs);
    }

    private StringBuilder getDataChange(Object object, StringBuilder stringBuilder) {
        if (object == null) {
            return stringBuilder;
        }
        if (object instanceof byte[]) {
            byte[] byArray = (byte[])object;
            char[] cArray = new char[byArray.length];
            for (int i = 0; i < byArray.length; ++i) {
                cArray[i] = (char)byArray[i];
            }
            stringBuilder.append(cArray);
        } else {
            stringBuilder.append(object);
        }
        return stringBuilder;
    }

    public void setSearchScope(String string) {
        this.searchScope = StringUtil.nval((String)string, (String)this.searchScope);
        if (!("OBJECT".equals(this.searchScope) || "ONELEVEL".equals(this.searchScope) || "SUBTREE".equals(this.searchScope))) {
            String string2 = "\u691c\u7d22\u7bc4\u56f2\u306f\u3001\u300eOBJECT\u300f\u300eONELEVEL\u300f\u300eSUBTREE\u300f\u306e\u4e2d\u304b\u3089\u9078\u629e\u3057\u3066\u4e0b\u3055\u3044\u3002[" + this.searchScope + "]";
            throw new HybsSystemException(string2);
        }
    }

    private int changeScopeString(String string) {
        int n;
        if ("OBJECT".equals(string)) {
            n = 0;
        } else if ("ONELEVEL".equals(string)) {
            n = 1;
        } else if ("SUBTREE".equals(string)) {
            n = 2;
        } else {
            String string2 = "Search Scope in \u300eOBJECT\u300f\u300eONELEVEL\u300f\u300eSUBTREE\u300fSelected[" + this.searchScope + "]";
            throw new HybsSystemException(string2);
        }
        return n;
    }

    public void setTimeLimit(int n) {
        this.timeLimit = n;
    }

    public void setDerefLinkFlag(boolean bl) {
        this.derefLinkFlag = bl;
    }

    public void setReturningObjFlag(boolean bl) {
        this.returningObjFlag = bl;
    }

    public void setMaxRowCount(int n) {
        this.maxRowCount = n;
    }

    public void setAttributes(String[] stringArray) {
        if (stringArray != null) {
            this.attrs = new String[stringArray.length];
            System.arraycopy(stringArray, 0, this.attrs, 0, stringArray.length);
        }
    }

    public String[] getAttributes() {
        return this.attrs == null ? new String[]{} : (String[])this.attrs.clone();
    }

    public void setInitctx(String string) {
        this.initctx = StringUtil.nval((String)string, (String)this.initctx);
    }

    public void setProviderURL(String string) {
        this.providerURL = StringUtil.nval((String)string, (String)this.providerURL);
    }

    public void setSearchbase(String string) {
        this.searchbase = StringUtil.nval((String)string, (String)this.searchbase);
    }

    public void setEntrydn(String string) {
        this.entrydn = StringUtil.nval((String)string, (String)this.entrydn);
    }

    public void setPassword(String string) {
        this.password = StringUtil.nval((String)string, (String)this.password);
    }

    public void setOrderBy(String string) {
        this.orderBy = StringUtil.csv2Array((String)string);
        this.desc = new boolean[this.orderBy.length];
        for (int i = 0; i < this.orderBy.length; ++i) {
            String string2 = this.orderBy[i].trim();
            int n = string2.indexOf(" DESC");
            if (n > 0) {
                this.desc[i] = true;
                string2 = string2.substring(0, n);
            } else {
                this.desc[i] = false;
            }
            this.orderBy[i] = string2;
        }
    }

    private List<String[]> sort(List<String[]> list, String[] stringArray) {
        int n;
        Object object;
        if (this.orderBy == null || this.orderBy.length == 0 || stringArray == null || stringArray.length == 0 || list.isEmpty()) {
            return list;
        }
        int[] nArray = new int[this.orderBy.length];
        for (int i = 0; i < this.orderBy.length; ++i) {
            object = this.orderBy[i];
            nArray[i] = -1;
            for (n = 0; n < stringArray.length; ++n) {
                if (!((String)object).equalsIgnoreCase(stringArray[n])) continue;
                nArray[i] = n;
                break;
            }
            if (nArray[i] >= 0) continue;
            String string = "\u6307\u5b9a\u306e Order BY \u30ad\u30fc\u306f\u3001\u30d8\u30c3\u30c0\u30fc\u5217\u306b\u5b58\u5728\u3057\u307e\u305b\u3093\u3002order Key=[" + (String)object + "] , attri=[" + StringUtil.array2csv((String[])stringArray) + "]" + HybsSystem.CR;
            throw new HybsSystemException(string);
        }
        String[][] stringArray2 = (String[][])list.toArray((T[])new String[list.size()][list.get(0).length]);
        Arrays.sort(stringArray2, new IdComparator(nArray, this.desc));
        object = new ArrayList();
        for (n = 0; n < stringArray2.length; ++n) {
            object.add(stringArray2[n]);
        }
        return object;
    }

    public String toString() {
        StringBuilder stringBuilder = new StringBuilder(200);
        stringBuilder.append("  initctx      [").append(this.initctx).append("]").append(HybsSystem.CR);
        stringBuilder.append("  providerURL  [").append(this.providerURL).append("]").append(HybsSystem.CR);
        stringBuilder.append("  entrydn      [").append(this.entrydn).append("]").append(HybsSystem.CR);
        stringBuilder.append("  searchbase   [").append(this.searchbase).append("]").append(HybsSystem.CR);
        stringBuilder.append("  searchScope  [").append(this.searchScope).append("]").append(HybsSystem.CR);
        stringBuilder.append("  executeCount [").append(this.executeCount).append("]").append(HybsSystem.CR);
        stringBuilder.append("  attributes   [").append(StringUtil.array2line((String[])this.attrs, (String)","));
        stringBuilder.append("]").append(HybsSystem.CR);
        return stringBuilder.toString();
    }

    private static class IdComparator
    implements Comparator<String[]>,
    Serializable {
        private static final long serialVersionUID = 4000L;
        private final int[] no;
        private final boolean[] desc;
        private final int cnt;

        public IdComparator(int[] nArray, boolean[] blArray) {
            this.no = nArray;
            this.desc = blArray;
            this.cnt = nArray.length;
        }

        @Override
        public int compare(String[] stringArray, String[] stringArray2) {
            if (stringArray == null) {
                return -1;
            }
            for (int i = 0; i < this.cnt; ++i) {
                if (stringArray[this.no[i]] == null) {
                    return -1;
                }
                int n = stringArray[this.no[i]].compareTo(stringArray2[this.no[i]]);
                if (this.desc[i]) {
                    n = -n;
                }
                if (n == 0) continue;
                return n;
            }
            return 0;
        }
    }
}

