<?xml version="1.0" encoding="UTF-8" ?>
<jsp:root
	xmlns:jsp="http://java.sun.com/JSP/Page"
	xmlns:og="hybs-taglib.tld" 
	version="2.0">
<jsp:directive.page language="java" contentType="text/html; charset=UTF-8" />

<og:head headType="result" />
<jsp:directive.include file="/jsp/custom/result_info.jsp" />
<og:comment
	system   = "GE:エンジンサンプル"
	pgid     = "GE1004"
	title    = "DB検索"
	date     = "2007/12/12"
	author   = "K.HASEGAWA"
	text     = "ZZZZ"
	version  = "001"
/>

<og:query command="{@command}" notfoundMsg="" scope="request" dbid="{@DBID}">
	delete from plan_table where statement_id = '{@USER.ID}'
</og:query>

<og:query command="{@command}" notfoundMsg="" scope="request" dbid="{@DBID}" quotCheck="false">
	explain plan set statement_id = '{@USER.ID}' for {@SQL}
</og:query>

<og:query command="{@command}" notfoundMsg="" scope="request" dbid="{@DBID}" >
	<og:text>
		select LEVEL,lpad(' ',LEVEL,' ') ||
		 rtrim( OPERATION ) || ' ' ||
		 rtrim( OPTIONS )   || ' ' ||
		 rtrim( OBJECT_NAME ) as EXECUTION_PLAN
		,decode( instr(OPTIONS,'FULL'),null,'false',0,'false','true' ) as FULL
		,OBJECT_OWNER,OBJECT_NAME
		,DECODE(INSTR(OBJECT_TYPE,' '),0,OBJECT_TYPE,SUBSTR(OBJECT_TYPE,1,INSTR(OBJECT_TYPE,' ')-1)) AS OBJECT_TYPE
		,OPTIMIZER,COST,CARDINALITY,BYTES,ACCESS_PREDICATES,FILTER_PREDICATES
		from PLAN_TABLE
		where STATEMENT_ID = '{@USER.ID}'
		start with ID = 0
			  and STATEMENT_ID = '{@USER.ID}'
		connect by prior ID = PARENT_ID
			  and STATEMENT_ID = '{@USER.ID}'
	</og:text>
</og:query>

<og:viewLink command="{@command}">
	<og:link column="OBJECT_NAME" href="viewObject.jsp" target="SUB_WIND"
		keys="command,OWNER,TYPE,NAME,DBID" vals="NEW,[OBJECT_OWNER],[OBJECT_TYPE],[OBJECT_NAME],{@DBID}" />
</og:viewLink>

<og:viewMarker command="{@command}" >
	<og:columnMarker column="EXECUTION_PLAN" onMark="[FULL]" >
		<span id="warning">[EXECUTION_PLAN]</span>
	</og:columnMarker>
</og:viewMarker>

<og:columnEditor column="EXECUTION_PLAN" renderer="PRE" scope="request" />

<og:view
	scope      = "request" 
	viewFormType = "HTMLTable" 
	command    = "{@command}" 
	noDisplay  = "FULL,OBJECT_OWNER"
	writable   = "false"
	startNo    = "{@startNo}" 
	pageSize   = "{@pageSize}" 
	noMessage  = "true"
/>

<jsp:directive.include file="/jsp/common/htmlend.jsp" />
</jsp:root>
