/**************************************************************************/
/* GF09 ( シーケンス定義 )                                                */
/*                                                                        */
/* Created : 2012/06/01 18:24:18                                          */
/**************************************************************************/
CREATE TABLE GF09 (
   SYSTEM_ID  VARCHAR2(10)                      NOT NULL      /* 10  システムID     */
 , TBLSYU     VARCHAR2(1)                       NOT NULL      /* 20  テーブル種別   */
 , SEQNAME    VARCHAR2(50)                      NOT NULL      /* 30  シーケンス名   */
 , INCREBY    NUMBER(9)       DEFAULT 1         NOT NULL      /* 40  インクリメント */
 , STARTVAL   NUMBER(9)       DEFAULT 1         NOT NULL      /* 50  開始値         */
 , MINVAL     NUMBER(9)       DEFAULT 1         NOT NULL      /* 60  最小値         */
 , MAXVAL     NUMBER(9)       DEFAULT 999999999 NOT NULL      /* 70  最大値         */
 , FGCYCLE    VARCHAR2(1)     DEFAULT '1'       NOT NULL      /* 80  サイクルフラグ */
 , SUCACHE    NUMBER(7)       DEFAULT 0         NOT NULL      /* 90  キャッシュ数   */
 , TABLE_NAME VARCHAR2(50)                                    /* 100 テーブル名     */
 , CLM        VARCHAR2(30)                                    /* 110 項目           */
 , UNIQ       NUMBER(9)       DEFAULT 0         NOT NULL      /* 120 ユニークキー   */
 , FGJ        VARCHAR2(1)     DEFAULT '1'       NOT NULL      /* 130 状態フラグ     */
 , DYSET      VARCHAR2(14)                                    /* 140 登録日時       */
 , PGSET      VARCHAR2(10)                                    /* 150 作成PG         */
 , PGPSET     VARCHAR2(10)                                    /* 160 作成親PG       */
 , USRSET     VARCHAR2(10)                                    /* 170 作成社員       */
 , DYUPD      VARCHAR2(14)                                    /* 180 更新日時       */
 , PGUPD      VARCHAR2(10)                                    /* 190 更新PG         */
 , PGPUPD     VARCHAR2(10)                                    /* 200 更新親PG       */
 , USRUPD     VARCHAR2(10)                                    /* 210 更新者         */
)
TABLESPACE GETBL01
STORAGE( INITIAL 256K NEXT 16K PCTINCREASE 0 );


CREATE SEQUENCE GF09S00 
INCREMENT BY 1 START WITH 1 MAXVALUE 999999999 CYCLE NOCACHE;


CREATE OR REPLACE TRIGGER GF09T00 
BEFORE INSERT ON GF09
FOR EACH ROW 
BEGIN 
SELECT GF09S00.NEXTVAL INTO :NEW.UNIQ FROM DUAL; 
END; 
/

