<?xml version="1.0" encoding="UTF-8" ?>
<jsp:root
	xmlns:jsp="http://java.sun.com/JSP/Page"
	xmlns:og="hybs-taglib.tld"
	version="2.0">
<jsp:directive.page language="java" contentType="text/html; charset=UTF-8" />

<og:head headType="result" />
<jsp:directive.include file="/jsp/custom/result_info.jsp" />
<og:comment
	system	= "GF:エンジンサンプル"
	pgid	= "GF2130"
	title	= "テーブル一覧表"
	date	= "2008/10/27"
	author	= "Hiroki.Nakamura"
	text	= ""
	version	= "001"
/>
<og:errorMessage command="{@command}" clear="{@clear}" displayMsg="{@displayMsg}" />

<og:columnCheck
	command   = "{@command}"
	columns   = "SYSTEM_ID,TBLSYU,TABLE_NAME"
/>

<og:entry command = "{@command}" />

<og:query command="{@command}" debug="{@debug}" maxRowCount="{@maxRowCount}">
		select A.TABLE_NAME,B.NAME_JA AS T_NAME,A.SEQNO,A.CLM,A.NAME_JA,A.FGCOM,
				rank() over (partition by A.TABLE_NAME order by A.SEQNO) as RANKING ,
				(CASE WHEN D.CLM IS NOT NULL THEN '○' WHEN A.NOT_NULL = '1' THEN '*' END ) as NN ,
				(CASE WHEN A.CLS_NAME = 'VARCHAR2' THEN 'X('  || A.USE_LENGTH || ')' 
					  WHEN A.CLS_NAME = 'CLOB'     THEN 'CLOB'
					  WHEN A.CLS_NAME = 'NUMBER' AND A.USE_LENGTH IS NOT NULL THEN 'S('   || A.USE_LENGTH || ')' 
					  WHEN A.CLS_NAME = 'NUMBER' AND A.USE_LENGTH IS NULL     THEN 'S'
					  ELSE A.CLS_NAME END ) as CLS_NAME
		from ( GF05 A inner join GF02 B
			on    A.SYSTEM_ID  = B.SYSTEM_ID
			and   A.TABLE_NAME = B.TABLE_NAME
			and   A.TBLSYU     = B.TBLSYU  )
				left outer join ( GF06 C inner join GF07 D
									on    C.SYSTEM_ID  = D.SYSTEM_ID
									and   C.TABLE_NAME = D.TABLE_NAME
									and   C.INDEX_NAME = D.INDEX_NAME
									and   C.TBLSYU     = D.TBLSYU
									and   C.FGJ        = D.FGJ
								)
			on    A.SYSTEM_ID  = C.SYSTEM_ID
			and   A.TABLE_NAME = C.TABLE_NAME
			and   A.TBLSYU     = C.TBLSYU
			and   A.CLM        = D.CLM
			and   C.INDTYPE    = '0'
			and   C.FGJ = '1'
			and   D.FGJ = '1'
		where A.FGJ = '1'
		and   B.FGJ = '1'
	<og:where startKey="and">
		<og:and value = "A.FGCOM        =   '{@FGCOM}'"         />
		<og:and value = "A.SYSTEM_ID    =   '{@SYSTEM_ID}'"     />
		<og:and value = "A.TBLSYU       =   '{@TBLSYU}'"        />
		<og:and value = "A.TABLE_NAME   like '{@TABLE_NAME}%'"  />
	</og:where>
	<jsp:text>
		order by A.TABLE_NAME,A.SEQNO
	</jsp:text>
</og:query>

<og:equals val1="{@USE_LBL}" val2="true" >
	<og:tableFilter classId="LABEL" keys="SYSTEM_ID,CLM,LBL" vals="SYSTEM_ID,TABLE_NAME,T_NAME" />
	<og:tableFilter classId="LABEL" keys="SYSTEM_ID,CLM,LBL" vals="SYSTEM_ID,CLM,NAME_JA" />
</og:equals>

<og:view
	viewFormType = "HTMLCustomTable"
	command    = "{@command}"
	startNo    = "{@startNo}"
	checked    = "{@checked}"
	pageSize   = "{@pageSize}"
	writable   = "false"
	numberType = "delete"
	useCheckControl = "false"
	useScrollBar    = "false"
	rowspan    = "1"
	headerSkipCount = "0"
>
	<og:thead rowspan="1">
		<tr><td colspan="4" /></tr>
	</og:thead>
	<og:tbody usableKey="RANKING" usableList="1" rowspan="3">
		<tr><td style="background-color: Beige;" /><td style="background-color: Beige;" colspan="3">{@LBL.SPACE}</td></tr>
		<tr class="row_h"><td /><td>[TABLE_NAME]</td><td colspan="2">[T_NAME]</td></tr>
	</og:tbody>
	<og:tbody rowspan="1" >
		<tr><td>[NN]</td><td>[NAME_JA]</td><td>[CLM]</td><td>[CLS_NAME]</td></tr>
	</og:tbody>
</og:view>

<jsp:directive.include file="/jsp/common/htmlend.jsp" />
</jsp:root>
