<?xml version="1.0" encoding="UTF-8" ?>
<jsp:root
	xmlns:jsp="http://java.sun.com/JSP/Page"
	xmlns:og="hybs-taglib.tld" 
	version="2.0">
<jsp:directive.page language="java" contentType="text/html; charset=UTF-8" />

<jsp:directive.page import="org.opengion.hayabusa.common.*,org.opengion.hayabusa.db.*" />
<og:head headType="init" />
<og:comment
	system	= "GF:エンジンサンプル"
	pgid	= "GF2050"
	title	= "定義ファイル取込"
	date	= "2008/10/27"
	author	= "Hiroki.Nakamura"
	text	= ""
	version	= "001"
/>

<og:columnCheck
	command   = "{@command}"
	columns   = "SYSTEM_ID,TABLE_NAME,CLM"
/>

<og:query command="{@command}" debug="{@debug}" maxRowCount="{@maxRowCount}">
		delete from GF80
		where  SYSTEM_ID = '{@SYSTEM_ID}'
		and    TBLSYU    = 'T'
		and    FGJ      in  ('0','1')
</og:query>

<og:query command="{@command}" debug="{@debug}" maxRowCount="30000">
		select SYSTEM_ID,TBLSYU,TABLE_NAME,CLM,SEQNO,NAME_JA,CLS_NAME,USE_LENGTH,
				DATA_DEFAULT,NOT_NULL,UNIQ,FGJ,DYSET,DYUPD,USRSET,USRUPD,PGUPD,RENDERER,EDITOR,DBTYPE,BIKO
		from   GF05
		where  SYSTEM_ID = '{@SYSTEM_ID}'
		and    TBLSYU    = '3'
		and    FGJ      in  ('0','1')
</og:query>

<og:tableUpdate
	selectedAll = "true"
	command		= "ENTRY"
	queryType	= "JDBCTableUpdate">
		INSERT INTO GF80
			( SYSTEM_ID,TBLSYU,TABLE_NAME,SEQNO,CLM_NAME,CLM,CLS_NAME,PHY_LENGTH,USE_LENGTH,
				NOT_NULL,RENDERER,EDITOR,DBTYPE,
				DATA_DEFAULT,BIKO,UNIQ,FGJ,DYSET,DYUPD,USRSET,USRUPD,PGUPD )
		VALUES
			( [SYSTEM_ID],'T',[TABLE_NAME],[SEQNO],[NAME_JA],[CLM],[CLS_NAME],[USE_LENGTH],[USE_LENGTH],
				[NOT_NULL],[RENDERER],[EDITOR],[DBTYPE],
				[DATA_DEFAULT],[BIKO],[UNIQ],'1','{@USER.YMDH}','{@USER.YMDH}','{@USER.ID}','{@USER.ID}','{@GUI.KEY}' )
</og:tableUpdate>

<og:query command="{@command}" debug="{@debug}" maxRowCount="{@maxRowCount}">
		UPDATE GF80 A
			SET A.NAME_JA =
				(SELECT B.NAME_JA FROM GF02 B
					WHERE B.TBLSYU = '3'
					AND B.SYSTEM_ID = A.SYSTEM_ID
					AND B.TABLE_NAME = A.TABLE_NAME
					AND B.FGJ IN ('0','1'))
		WHERE A.SYSTEM_ID 	= '{@SYSTEM_ID}'
		AND A.TBLSYU		= 'T'
</og:query>

<og:query command="{@command}" debug="{@debug}" maxRowCount="{@maxRowCount}">
		UPDATE GF80 A
			SET A.UK = (SELECT B.SEQNO FROM GF07 B
							WHERE B.TBLSYU = '3'
							AND B.TABLE_NAME = A.TABLE_NAME
							AND B.INDEX_NAME = A.TABLE_NAME || '_UQ'
							AND B.CLM = A.CLM
							AND B.FGJ IN ('0','1')),
				A.IXA = (SELECT B.SEQNO FROM GF07 B
							WHERE B.TBLSYU = '3'
							AND B.TABLE_NAME = A.TABLE_NAME
							AND B.INDEX_NAME = A.TABLE_NAME || '_SA'
							AND B.CLM = A.CLM
							AND B.FGJ IN ('0','1')),
				A.IXB = (SELECT B.SEQNO FROM GF07 B
							WHERE B.TBLSYU = '3'
							AND B.TABLE_NAME = A.TABLE_NAME
							AND B.INDEX_NAME = A.TABLE_NAME || '_SB'
							AND B.CLM = A.CLM
							AND B.FGJ IN ('0','1')),
				A.IXC = (SELECT B.SEQNO FROM GF07 B
							WHERE B.TBLSYU = '3'
							AND B.TABLE_NAME = A.TABLE_NAME
							AND B.INDEX_NAME = A.TABLE_NAME || '_SC'
							AND B.CLM = A.CLM
							AND B.FGJ IN ('0','1')),
				A.IXD = (SELECT B.SEQNO FROM GF07 B
							WHERE B.TBLSYU = '3'
							AND B.TABLE_NAME = A.TABLE_NAME
							AND B.INDEX_NAME = A.TABLE_NAME || '_SD'
							AND B.CLM = A.CLM
							AND B.FGJ IN ('0','1')),
				A.IXE = (SELECT B.SEQNO FROM GF07 B
							WHERE B.TBLSYU = '3'
							AND B.TABLE_NAME = A.TABLE_NAME
							AND B.INDEX_NAME = A.TABLE_NAME || '_SE'
							AND B.CLM = A.CLM
							AND B.FGJ IN ('0','1')),
				A.IXF = (SELECT B.SEQNO FROM GF07 B
							WHERE B.TBLSYU = '3'
							AND B.TABLE_NAME = A.TABLE_NAME
							AND B.INDEX_NAME = A.TABLE_NAME || '_SF'
							AND B.CLM = A.CLM
							AND B.FGJ IN ('0','1')),
				A.IXG = (SELECT B.SEQNO FROM GF07 B
							WHERE B.TBLSYU = '3'
							AND B.TABLE_NAME = A.TABLE_NAME
							AND B.INDEX_NAME = A.TABLE_NAME || '_SG'
							AND B.CLM = A.CLM
							AND B.FGJ IN ('0','1'))
		WHERE A.SYSTEM_ID 	= '{@SYSTEM_ID}'
		AND A.TBLSYU		= 'T'
</og:query>

<og:query command="{@command}" debug="{@debug}" maxRowCount="30000">
		select '' I,TABLE_NAME,NAME_JA,SEQNO,CLM_NAME,CLM,'' as DTYPE,CLS_NAME,
				PHY_LENGTH,USE_LENGTH,UK,IXA,IXB,IXC,IXD,IXE,IXF,IXG,NOT_NULL,C_KEY,F_KEY,
				RENDERER,EDITOR,DBTYPE,DATA_DEFAULT,KBCLM,BIKO,COMMENTS
		from GF80
	<og:where>
		<og:and value = "FGJ         in  ('0','1')"         />
		<og:and value = "SYSTEM_ID   =  '{@SYSTEM_ID}'"     />
		<og:and value = "TBLSYU      = 'T'"                 />
		<og:and value = "TABLE_NAME  like '{@TABLE_NAME}%'" />
		<og:and value = "NAME_JA     like '{@NAME_JA}%'"    />
		<og:and value = "CLM         like '{@CLM}%'"        />
		<og:and value = "CLM_NAME    like '{@CLM_NAME}%'"   />
		<og:and value = "CLS_NAME    = '{@CLS_NAME}'"       />
		<og:and value = "RENDERER    = '{@RENDERER}'"       />
		<og:and value = "EDITOR      = '{@EDITOR}'"         />
		<og:and value = "DBTYPE      = '{@DBTYPE}'"         />
		<og:and value = "NOT_NULL    = '{@NOT_NULL}'"       />
		<og:and value = "USE_LENGTH  = '{@USE_LENGTH}'"     />
		<og:and value = "KBCLM       = '{@KBCLM}'"          />
		<og:and value = "BIKO        like '{@BIKO}%'"       />
	</og:where>
		order by SYSTEM_ID,TBLSYU,TABLE_NAME,SEQNO
</og:query>

<og:tableFilter classId="SEQRESET" keys="SEQ_CLM,INCREMENT" vals="I,1" selectedAll="true" />
<og:tableFilter classId="DTYPE" />

<og:writeTable
	writerClass		= "Excel"
	fileURL			= "{@USER.ID}"
	filename		= "fileout.xls"
/>

<og:forward page="{@SYS.FILE_OUT_URL}{@USER.ID}/fileout.xls" filename="{@LBL.GF80}.xls" />

<jsp:directive.include file="/jsp/common/htmlend.jsp" />
</jsp:root>
