<?xml version="1.0" encoding="UTF-8" ?>
<jsp:root
	xmlns:jsp="http://java.sun.com/JSP/Page"
	xmlns:og="hybs-taglib.tld"
	version="2.0">
<jsp:directive.page language="java" contentType="text/html; charset=UTF-8" />

<og:head headType="result" />
<jsp:directive.include file="/jsp/custom/result_info.jsp" />
<og:comment
	system	= "GF:エンジンサンプル"
	pgid	= "ORA10"
	title	= "DBオブジェクト内容"
	date	= "2008/10/27"
	author	= "Hiroki.Nakamura"
	text	= ""
	version	= "001"
/>

<!-- ワーニングメッセージです。ここでは、登録完了のメッセージを表示します。 -->
<og:errorMessage command="{@command}" clear="{@clear}" displayMsg="{@displayMsg}" />

<!-- 取り消しボタンが押された時に必要です。 -->
<og:entry command = "{@command}" />

<og:query command="{@command}" debug="{@debug}" dbid="{@DBID}" maxRowCount="{@maxRowCount}">
	<jsp:text>
		select OWNER,OBJECT_NAME,OBJECT_TYPE,CREATED,LAST_DDL_TIME,TIMESTAMP,STATUS,'' DEL
		from ALL_OBJECTS
	</jsp:text>
	<og:where>
		<og:and value="OWNER		like '{@OWNER}%'"		/>
		<og:and value="OBJECT_NAME like '{@OBJECT_NAME}%'"	/>
		<og:and value="OBJECT_TYPE in ( {@OBJECT_TYPE} )" multi="true" />
		<og:and value="STATUS		=	 '{@STATUS}'"		/>
	</og:where>
	<og:appear startKey="order by" value="{@ORDER_BY}"
				defaultVal="OWNER,OBJECT_NAME,OBJECT_TYPE" />
</og:query>

<og:viewLink command="{@command}">
	<og:link column="OBJECT_NAME" href="dba_source.jsp" target="_blank" 
		onLink="[OBJECT_TYPE]" markList="FUNCTION,PACKAGE,PACKAGE BODY,PROCEDURE,TYPE,TYPE BODY,TRIGGER"
		keys="command,OWNER,TYPE,NAME,DBID" vals="NEW,[OWNER],[OBJECT_TYPE],[OBJECT_NAME],{@DBID}" />

	<og:link column="OBJECT_NAME" href="dba_table.jsp" target="_blank" 
		onLink="[OBJECT_TYPE]" markList="TABLE,VIEW"
		keys="command,OWNER,TYPE,NAME,DBID" vals="NEW,[OWNER],[OBJECT_TYPE],[OBJECT_NAME],{@DBID}" />

	<og:link column="OBJECT_NAME" href="dba_index.jsp" target="_blank" 
		onLink="[OBJECT_TYPE]" markList="INDEX"
		keys="command,OWNER,TYPE,NAME,DBID" vals="NEW,[OWNER],[OBJECT_TYPE],[OBJECT_NAME],{@DBID}" />

	<og:link column="OBJECT_NAME" href="dba_sequences.jsp" target="_blank" 
		onLink="[OBJECT_TYPE]" markList="SEQUENCE"
		keys="command,OWNER,TYPE,NAME,DBID" vals="NEW,[OWNER],[OBJECT_TYPE],[OBJECT_NAME],{@DBID}" />

	<og:link column="DEL" href="drop.jsp" target="_blank" lbl="MSG0058"
		onLink="[OWNER]" markList="{@SYS.SYSTEM_ID}"
		keys="command,TYPE,NAME,DBID" vals="NEW,[OBJECT_TYPE],[OBJECT_NAME],{@DBID}" />
</og:viewLink>

<og:equals val1="{@choice}" val2="{@choice}">
  <og:query command="{@command}" debug="{@debug}" dbid="{@TO_DBID}" maxRowCount="{@maxRowCount}" scope="request">
	<jsp:text>
		select OWNER,OBJECT_NAME,OBJECT_TYPE,CREATED,LAST_DDL_TIME,TIMESTAMP,STATUS,'' DEL
		from ALL_OBJECTS
	</jsp:text>
	<og:where>
		<og:and value="OWNER		like '{@TO_OWNER}%'"		/>
		<og:and value="OBJECT_NAME like '{@OBJECT_NAME}%'"	/>
		<og:and value="OBJECT_TYPE in ( {@OBJECT_TYPE} )" multi="true" />
		<og:and value="STATUS		=	 '{@STATUS}'"		/>
	</og:where>
	<og:appear startKey="order by" value="{@ORDER_BY}"
				defaultVal="OWNER,OBJECT_NAME,OBJECT_TYPE" />
  </og:query>
  <og:tableMerge
		action		= "{@choice}"
		slaveScope	= "request"
		masterKeys	= "OBJECT_NAME,OBJECT_TYPE"
		diffKeys	= "OBJECT_NAME,OBJECT_TYPE"
  />
</og:equals>

<og:view
	viewFormType = "HTMLTable"
	command    = "{@command}"
	writable   = "false"
	startNo    = "{@startNo}"
	pageSize   = "{@pageSize}" />

<jsp:directive.include file="/jsp/common/htmlend.jsp" />
</jsp:root>
