/*
 * Copyright (c) 2009 The openGion Project.
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND,
 * either express or implied. See the License for the specific language
 * governing permissions and limitations under the License.
 */
package org.opengion.plugin.column;

import org.opengion.hayabusa.db.AbstractRenderer;
import org.opengion.hayabusa.db.CellRenderer;
import org.opengion.hayabusa.db.DBColumn;

/**
 * HM レンデラーは、カラムのデータを時：分に分けて表示する場合に
 * 使用するクラスです。
 * 4桁以上6桁以下である必要があります。5,6桁目は無視されます。
 *
 *  カラムの表示に必要な属性は, DBColumn オブジェクト より取り出します。
 * このクラスは、DBColumn オブジェクト毎に１つ作成されます。
 *
 * @og.group データ表示
 * @og.rev 5.4.3.5 (2012/01/12) 新規作成
 * @og.rev 5.5.0.4 (2012/03/16) HMSがdbCellとして作成されていたので修正
 * 
 * @version  5.0
 * @author	 Takahashi Masakazu
 * @since    JDK5.0,
 */
public class Renderer_HM extends AbstractRenderer {
	//* このプログラムのVERSION文字列を設定します。	{@value} */
	private static final String VERSION = "4.0.0 (2005/08/31)" ;

//	private static final CellRenderer dbCell = new Renderer_HMS() ;
	private static final CellRenderer dbCell = new Renderer_HM() ; // 5.5.0.4 (2021/03/16)


	/**
	 * 各オブジェクトから自分のインスタンスを返します。
	 * 自分自身をキャッシュするのか、新たに作成するのかは、各サブクラスの実装に
	 * まかされます。
	 *
	 *
	 * @param   clm DBColumn オブジェクト
	 * @return  CellRenderer オブジェクト
	 */
	public CellRenderer newInstance( final DBColumn clm ) {
		return dbCell;
	}

	/**
	 * データの表示用文字列を返します。
	 *
	 * @param	value String
	 * @return	データの表示用文字列
	 */
	public String getValue( final String value ) {
		String rtn = "";
		if( value != null && 4 <= value.length() && value.length() <= 6 ) {
			StringBuilder buf = new StringBuilder( value.substring( 0,4 ) );
			buf.insert( 2,':' );
			rtn = buf.toString();
		}
		return rtn;
	}
}
