//リストオブジェクト
function List(){ 
	this.head    = null; 
	this.end     = null; 
	this.current = null;
	this.size    = 0;
} 

//リストにノードを追加する
List.prototype.add = function( inObj ){ 
	var node = { obj:inObj ,next:null }; 
	if( this.head ){ 
		this.end.next = node; 
		this.end	  = node; 
	}
	else{ 
		this.head    = node; 
		this.end     = node; 
		this.current = node; 
	} 
	this.size++;
} 

//リストにノードを削除する
List.prototype.del = function( index ){ 
	var node = this.head; 
	for( var i = 0; i < index; i++ ){ 
		node = node.next; 
	} 
	node.next = node.next.next ? node.next.next : null; 
	this.size--;
}

//リストから次のノードを取得する
List.prototype.next = function(){ 
	var node = null;
	if( this.current ){ 
		node		 = this.current.obj; 
		this.current = this.current.next;
	}
	return node; 
} 

//リストから次のノードが存在するかを確認する
List.prototype.hasnext = function(){ 
	if( this.current != null ) return true; 
	return false; 
}

// iBar要素（データノード）
function dataNode( inObjId, inVal, inType, inColor, inBaseVal ){ 
	//iBar要素の属性設定
	this.id     = inObjId;									// オブジェクトID
	this.value  = inVal ? inVal.split(",") : null; 			// 値			 差分枠の場合、評価値
	this.type   = inType; 									// 種別
	this.color  = inColor ? inColor.split(",") : null;		// 色
	this.baseVal= inBaseVal ? inBaseVal.split(",") : null;	// ラベルの場合、参照基準値 差分枠の場合、基準値
}

// 子要素を展開する
function travel( inNode, inRowNodes, inPageNodes ){
	// iBarタグ(nodeType=="1"⇒タグ要素)
	if( inNode.tagName == "IBAR" && inNode.nodeType == "1" ) {
		inRowNodes.add( new dataNode( inNode.id				// オブジェクトID
									 ,inNode.value			// 値
									 ,inNode.type			// 種別
									 ,inNode.color			// 色
									 ,inNode.baseVal		// ラベルの場合、参照基準値
									));
	}
	// 子要素が存在する場合、更に展開する。
	var len = inNode.childNodes.length;
	for( var i = 0; i < len; i++ ){
		travel( inNode.childNodes[i] ,inRowNodes ,inPageNodes );
	}
}
// 数字のコンマ編集
function addComma( inVal ){
	var i;
	var strValue = String( inVal );
	for(i = 0; i < strValue.length/3; i++ ){
		strValue = strValue.replace(/^([+-]?\d+)(\d\d\d)/,"$1,$2");
	}
	return strValue;
}


// メイン処理（画面から呼び出す）
function adjustBar(){
	var rowCount 	 = 0;										// 行数
	var maxValue 	 = 0;										// 行データ（業務データ）の最大値
	var rowValue 	 = 0;										// 行データ（業務データ）の値
	var offsetArrow  = 8; 										// 進捗矢印の幅の半分
	var offsetBorder = 30; 										// 窓の右側の余裕幅
	var winWidth  	 = 500; 									// デフォルト値
	var hLineHeight	 = 100;										// 縦棒の場合セルの高さ＝100px
	var objViewTable = document.getElementById( "viewTable" );	// viewTableのオブジェクト
	var iBarArray 	 = document.getElementsByTagName( "iBar" );	// ページ全体の要素数
	var iHead 		 = document.getElementsByTagName( "iHead" );// グラフヘッダー 2012/04/25 add
	var tdObjs ;
	var pageNodes	 = new List(); 								// 行リスト
	var strBuffer;												// 文字列バッファー
	var strImgLeft;												// 左ボーダー
	var strImgCenter;											// 画像本体
	var strImgRight;											// 右ボーダー
	//
	var errCheck	 = "W";										// 属性エラーチェック
	var rowId    	 = null;									// 行ID(0～)
	var nodeCount 	 = 0;										// 行毎のグラフノードの数
	// 行毎の要素数
	for( i = 0; i < iBarArray.length; i++ ){
		// 必須属性[id]のチェック
		if( iBarArray[i].id   == null ){ 
			alert( "属性[id]を設定してください。" ); 
			return false; 
		}
		// 必須属性[type]のチェック
		if( iBarArray[i].type == null ){ 
			alert( "属性[type]を設定してください。id=" + iBarArray[i].id ); 
			return false;
		}
		// 必須属性[value]のチェック
		if( iBarArray[i].value == null ){ 
			alert( "属性[value]を設定してください。id=" + iBarArray[i].id ); 
			return false;
		}
		// type=="0"(ラベル)、type=="2"(差分枠)の場合の属性[baseVal]チェック
		if(( iBarArray[i].type == "0" || iBarArray[i].type == "2" ) && iBarArray[i].baseVal == null ){ 
			alert( "属性[baseVal]を設定してください。id=" + iBarArray[i].id ); 
			return false;
		}
		// type=="1"(横棒)、type=="6"(縦棒)の場合の属性[value、color]の数チェック
		if( iBarArray[i].type == "1" || iBarArray[i].type == "6" ){ 
			if( iBarArray[i].value.split(",").length != iBarArray[i].color.split(",").length ){
				alert( "属性[value]と属性[color]を一対一で設定してください。id=" + iBarArray[i].id ); 
				return false;
			}
		}

		strBuffer = iBarArray[i].id.split("_");
		if( rowId == null ){
			rowId = strBuffer[ strBuffer.length - 1 ];
			nodeCount++;
			// エラーチェック
			errCheck = iBarArray[i].type < "5" ? "W" : "H";
		}
		else if( rowId == strBuffer[ strBuffer.length - 1 ] ){
			nodeCount++;
			// 横棒と縦棒の混在チェック
			if( iBarArray[i].type < "5" && errCheck == "H" ){
				alert( "横棒と縦棒が混在しています。" );
				return false;
			}else if( iBarArray[i].type >= "5" && errCheck == "W" ){
				alert( "横棒と縦棒が混在しています。" );
				return false;
			}
		}
		else{ 
			break; 
		}
	}
	rowCount = iBarArray.length / nodeCount;					// 行数
	
	var oyaDiv = new Array( rowCount );
	tdObjs	   = new Array( rowCount );
	var maxCap = 0;												// 暴走防止用の引数
	// 各行のグラフ要素をバッファーに入れる
	for( rowId = 0; rowId < rowCount; rowId++ ){
		// 親のTD要素を取得する。
		var objParent = iBarArray[ rowId * nodeCount ].parentNode ;
		while ( objParent != null && objParent.tagName != "TD") {
		    	objParent = objParent.parentNode;
		}
		// 
		tdObjs[rowId] = objParent;
// 2012/04/25 DEL 不評
//		// 横棒の場合のみTDの背景を設定するようにする。
//		if( iBarArray[rowId].type < "5" ){
//			objParent.style.backgroundImage = "url('../image/W_transBg.png')";
//		}
//		else{
//			objParent.style.backgroundImage = "url('../image/H_transBg.png')";
//		}

		// TD中の全要素を分析し、行毎のバーの組合せ状況を取得する。
		var childNodes = objParent.childNodes;
		var rowNodes   = new List();							// 行ノード
		for( i = 0; i < childNodes.length; i++ ){
			if( childNodes[i].tagName == "BR" ){
				pageNodes.add( rowNodes );						// バーの一行分をバッファーに入れる
				rowNodes = new List();							// 新しいノード
				continue;
			}
			travel( childNodes[i] ,rowNodes ,pageNodes );
		}
		// 最終行をバッファーに入れる
		if( rowNodes.size > 0 ){
			pageNodes.add( rowNodes );
		}
		// グラフの外側の描画基盤の作成（TDのすぐ内側にDIVタグを作成する、グラフ要素はこのDIVの相対位置に基づいて描画する。）
		if( iBarArray[rowId].type >= "5" ){
			oyaDiv[rowId] = document.createElement("div");
			// 
			while ( objParent.hasChildNodes() && maxCap < 10000) {
				oyaDiv[rowId].appendChild( childNodes[0] );
				maxCap++;										// 暴走防止
			}
			objParent.appendChild( oyaDiv[rowId] );
		}
	}
////------------------------Debug用（データリストのチェック）----------------------
//	while ( pageNodes.hasnext()) {
//		listSwap = pageNodes.next();
//		while ( listSwap.hasnext()) {
//			a = listSwap.next();
//			alert( "id:" + a.id + "type:" + a.type + " value:" + a.value + " color:" + a.color );
//		}
//		listSwap.current = listSwap.head;									// ポインタをヘッドに移動（次のループで利用させる）
//		alert( "----");
//	}
//	pageNodes.current = pageNodes.head;										// ポインタをヘッドに移動（次のループで利用させる）
////------------------------Debug用------------------------------------------------

	// グラフ行の最大値を取得する。
	var nodeSwap1;
	while( pageNodes.hasnext() ){
		listSwap = pageNodes.next();
		while( listSwap.hasnext() ){
			nodeSwap1 = listSwap.next();
			if( nodeSwap1.type == "1" || nodeSwap1.type == "6" ){
				for( i = 0; nodeSwap1.value && i < nodeSwap1.value.length; i++ ){
					rowValue += nodeSwap1.value[i] * 1;
				}
			}
			// 縦棒の場合、iBar毎に行nodeリスト（listSwap）が作成されている。
			if( nodeSwap1.type == "6" ){
				maxValue = rowValue > maxValue ? rowValue : maxValue;
				rowValue = 0;
			}
		}
		// 横棒の場合、<BR/>タグ区切りで行nodeリスト（listSwap）が作成されている。
		maxValue = rowValue > maxValue ? rowValue : maxValue;

		listSwap.current = listSwap.head;									// ポインタをヘッドに移動（次のループで利用させる）
		rowValue = 0;
	}
	pageNodes.current = pageNodes.head;										// ポインタをヘッドに移動（次のループで利用させる）
	// グラフの表示幅を取得する。
	winWidth = getClientWidth() - objViewTable.offsetWidth - offsetBorder;
	// グラフの外側の描画基盤の設定
	for( rowId = 0; rowId < rowCount; rowId++ ){
		if( oyaDiv[rowId] ){
			oyaDiv[rowId].style.position	 = "relative";
			oyaDiv[rowId].style.height		 = hLineHeight;
			oyaDiv[rowId].style.width		 = winWidth;
			oyaDiv[rowId].style.borderBottom = "solid 1px gray";
		}
	}

	// グラフ要素の出力
	var iBarParent;
	var nodeSwap2;
	var coff = 0;
	var indexHBar ;															// 縦簿の順番
	var totalHeight;														// 積上げ高さ
	var labelLeft = 0;
	while( pageNodes.hasnext() ){
		listSwap = pageNodes.next();										// 各行の要素リストを取り出す。
		rowValue = 0;
		indexHBar= 0;
		while( listSwap.hasnext() ){										// 各要素を行リストから取り出す。
			nodeSwap2 = listSwap.next();
			// 横棒 type 0:ラベル 1:バー本体 2:差分枠 3:保留 4:保留
			// 縦棒 type 5:ラベル 6:バー本体 7:差分枠 8:保留 9:保留
			switch( nodeSwap2.type ){
				// 0～4は横棒の描画
				// 0:ラベルの描画
				case "0":
					iLabel = document.createElement("div");
					iLabel.style.position = "relative";
					iLabel.style.top      = "0";
					iLabel.style.height   = "15";
					iLabel.style.width    = "0";
					iLabel.innerHTML      = "<font size='2'>" + nodeSwap2.value[0] + "</font><br/><img src='../image/arrow.gif'/>";
					// coff(比率) xx%形式または0.xx形式の引数を受け取り、参照基準値(baseVal)に基づいて描画の開始位置を計算する。
					if( nodeSwap2.value[0].indexOf( "%" ) > 0 ){
						coff = nodeSwap2.value[0].replace( "%" ,"") / 100;
					}
					else{
						coff = nodeSwap2.value[0] * 1;
					}
					// ラベルの描画開始位置
					labelLeft = 0;
					if( nodeSwap2.baseVal != null ){
						for( i = 0; i < nodeSwap2.baseVal.length; i++ ){
							labelLeft += nodeSwap2.baseVal[i];
						}
					}
//					iLabel.style.left = Math.round( coff * 1 * nodeSwap2.baseVal / maxValue * winWidth ) - offsetArrow;
					iLabel.style.left = Math.round( coff * 1 * labelLeft / maxValue * winWidth ) - offsetArrow;

					// ラベルの出力
					iBarParent = document.getElementById( nodeSwap2.id ).parentNode;
					iBarObject = document.getElementById( nodeSwap2.id );
					iBarParent.insertBefore( iLabel   ,iBarObject );
					iBarParent.removeChild( iBarObject );
					break;
				// 1:バー本体の描画
				case "1":
					iBarParent = document.getElementById( nodeSwap2.id ).parentNode;
					iBarObject = document.getElementById( nodeSwap2.id );
					for( i = 0; nodeSwap2.value && i < nodeSwap2.value.length; i++){
						switch( nodeSwap2.color[i] ){
							// 青
							case "blue":
								strImgLeft	 = "../image/W_Blue_L.png";
								strImgCenter = "../image/W_Blue.png";
								strImgRight  = "../image/W_Blue_R.png";
								break;
							// 黒
							case "black":
								strImgLeft	 = "../image/W_Black_L.png";
								strImgCenter = "../image/W_Black.png";
								strImgRight  = "../image/W_Black_R.png";
								break;
							// ブラウン
							case "brown":
								strImgLeft	 = "../image/W_Brown_L.png";
								strImgCenter = "../image/W_Brown.png";
								strImgRight  = "../image/W_Brown_R.png";
								break;
							// グリーン
							case "green":
								strImgLeft	 = "../image/W_Green_L.png";
								strImgCenter = "../image/W_Green.png";
								strImgRight  = "../image/W_Green_R.png";
								break;
							// 薄い青
							case "lightBlue":
								strImgLeft	 = "../image/W_LightBlue_L.png";
								strImgCenter = "../image/W_LightBlue.png";
								strImgRight  = "../image/W_LightBlue_R.png";
								break;
							// 薄いグリーン
							case "lightGreen":
								strImgLeft	 = "../image/W_LightGreen_L.png";
								strImgCenter = "../image/W_LightGreen.png";
								strImgRight  = "../image/W_LightGreen_R.png";
								break;
							// オレンジ
							case "orange":
								strImgLeft	 = "../image/W_Orange_L.png";
								strImgCenter = "../image/W_Orange.png";
								strImgRight  = "../image/W_Orange_R.png";
								break;
							// ピンク
							case "pink":
								strImgLeft	 = "../image/W_Pink_L.png";
								strImgCenter = "../image/W_Pink.png";
								strImgRight  = "../image/W_Pink_R.png";
								break;
							// 紫
							case "purple":
								strImgLeft	 = "../image/W_Purple_L.png";
								strImgCenter = "../image/W_Purple.png";
								strImgRight  = "../image/W_Purple_R.png";
								break;
							// 赤
							case "red":
								strImgLeft	 = "../image/W_Red_L.png";
								strImgCenter = "../image/W_Red.png";
								strImgRight  = "../image/W_Red_R.png";
								break;
							// デフォルトは青
							default:
								strImgLeft	 = "../image/W_Blue_L.png";
								strImgCenter = "../image/W_Blue.png";
								strImgRight  = "../image/W_Blue_R.png";
						}
						// 
						iLeft			= document.createElement("img");
						iLeft.src 		= strImgLeft;
						iLeft.height	= 19;
						iLeft.width 	= 1;
						iBarParent.insertBefore( iLeft   ,iBarObject );
						// 
						iCenter       	= document.createElement("img");
						iCenter.src   	= strImgCenter;
						iCenter.id    	= nodeSwap2.id;
						var imgWidth = Math.round( nodeSwap2.value[i] / maxValue * winWidth );
						if( imgWidth >= 2 ){
							imgWidth -= 2;
						}
						iCenter.width 	= imgWidth;						//グラフの幅
//iCenter.style.zIndex="-3";
						iCenter.height	= 19;
						iBarParent.insertBefore( iCenter ,iBarObject );
						// 
						iRight 			= document.createElement("img");
						iRight.src 		= strImgRight;
						iRight.height	= 19;
						iRight.width 	= 1;
						iBarParent.insertBefore( iRight  ,iBarObject );
					}
					iBarParent.removeChild( iBarObject );
					break;
				// 2:差分枠の描画
				case "2":
					// 差分枠の開始位置(left)と幅(width)の計算
//					arrVal1    = nodeSwap2.val1.split(",");
//					arrVal2    = nodeSwap2.val2.split(",");
					arrVal1    = nodeSwap2.value;
					arrVal2    = nodeSwap2.baseVal;
					if( arrVal1 == null || arrVal2 == null){ break; }
					var sumValue1  = 0;
					var sumValue2  = 0;
					var error 	   = 0; //誤差
					// 評価値の取得
					for( i = 0; i < arrVal1.length; i++ ){
						sumValue1 += arrVal1[i] * 1;
						if( Math.round( arrVal1[i] / maxValue * winWidth ) == 0 ){ error += 2; }
					}
					// 基準値取得
					if( arrVal2 != null ){
						for( j = 0; j < arrVal2.length; j++ ){
							sumValue2 += arrVal2[j] * 1;
						}
					}
					// 評価値 > 基準値 の場合のみ枠を描画する。
					if( sumValue1 > sumValue2 ){
						iBarParent = document.getElementById( nodeSwap2.id ).parentNode;
						iBarObject = document.getElementById( nodeSwap2.id );
						iDiv1				 = document.createElement("div");
						iDiv1.style.height   = "0px";
						iDiv2				 = document.createElement("div");
						iDiv2.style.position = "relative";
						iDiv2.id			 = nodeSwap2.id;
						iDiv2.style.border	 = "dashed red 2px;";
						iDiv2.style.top		 = "-19px";
						iDiv2.style.left	 = Math.round( sumValue2 / maxValue * winWidth ) ;
						iDiv2.style.height	 = "17px";
						var diffWidth		 = Math.round( ( sumValue1 - sumValue2 ) / maxValue * winWidth );
						diffWidth = diffWidth > 4 ? diffWidth - 4 : 0;
						iDiv2.style.width 	 = diffWidth + error;
						iDiv1.appendChild( iDiv2 );
						iBarParent.insertBefore( iDiv1, iBarObject );
						iBarParent.removeChild( iBarObject );
					}
					break;
				case "3":													// 保留
					break;
				case "4":													// 保留
					break;
				// 5～9は縦棒の描画
				case "5":													// ラベル
					break;
				case "6":													// バー本体
					iBarParent = document.getElementById( nodeSwap2.id ).parentNode;
					iBarObject = document.getElementById( nodeSwap2.id );
					totalHeight = 0;
					for( i = 0; nodeSwap2.value && i < nodeSwap2.value.length; i++){
						switch( nodeSwap2.color[i] ){
							// 青
							case "blue":
								strImgLeft	 = "../image/H_Blue_L.png";
								strImgCenter = "../image/H_Blue.png";
								strImgRight  = "../image/H_Blue_R.png";
								break;
							// 黒
							case "black":
								strImgLeft	 = "../image/H_Black_L.png";
								strImgCenter = "../image/H_Black.png";
								strImgRight  = "../image/H_Black_R.png";
								break;
							// ブラウン
							case "brown":
								strImgLeft	 = "../image/H_Brown_L.png";
								strImgCenter = "../image/H_Brown.png";
								strImgRight  = "../image/H_Brown_R.png";
								break;
							// グリーン
							case "green":
								strImgLeft	 = "../image/H_Green_L.png";
								strImgCenter = "../image/H_Green.png";
								strImgRight  = "../image/H_Green_R.png";
								break;
							// 薄い青
							case "lightBlue":
								strImgLeft	 = "../image/H_LightBlue_L.png";
								strImgCenter = "../image/H_LightBlue.png";
								strImgRight  = "../image/H_LightBlue_R.png";
								break;
							// 薄いグリーン
							case "lightGreen":
								strImgLeft	 = "../image/H_LightGreen_L.png";
								strImgCenter = "../image/H_LightGreen.png";
								strImgRight  = "../image/H_LightGreen_R.png";
								break;
							// オレンジ
							case "orange":
								strImgLeft	 = "../image/H_Orange_L.png";
								strImgCenter = "../image/H_Orange.png";
								strImgRight  = "../image/H_Orange_R.png";
								break;
							// ピンク
							case "pink":
								strImgLeft	 = "../image/H_Pink_L.png";
								strImgCenter = "../image/H_Pink.png";
								strImgRight  = "../image/H_Pink_R.png";
								break;
							// 紫
							case "purple":
								strImgLeft	 = "../image/H_Purple_L.png";
								strImgCenter = "../image/H_Purple.png";
								strImgRight  = "../image/H_Purple_R.png";
								break;
							// 赤
							case "red":
								strImgLeft	 = "../image/H_Red_L.png";
								strImgCenter = "../image/H_Red.png";
								strImgRight  = "../image/H_Red_R.png";
								break;
							// デフォルトは青
							default:
								strImgLeft	 = "../image/H_Blue_L.png";
								strImgCenter = "../image/H_Blue.png";
								strImgRight  = "../image/H_Blue_R.png";
						}
						// 
						iCenter       	= document.createElement("img");
						iCenter.src   	= strImgCenter;
						iCenter.id    	= nodeSwap2.id;
						swapW 			= Math.floor( winWidth / nodeCount );
						swapW			= swapW > 20 ? 20 : swapW;	//グラフの幅
						iCenter.width 	= swapW ;
						swapH			= Math.round( nodeSwap2.value[i] / maxValue * hLineHeight );
						swapH			= swapH > 0 ? swapH : 0;
						iCenter.height	= swapH;

						iDiv 	      		= document.createElement("div");
						iDiv.style.position = "absolute";
						iDiv.style.top  	= hLineHeight - swapH - totalHeight;
						iDiv.style.left 	= swapW * indexHBar ;
						iDiv.style.fontSize	="0";
						iBarParent.appendChild( iDiv );
						iDiv.appendChild( iCenter );
						totalHeight += swapH;
					}
					iBarParent.removeChild( iBarObject );
					break;
				case "7":													// 差分枠
					break;
				case "8":													// 保留
					break;
				case "9":													// 保留
					break;
				default:
			}
			indexHBar++;
		}
	}
	// ヘッダー情報の出力
	if( iHead && iHead.length > 0 ){
		//
		var headCount  = iHead.length;
		var rank 	   = Math.floor( Math.LOG10E * Math.log( maxValue ));
		var unitVal    = Math.pow( 10, rank );
		var spaceVal   = Math.floor( maxValue / unitVal ) * unitVal / 2 ;
		var spacePix   = ( spaceVal / maxValue ) * winWidth;

		var iDivHead   = new Array( headCount );
		var iDivLbl1   = new Array( headCount );
		var iDivLbl2   = new Array( headCount );
		var widthTD    = iHead[0].parentNode.offsetWidth;
		var heightTD   = iHead[0].parentNode.offsetHeight;
		var heightView = objViewTable.offsetHeight;

		for( i = 0; i < headCount; i++ ){
			iDivHead[i]					 = document.createElement("div");
			iDivHead[i].style.width    	 = widthTD;
			iDivHead[i].style.height   	 = heightTD;
			iDivHead[i].style.position 	 = "relative";
			iDivHead[i].style.margin   	 = "0";
			iDivHead[i].style.padding  	 = "0";
			iDivHead[i].style.border  	 = "0";

			iDivLbl1[i]					 = document.createElement("div");
			iDivLbl1[i].style.position 	 = "absolute";
			iDivLbl1[i].style.left		 = 0;
			iDivLbl1[i].style.width		 = spacePix;
			iDivLbl1[i].style.textAlign	 = "right";
			iDivLbl1[i].innerText		 = addComma( spaceVal )

			iDivLbl1[i].style.borderRight = "dotted gray 1px";

			iDivHead[i].appendChild( iDivLbl1[i] );							// ラベル１の追加

			iDivLbl2[i]	 				 = document.createElement("div");
			iDivLbl2[i].style.position 	 = "absolute";
			iDivLbl2[i].style.left		 = spacePix;
			iDivLbl2[i].style.width		 = spacePix;
			iDivLbl2[i].style.textAlign	 = "right";
			iDivLbl2[i].innerText		 = addComma( spaceVal * 2 )

			iDivLbl2[i].style.borderRight = "dotted gray 1px;"

			iDivHead[i].appendChild( iDivLbl2[i] );							// ラベル２の追加

			iHead[i].parentNode.insertBefore( iDivHead[i], iHead[i] );		// ラベルを画面に描画

			iDivLbl1[i].style.lineHeight	 = iDivHead[i].style.height;
			iDivLbl2[i].style.lineHeight	 = iDivHead[i].style.height;
			iDivLbl1[i].style.verticalAlign  = "middle";
			iDivLbl2[i].style.verticalAlign  = "middle";
			if( i == 0 ){
				iDivLbl1[i].style.height	 = heightView;
				iDivLbl2[i].style.height	 = heightView;
//iDivLbl1[i].style.zIndex="-2";
			}
		}
		// iHeadタグの削除（1ピクセルの幅がとられるため、削除する。）
		for( i = 0; i < iHead.length;  ){
			iHead[0].parentNode.removeChild( iHead[0] );
		}
	}

	//
//	for( i = 0; i < rowCount; i++ ){
//		tdObjs[i].style.backgroundImage    = "url(../image/tdBackground.png)";
//		tdObjs[i].style.backgroundPosition = spacePix * 2;
//		tdObjs[i].style.backgroundRepeat   = "repeat-y";
//	}
};

