/*
 * Decompiled with CFR 0.152.
 */
package org.opengion.hayabusa.common;

import java.io.Serializable;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.servlet.http.HttpSession;
import org.opengion.fukurou.db.ConnectionFactory;
import org.opengion.fukurou.db.DBSimpleTable;
import org.opengion.fukurou.util.Cleanable;
import org.opengion.fukurou.util.Closer;
import org.opengion.fukurou.util.LogWriter;
import org.opengion.hayabusa.common.HybsSystem;
import org.opengion.hayabusa.common.HybsSystemException;
import org.opengion.hayabusa.common.UserSummary;

public final class SystemManager {
    private static final Map<String, UserSummary> map = new HashMap<String, UserSummary>(200);
    private static final List<Cleanable> clearList = new ArrayList<Cleanable>();
    private static final List<Cleanable> contextClearList = new ArrayList<Cleanable>();
    private static final String DEL_SYS = "DELETE FROM GE12 WHERE SYSTEM_ID=? AND KBSAKU='0' AND CONTXT_PATH=? AND PARAM_ID != 'ENGINE_INFO'";
    private static final int C_DEL_SYSTEM_ID = 0;
    private static final int C_DEL_DYSET = 1;

    private SystemManager() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void addSession(HttpSession httpSession) {
        String string = httpSession.getId();
        UserSummary userSummary = (UserSummary)httpSession.getAttribute("h_uInfo");
        if (userSummary != null) {
            Map<String, UserSummary> map = SystemManager.map;
            synchronized (map) {
                SystemManager.map.put(string, userSummary);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void removeSession(String string) {
        UserSummary userSummary;
        Map<String, UserSummary> map = SystemManager.map;
        synchronized (map) {
            userSummary = SystemManager.map.remove(string);
        }
        if (userSummary != null) {
            userSummary.clear();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static UserSummary[] getRunningUserSummary(String string, boolean bl) {
        UserSummary[] userSummaryArray;
        Object object = map;
        synchronized (object) {
            userSummaryArray = map.values().toArray(new UserSummary[map.size()]);
        }
        if (string != null) {
            object = SystemManager.getUserSummaryComparator(string, bl);
            Arrays.sort(userSummaryArray, object);
        }
        return userSummaryArray;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static int getRunningCount() {
        int n;
        Map<String, UserSummary> map = SystemManager.map;
        synchronized (map) {
            String[] stringArray = SystemManager.map.keySet().toArray(new String[SystemManager.map.size()]);
            for (int i = 0; i < stringArray.length; ++i) {
                if (SystemManager.map.get(stringArray[i]) != null) continue;
                SystemManager.map.remove(stringArray[i]);
            }
            n = SystemManager.map.size();
        }
        return n;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static void sessionDestroyed() {
        UserSummary[] userSummaryArray;
        Map<String, UserSummary> map = SystemManager.map;
        synchronized (map) {
            userSummaryArray = SystemManager.map.values().toArray(new UserSummary[SystemManager.map.size()]);
            SystemManager.map.clear();
        }
        for (int i = 0; i < userSummaryArray.length; ++i) {
            userSummaryArray[i].clear();
        }
        System.out.println("  [" + userSummaryArray.length + "] Session Destroyed ");
    }

    public static void addCleanable(Cleanable cleanable) {
        SystemManager.addCleanable(cleanable, false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void addCleanable(Cleanable cleanable, boolean bl) {
        if (bl) {
            List<Cleanable> list = contextClearList;
            synchronized (list) {
                contextClearList.add(cleanable);
            }
        }
        List<Cleanable> list = clearList;
        synchronized (list) {
            clearList.add(cleanable);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void allClear(boolean bl) {
        Cleanable[] cleanableArray;
        List<Cleanable> list = clearList;
        synchronized (list) {
            cleanableArray = clearList.toArray(new Cleanable[clearList.size()]);
            if (bl) {
                clearList.clear();
            }
        }
        for (int i = cleanableArray.length - 1; i >= 0; --i) {
            cleanableArray[i].clear();
        }
        if (bl) {
            Cleanable[] cleanableArray2;
            List<Cleanable> list2 = contextClearList;
            synchronized (list2) {
                cleanableArray2 = contextClearList.toArray(new Cleanable[contextClearList.size()]);
                contextClearList.clear();
            }
            for (int i = cleanableArray2.length - 1; i >= 0; --i) {
                cleanableArray2[i].clear();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     */
    protected static void clearGE12() {
        block8: {
            String string = HybsSystem.sys("HOST_URL");
            String string2 = HybsSystem.sys("RESOURCE_DBID");
            if (string != null && !"**".equals(string)) {
                Connection connection = null;
                PreparedStatement preparedStatement = null;
                try {
                    connection = ConnectionFactory.connection((String)string2, null);
                    preparedStatement = connection.prepareStatement(DEL_SYS);
                    preparedStatement.setString(1, HybsSystem.sys("SYSTEM_ID"));
                    preparedStatement.setString(2, string);
                    int n = preparedStatement.executeUpdate();
                    connection.commit();
                    System.out.println(string + " DELETE FROM GE12[" + n + "]");
                    Closer.stmtClose((Statement)preparedStatement);
                }
                catch (HybsSystemException hybsSystemException) {
                    LogWriter.log((Throwable)hybsSystemException);
                    break block8;
                }
                catch (SQLException sQLException) {
                    Closer.rollback((Connection)connection);
                    LogWriter.log((Throwable)sQLException);
                    {
                        catch (Throwable throwable) {
                            throw throwable;
                        }
                    }
                    Closer.stmtClose((Statement)preparedStatement);
                    ConnectionFactory.close((Connection)connection, null);
                    break block8;
                }
                finally {
                    Closer.stmtClose(preparedStatement);
                    ConnectionFactory.close((Connection)connection, null);
                }
                ConnectionFactory.close((Connection)connection, null);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected static void deleteGUIAccessInfo() {
        String string = HybsSystem.sys("ACCESS_TOKEI_ALIVE_DAYS");
        if (string == null || string.length() == 0) {
            return;
        }
        String string2 = HybsSystem.getDate(HybsSystem.getDate("yyyyMMdd"), -1 * Integer.valueOf(string));
        String[] stringArray = new String[]{"SYSTEM_ID", "DYSET"};
        String[] stringArray2 = new String[stringArray.length];
        stringArray2[0] = HybsSystem.sys("SYSTEM_ID");
        stringArray2[1] = string2 + "000000";
        DBSimpleTable dBSimpleTable = new DBSimpleTable(stringArray);
        dBSimpleTable.setApplicationInfo(null);
        dBSimpleTable.setTable("GE15");
        dBSimpleTable.setWhere("SYSTEM_ID = [SYSTEM_ID] and DYSET <= [DYSET]");
        boolean bl = false;
        try {
            dBSimpleTable.startDelete();
            dBSimpleTable.execute(stringArray2);
            bl = true;
        }
        catch (SQLException sQLException) {
            LogWriter.log((String)"  \u30a2\u30af\u30bb\u30b9\u7d71\u8a08\u30c6\u30fc\u30d6\u30eb\u524a\u9664\u6642\u306b\u30a8\u30e9\u30fc\u304c\u767a\u751f\u3057\u307e\u3057\u305f");
            LogWriter.log((String)sQLException.getMessage());
        }
        finally {
            int n = dBSimpleTable.close(bl);
            System.out.println();
            System.out.println("  \u30a2\u30af\u30bb\u30b9\u7d71\u8a08\u30c6\u30fc\u30d6\u30eb\u304b\u3089\u3001[" + n + "]\u4ef6\u3001\u524a\u9664\u3057\u307e\u3057\u305f\u3002");
        }
    }

    public static Comparator<UserSummary> getUserSummaryComparator(String string, boolean bl) {
        if ("JNAME,ID,ROLES,IPADDRESS,LOGINTIME".indexOf(string) < 0) {
            String string2 = "\u30bd\u30fc\u30c8\u30ad\u30fc\u306b\u306f\u3001JNAME,ID,ROLES,IPADDRESS,LOGINTIME \u4ee5\u5916\u306f\u6307\u5b9a\u3067\u304d\u307e\u305b\u3093\u3002 Key=" + string;
            throw new HybsSystemException(string2);
        }
        Serializable serializable = null;
        if ("JNAME".equals(string)) {
            serializable = new JNAME_Comparator(bl);
        } else if ("ID".equals(string)) {
            serializable = new ID_Comparator(bl);
        } else if ("ROLES".equals(string)) {
            serializable = new ROLES_Comparator(bl);
        } else if ("IPADDRESS".equals(string)) {
            serializable = new IPADDRESS_Comparator(bl);
        } else if ("LOGINTIME".equals(string)) {
            serializable = new LOGINTIME_Comparator(bl);
        }
        return serializable;
    }

    private static final class LOGINTIME_Comparator
    implements Comparator<UserSummary>,
    Serializable {
        private static final long serialVersionUID = 4000L;
        private final boolean direct;

        public LOGINTIME_Comparator(boolean bl) {
            this.direct = bl;
        }

        @Override
        public int compare(UserSummary userSummary, UserSummary userSummary2) {
            int n;
            long l = userSummary.getLoginTime();
            long l2 = userSummary2.getLoginTime();
            int n2 = n = this.direct ? 1 : -1;
            return l == l2 ? 0 : (l < l2 ? n : -n);
        }
    }

    private static final class IPADDRESS_Comparator
    implements Comparator<UserSummary>,
    Serializable {
        private static final long serialVersionUID = 4000L;
        private final boolean direct;

        public IPADDRESS_Comparator(boolean bl) {
            this.direct = bl;
        }

        @Override
        public int compare(UserSummary userSummary, UserSummary userSummary2) {
            String string = userSummary.getIPAddress();
            String string2 = userSummary2.getIPAddress();
            return this.direct ? string.compareTo(string2) : string2.compareTo(string);
        }
    }

    private static final class ROLES_Comparator
    implements Comparator<UserSummary>,
    Serializable {
        private static final long serialVersionUID = 4000L;
        private final boolean direct;

        public ROLES_Comparator(boolean bl) {
            this.direct = bl;
        }

        @Override
        public int compare(UserSummary userSummary, UserSummary userSummary2) {
            String string = userSummary.getRoles();
            String string2 = userSummary2.getRoles();
            return this.direct ? string.compareTo(string2) : string2.compareTo(string);
        }
    }

    private static final class ID_Comparator
    implements Comparator<UserSummary>,
    Serializable {
        private static final long serialVersionUID = 4000L;
        private final boolean direct;

        public ID_Comparator(boolean bl) {
            this.direct = bl;
        }

        @Override
        public int compare(UserSummary userSummary, UserSummary userSummary2) {
            String string = userSummary.getUserID();
            String string2 = userSummary2.getUserID();
            return this.direct ? string.compareTo(string2) : string2.compareTo(string);
        }
    }

    private static final class JNAME_Comparator
    implements Comparator<UserSummary>,
    Serializable {
        private static final long serialVersionUID = 4000L;
        private final boolean direct;

        public JNAME_Comparator(boolean bl) {
            this.direct = bl;
        }

        @Override
        public int compare(UserSummary userSummary, UserSummary userSummary2) {
            String string = userSummary.getJname();
            String string2 = userSummary2.getJname();
            return this.direct ? string.compareTo(string2) : string2.compareTo(string);
        }
    }
}

