/**************************************************************************/
/* GE81 ( 新着情報テーブル )                                              */
/*                                                                        */
/* Created : 2012/07/28 16:35:00                                          */
/**************************************************************************/
CREATE TABLE GE81 (
   UNIQ      NUMBER(9)         DEFAULT 0   NOT NULL      /* 10  ユニークキー   */
 , SYSTEM_ID VARCHAR2(10)                  NOT NULL      /* 20  システムID     */
 , SYSCODE   VARCHAR2(20)      DEFAULT '*' NOT NULL      /* 30  システムコード */
 , CDDEG     VARCHAR2(1)                                 /* 40  重要度         */
 , TITLE     VARCHAR2(300)                               /* 50  タイトル       */
 , NAIYO     VARCHAR2(4000)                              /* 60  内容           */
 , DYSTRD    VARCHAR2(8)                   NOT NULL      /* 70  掲載開始日     */
 , DYENDD    VARCHAR2(8)                   NOT NULL      /* 80  掲載終了日     */
 , BUSHOD    VARCHAR2(100)                               /* 90  掲載部署       */
 , MAND      VARCHAR2(50)                                /* 100 掲載者         */
 , TEL       VARCHAR2(20)                                /* 110 電話番号       */
 , MAILAD    VARCHAR2(100)                               /* 120 メールアドレス */
 , FILE1     VARCHAR2(200)                               /* 130 ファイル1      */
 , FILE2     VARCHAR2(200)                               /* 140 ファイル２     */
 , FILE3     VARCHAR2(200)                               /* 150 ファイル３     */
 , FILEPATH  VARCHAR2(200)                               /* 160 ファイルパス   */
 , TAG       VARCHAR2(200)                               /* 170 タグキーワード */
 , FGJ       VARCHAR2(1)       DEFAULT '1' NOT NULL      /* 180 状態フラグ     */
 , DYSET     VARCHAR2(14)                                /* 190 登録日時       */
 , PGSET     VARCHAR2(10)                                /* 200 作成PG         */
 , PGPSET    VARCHAR2(10)                                /* 210 作成親PG       */
 , USRSET    VARCHAR2(10)                                /* 220 作成社員       */
 , DYUPD     VARCHAR2(14)                                /* 230 更新日時       */
 , PGUPD     VARCHAR2(10)                                /* 240 更新PG         */
 , PGPUPD    VARCHAR2(10)                                /* 250 更新親PG       */
 , USRUPD    VARCHAR2(10)                                /* 260 更新者         */
)
TABLESPACE GETBL01
STORAGE( INITIAL 256K NEXT 16K PCTINCREASE 0 );


CREATE SEQUENCE GE81S00 
INCREMENT BY 1 START WITH 1 MAXVALUE 999999999 CYCLE NOCACHE;


CREATE OR REPLACE TRIGGER GE81T00 
BEFORE INSERT ON GE81
FOR EACH ROW 
BEGIN 
SELECT GE81S00.NEXTVAL INTO :NEW.UNIQ FROM DUAL; 
END; 
/

