/*
 * Decompiled with CFR 0.152.
 */
package org.opengion.plugin.io;

import java.text.DecimalFormat;
import java.text.NumberFormat;
import org.apache.poi.ss.usermodel.Cell;
import org.apache.poi.ss.usermodel.CreationHelper;
import org.apache.poi.ss.usermodel.DateUtil;
import org.apache.poi.ss.usermodel.FormulaEvaluator;
import org.apache.poi.ss.usermodel.RichTextString;
import org.apache.poi.ss.usermodel.Row;
import org.apache.poi.ss.usermodel.Workbook;
import org.opengion.fukurou.util.HybsDateUtil;
import org.opengion.fukurou.util.StringUtil;
import org.opengion.hayabusa.common.HybsSystem;
import org.opengion.hayabusa.common.HybsSystemException;

class HeaderData {
    private String[] names;
    private int[] index;
    private int columnSize = 0;
    private boolean nameNoSet = true;
    private boolean useNumber = true;
    private String[] orgNames;
    private Cell lastCell = null;

    HeaderData() {
    }

    void setUseNumber(boolean bl) {
        this.useNumber = bl;
    }

    boolean setColumns(String string) {
        if (string != null && string.length() > 0) {
            this.names = StringUtil.csv2Array((String)string);
            this.columnSize = this.names.length;
            this.index = new int[this.columnSize];
            int n = this.useNumber ? 1 : 0;
            for (int i = 0; i < this.columnSize; ++i) {
                this.index[i] = n++;
            }
            this.nameNoSet = false;
            return true;
        }
        return false;
    }

    boolean isSkip(Row row) {
        if (row == null) {
            return true;
        }
        short s = row.getFirstCellNum();
        Cell cell = row.getCell((int)s);
        String string = this.getValue(cell);
        if (string != null && string.length() > 0) {
            if (this.nameNoSet) {
                if (string.equalsIgnoreCase("#Name")) {
                    this.makeNames(row);
                    this.nameNoSet = false;
                    return true;
                }
                if (string.charAt(0) == '#') {
                    return true;
                }
                String string2 = "#NAME \u304c\u898b\u3064\u304b\u308b\u524d\u306b\u30c7\u30fc\u30bf\u304c\u898b\u3064\u304b\u308a\u307e\u3057\u305f\u3002" + HybsSystem.CR + "\u53ef\u80fd\u6027\u3068\u3057\u3066\u3001\u30d5\u30a1\u30a4\u30eb\u304c\u3001\u30cd\u30a4\u30c6\u30a3\u30d6Excel\u3067\u306a\u3044\u4e8b\u304c\u8003\u3048\u3089\u308c\u307e\u3059\u3002" + HybsSystem.CR;
                throw new HybsSystemException(string2);
            }
            if (string.charAt(0) == '#') {
                return true;
            }
        }
        return this.nameNoSet;
    }

    private void makeNames(Row row) {
        int n = this.useNumber ? 1 : 0;
        short s = row.getLastCellNum();
        this.orgNames = new String[s + 1];
        int n2 = s - n;
        String[] stringArray = new String[n2];
        int[] nArray = new int[n2];
        for (int i = n; i <= s; ++i) {
            String string;
            Cell cell = row.getCell(i);
            this.orgNames[i] = string = this.getValue(cell);
            if (string == null || string.length() <= 0) continue;
            stringArray[this.columnSize] = string;
            nArray[this.columnSize] = i;
            ++this.columnSize;
        }
        if (n2 == this.columnSize) {
            this.names = stringArray;
            this.index = nArray;
        } else {
            this.names = new String[this.columnSize];
            this.index = new int[this.columnSize];
            System.arraycopy(stringArray, 0, this.names, 0, this.columnSize);
            System.arraycopy(nArray, 0, this.index, 0, this.columnSize);
        }
    }

    String[] getNames() {
        return this.names;
    }

    int getColumnSize() {
        return this.columnSize;
    }

    String[] row2Array(Row row) {
        if (this.nameNoSet) {
            String string = "#NAME \u304c\u898b\u3064\u304b\u308b\u524d\u306b\u30c7\u30fc\u30bf\u304c\u898b\u3064\u304b\u308a\u307e\u3057\u305f\u3002";
            throw new HybsSystemException(string);
        }
        String[] stringArray = new String[this.columnSize];
        for (int i = 0; i < this.columnSize; ++i) {
            Cell cell = row.getCell(this.index[i]);
            stringArray[i] = this.getValue(cell);
        }
        return stringArray;
    }

    private String getValue(Cell cell) {
        this.lastCell = cell;
        if (cell == null) {
            return null;
        }
        String string = "";
        int n = cell.getCellType();
        switch (n) {
            case 0: {
                string = this.getNumericTypeString(cell);
                break;
            }
            case 1: {
                RichTextString richTextString = cell.getRichStringCellValue();
                if (richTextString == null) break;
                string = richTextString.getString();
                break;
            }
            case 2: {
                Workbook workbook = cell.getSheet().getWorkbook();
                CreationHelper creationHelper = workbook.getCreationHelper();
                FormulaEvaluator formulaEvaluator = creationHelper.createFormulaEvaluator();
                try {
                    string = this.getValue(formulaEvaluator.evaluateInCell(cell));
                    break;
                }
                catch (Throwable throwable) {
                    String string2 = "\u30bb\u30eb\u30d5\u30a9\u30fc\u30de\u30c3\u30c8\u304c\u89e3\u6790\u3067\u304d\u307e\u305b\u3093\u3002[" + cell.getCellFormula() + "]" + this.getLastCellMsg();
                    throw new HybsSystemException(string2, throwable);
                }
            }
            case 4: {
                string = String.valueOf(cell.getBooleanCellValue());
                break;
            }
            case 3: 
            case 5: {
                break;
            }
        }
        return string.trim();
    }

    private String getNumericTypeString(Cell cell) {
        String string;
        double d = cell.getNumericCellValue();
        if (DateUtil.isCellDateFormatted((Cell)cell)) {
            string = HybsDateUtil.getDate((long)DateUtil.getJavaDate((double)d).getTime(), (String)"yyyyMMddHHmmss");
        } else {
            NumberFormat numberFormat = NumberFormat.getInstance();
            if (numberFormat instanceof DecimalFormat) {
                ((DecimalFormat)numberFormat).applyPattern("#.####");
            }
            string = numberFormat.format(d);
        }
        return string;
    }

    String getLastCellMsg() {
        String string = null;
        if (this.lastCell != null) {
            int n = this.lastCell.getRowIndex();
            int n2 = this.lastCell.getColumnIndex();
            int n3 = this.lastCell.getColumnIndex();
            string = "Row=" + n + ",Cel=" + n2;
            if (this.orgNames != null && this.orgNames.length < n3) {
                string = string + ", NAME=" + this.orgNames[n3];
            }
        }
        return string;
    }
}

