<?xml version="1.0" encoding="UTF-8" ?>
<jsp:root
	xmlns:jsp="http://java.sun.com/JSP/Page"
	xmlns:og="hybs-taglib.tld"
	version="2.0">
<jsp:directive.page language="java" contentType="text/html; charset=UTF-8" />

<og:head headType="result" useGantt="false" useScrollBar="false">
	<link rel="stylesheet" type="text/css"  href="../common/option/adjustGantTable.css?v={@USER.YMDH}" />
</og:head>

<jsp:directive.include file="/jsp/custom/result_info.jsp" />

<og:comment
	system	= "GF:エンジンサンプル"
	pgid	= "GF7218"
	title	= "積上げガント（内部積上)"
	date	= "2012/11/17"
	author	= "Takahashi Masakazu"
	text	= ""
	version	= "001"
/>
<!--製番未入力の場合 -->
<og:query command="{@command}" debug="{@debug}" maxRowCount="{@maxRowCount}">
	SELECT	 A.PN																	PN		
			,A.NOORDER																NOORDER		
			,A.SUORDER																SUORDER
			,A.DYORDER																DYJYU
			,TO_CHAR( CAST(A.DYORDER AS DATE) ,'YYYYMMDD' )							MARK_DAY1
			,TO_CHAR( CAST(A.DYORDER AS DATE) + 3 ,'YYYYMMDD' )						MARK_DAY2
			,A.DYORDER																DYJYU1
			,A.DYNOKI																DYNOKI
			,A.DYNOKI																DYNOKI2
			,DECODE( MOD(ROWNUM ,10) 
				,0 ,'black'
				,1 ,'lightblue' 
				,2 ,'blue' 
				,3 ,'lightgreen' 
				,4 ,'green' 
				,5 ,'orange' 
				,6 ,'pink' 
				,7 ,'red' 
				,8 ,'brown' 
				,9 ,'purple' 
			 ) COLOR
			 ,ROWNUM*0.4+0.6 		as COSTCLM
			,1																		CAPACITY
	FROM GF45 A
	<og:where>
		<og:and value="NOORDER = '{@NOORDER}'" />
		<og:and value="DYORDER IS NOT NULL" />
	</og:where>
	<og:appear startKey="ORDER BY" value="NOORDER,PN" defaultVal="NOORDER,PN" />
</og:query>
<og:value command="SQL">
	SELECT	 min( A.DYORDER  )														MIN_DATE
			,TO_CHAR(ADD_MONTHS( TO_DATE( MIN( A.DYORDER )) ,3) ,'YYYYMMDD' )		MAX_DATE
	FROM GF45 A
</og:value>

<og:view
	viewFormType = "HTMLStackedGanttTable"
	command		 = "{@command}"
	writable	 = "false"
	useScrollBar = "false"
	useParam	 = "true"
	numberType = "none"
>
<!-- stackParamでstackColumnsを指定しなかった場合はcustomTableとほぼ同じ処理となる -->
<og:stackParam
	stackColumns = "NOORDER"
	innerStack="true"
	costColumns = "COSTCLM,DYJYU1,MARK_DAY2"
	stackHoliday="{@stackHoliday}"
/>
<og:thead rowspan="2">
	<tr>
		<td>					[NOORDER]			</td>
		<td rowspan="2" class="gantt zoom{@SZOOM}" style="text-align:left;background-image: url('../image/stackBG{@SZOOM}.gif');" >
            <div style="position:relative;left:0px;z-index:101; " height="100%" width="100%" >
                <og:stackHeader
                    startDate      = "{@MIN_DATE}"
                    endDate        = "{@MAX_DATE}"
                    zoom           = "{@SZOOM}"
                    calDB          = "GE13"
					arg1		   = "A"
                />
			</div>
		</td>
	</tr>
</og:thead>
<og:tbody rowspan="2">
	<tr>
		<td>					[NOORDER]			</td>
	</tr>
</og:tbody>
</og:view>


<jsp:directive.include file="/jsp/common/htmlend.jsp" />
</jsp:root>
