/*
 * Copyright (c) 2009 The openGion Project.
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND,
 * either express or implied. See the License for the specific language
 * governing permissions and limitations under the License.
 */
package org.opengion.plugin.table;

/**
 * TableFilter_TABLE_SQLSERVER は、TableUpda インターフェースを継承した、DBTableModel 処理用の
 * 実装クラスです。とくに、SQLServer用のDB定義スクリプトを作成します。
 *
 * ここでは、テーブル一覧の検索結果より、GF05 のテーブルカラム定義テーブルから
 * 必要な情報を取得し、テーブル作成スクリプトを作成します。
 * 出力ファイルは、テーブル名＋"S.sql" という命名規則で作成します。
 * 検索では、(SYSTEM_ID,TBLSYU,TABLE_NAME,NAME_JA,TABLESPACE_NAME,INITIAL_EXTENT,NEXT_EXTENT,COMMENTS)
 * の項目を取得する必要があります。
 *
 * @og.rev 4.0.0 (2005/08/31) 新規作成
 *
 * @version  0.9.0  2000/10/17
 * @author   Kazuhiko Hasegawa
 * @since    JDK1.1,
 */
public class TableFilter_TABLE_SQLSERVER extends TableFilter_TABLE {
	//* このプログラムのVERSION文字列を設定します。	{@value} */
	private static final String VERSION = "5.1.1.0 (2009/12/01)" ;

	/**
	 * 各行部分(カラム定義)の処理を実行します。
	 *
	 * @og.rev 5.1.1.0 (2009/12/01) 各カラムの説明を追加
	 *
	 * @param	data	１行分のデータ配列
	 * @param	first	最初の行かどうか[true:最初/false:それ以降]
	 *
	 * @return	各行部分(カラム定義)配列
	 */
	@Override
	protected String[] makeLineList( final String[] data,final boolean first ) {

		String clsName = data[GF05_CLS_NAME] ;

		// 5.1.1.0 (2009/12/01) 各カラムの説明文を 入れたくない場合は、null を設定する。
		if( isXml ) { data[GF05_NAME_JA] = null; }

		if( "UNIQ".equalsIgnoreCase( data[GF05_CLM] ) || "UNIQSEQ".equalsIgnoreCase( data[GF05_CLM] ) ) {
			data[GF05_CLS_NAME]     = "int IDENTITY(1,1)";
			data[GF05_DATA_DEFAULT] = null;
			data[GF05_NOT_NULL]     = null;
			data[GF05_USE_LENGTH]   = null;
		}
		else if( clsName == null || clsName.length() == 0 || clsName.startsWith( "VARCHAR" ) ) {
			data[GF05_CLS_NAME] = "varchar" ;
		}
		else if( clsName.startsWith( "CLOB" ) ) {
			data[GF05_CLS_NAME]     = "text";
			data[GF05_DATA_DEFAULT] = null;
			data[GF05_NOT_NULL]     = null;
			data[GF05_USE_LENGTH]   = null;
		}
		else if( clsName.startsWith( "DATE" ) ) {
			data[GF05_CLS_NAME]     = "datetime";
			data[GF05_DATA_DEFAULT] = null;
			data[GF05_NOT_NULL]     = null;
			data[GF05_USE_LENGTH]   = null;
		}
		else if( clsName.startsWith( "NUMBER" ) || clsName.startsWith( "LONG" ) ) {
			String len = data[GF05_USE_LENGTH] ;
			if( len.indexOf( ',' ) >= 0 ) {		// カンマがある
				data[GF05_CLS_NAME] = "decimal";
				data[GF05_USE_LENGTH] = null;
			}
			else if( Integer.parseInt( len ) >= 10 ) {	// １０桁以上
				data[GF05_CLS_NAME] = "float";
				data[GF05_USE_LENGTH] = null;
			}
			else {
				data[GF05_CLS_NAME] = "int";
				data[GF05_USE_LENGTH] = null;
			}
		}

		return super.makeLineList( data,first );
	}

	/**
	 * 定義の最後の部分の処理を実行します。
	 *
	 * @param	clmNo	カラム番号配列
	 * @param	data	１行分のデータ配列
	 *
	 * @return	定義の最後の部分
	 */
	@Override
	protected String makeEndLine( final int[] clmNo,final String[] data ) {
		return ( isXml ? ")" + EXEC_END_TAG : ");" );
	}

	/**
	 * ユニークシーケンスの作成処理を実行します。
	 *
	 * @param	clmNo	カラム番号配列
	 * @param	data	１行分のデータ配列
	 *
	 * @return	ユニークシーケンス
	 */
	@Override
	protected String makeUniqSeq( final int[] clmNo,final String[] data ) {
		return "";
	}

	/**
	 * ユニークシーケンスと関連付けるトリガの作成処理を実行します。
	 *
	 * @param	clmNo		カラム番号配列
	 * @param	data		１行分のデータ配列
	 * @param   uniqName	ユニークトリガ名
	 *
	 * @return	ユニークシーケンスと関連付けるトリガ
	 */
	@Override
	protected String makeUniqTrig( final int[] clmNo,final String[] data, final String uniqName ) {
		return "";
	}
}
