/*
 * Decompiled with CFR 0.152.
 */
package org.opengion.hayabusa.resource;

import java.util.HashMap;
import java.util.Locale;
import java.util.Map;
import org.opengion.fukurou.db.DBUtil;
import org.opengion.fukurou.util.ApplicationInfo;
import org.opengion.fukurou.util.StringUtil;
import org.opengion.hayabusa.common.HybsSystem;

public final class DataRole {
    private static final String QUERY_GEA06_SELECT = "select CLM, CVALUE, VALCDTN from GEA06 where SYSTEM_ID = ? and DROLE = ? and FGJ = '1'";
    private static final int IDX_CLM = 0;
    private static final int IDX_CVALUE = 1;
    private static final int IDX_VALCDTN = 2;
    private static final DataRole FULL_ACCESS_DATAROLE_OBJ = new DataRole(true);
    private static final DataRole FULL_DENY_DATAROLE_OBJ = new DataRole(false);
    private static final String FULL_ACCESS_CONDITION = null;
    private static final String FULL_DENY_CONDITION = " NOT LIKE '%'";
    private static final String FULL_DENY_DROLES_KEY = "--";
    private final Map<String, String> cdtnMap = new HashMap<String, String>(50);
    private final String droles;
    private final String systemId;
    private final ApplicationInfo appInfo;
    private final String DBID = HybsSystem.sys("RESOURCE_DBID");
    private boolean isFullAcess = false;
    private boolean isFullDeny = false;

    private DataRole(boolean bl) {
        this.droles = null;
        this.systemId = null;
        this.appInfo = null;
        if (bl) {
            this.isFullAcess = true;
        } else {
            this.isFullDeny = true;
        }
    }

    private DataRole(String string, String string2, ApplicationInfo applicationInfo) {
        String[] stringArray;
        this.droles = string;
        this.systemId = string2;
        this.appInfo = applicationInfo;
        if (applicationInfo != null) {
            applicationInfo.setModuleInfo("DataRole", null, "CreateInstance");
        }
        if ((stringArray = StringUtil.csv2Array((String)string, (char)'|')) == null || stringArray.length == 0) {
            this.isFullAcess = true;
            return;
        }
        this.makeConditionMap(stringArray);
    }

    private void makeConditionMap(String[] stringArray) {
        String string = null;
        String string2 = null;
        String string3 = null;
        for (int i = 0; i < stringArray.length; ++i) {
            String[] stringArray2 = new String[]{this.systemId, stringArray[i]};
            String[][] stringArray3 = DBUtil.dbExecute((String)QUERY_GEA06_SELECT, (String[])stringArray2, (ApplicationInfo)this.appInfo, (String)this.DBID);
            for (int j = 0; j < stringArray3.length; ++j) {
                string = stringArray3[j][0];
                string2 = stringArray3[j][1];
                string3 = stringArray3[j][2];
                String string4 = this.cdtnMap.get(string);
                string4 = string4 == null ? "" : ("=".equals(string3) || "LIKE".equalsIgnoreCase(string3) ? string4 + " or " : string4 + " and ");
                string4 = string4 + string + " " + string3 + " '" + string2;
                if (string3.toUpperCase(Locale.JAPAN).indexOf("LIKE") >= 0) {
                    string4 = string4 + "%";
                }
                if ((string4 = string4 + "'").indexOf(" and ") >= 0) {
                    string4 = string4.replace(" or ", "and");
                }
                this.cdtnMap.put(string, string4);
            }
        }
    }

    public static DataRole newInstance(String string, String string2, ApplicationInfo applicationInfo) {
        if (string == null || string.length() == 0) {
            return FULL_ACCESS_DATAROLE_OBJ;
        }
        if (FULL_DENY_DROLES_KEY.equals(string)) {
            return FULL_DENY_DATAROLE_OBJ;
        }
        return new DataRole(string, string2, applicationInfo);
    }

    public String getDataRoles() {
        return this.droles;
    }

    public String getCondition(String string) {
        if (this.isFullAcess) {
            return FULL_ACCESS_CONDITION;
        }
        if (this.isFullDeny) {
            return "(" + string + FULL_DENY_CONDITION + ")";
        }
        String string2 = null;
        if (string.indexOf(46) >= 0) {
            String string3 = string.substring(string.lastIndexOf(46) + 1);
            string2 = this.cdtnMap.get(string3);
            if (string2 == null || string2.length() == 0) {
                return "(" + string + FULL_DENY_CONDITION + ")";
            }
            return "(" + string2.replace(string3, string) + ")";
        }
        string2 = this.cdtnMap.get(string);
        if (string2 == null || string2.length() == 0) {
            return "(" + string + FULL_DENY_CONDITION + ")";
        }
        return "(" + string2 + ")";
    }

    public String toString() {
        StringBuilder stringBuilder = new StringBuilder(200);
        stringBuilder.append("droles  : ").append(this.droles).append(HybsSystem.CR);
        return stringBuilder.toString();
    }
}

