/*
 * Decompiled with CFR 0.152.
 */
package org.opengion.plugin.io;

import java.io.BufferedReader;
import java.io.Closeable;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import org.apache.poi.openxml4j.exceptions.InvalidFormatException;
import org.apache.poi.ss.usermodel.Row;
import org.apache.poi.ss.usermodel.Sheet;
import org.apache.poi.ss.usermodel.Workbook;
import org.apache.poi.ss.usermodel.WorkbookFactory;
import org.opengion.fukurou.util.Closer;
import org.opengion.fukurou.util.StringUtil;
import org.opengion.hayabusa.common.HybsSystem;
import org.opengion.hayabusa.common.HybsSystemException;
import org.opengion.hayabusa.db.DBTableModelUtil;
import org.opengion.plugin.io.ExcelUtil;
import org.opengion.plugin.io.HeaderData;
import org.opengion.plugin.io.TableReader_Default;

public class TableReader_Excel
extends TableReader_Default {
    private static final String VERSION = "4.0.0 (2005/08/31)";
    private String filename = null;
    private String sheetName = null;
    private String sheetNos = null;
    private String constKeys = null;
    private String constAdrs = null;
    private String nullBreakClm = null;

    /*
     * Loose catch block
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public void readDBTable() {
        FileInputStream fileInputStream = null;
        HeaderData headerData = null;
        try {
            int n;
            Sheet[] sheetArray;
            Sheet sheet;
            boolean bl = this.isDebug();
            if (bl) {
                System.out.println(" Filename=" + this.filename);
            }
            fileInputStream = new FileInputStream(this.filename);
            Workbook workbook = WorkbookFactory.create((InputStream)fileInputStream);
            if (bl) {
                workbook = ExcelUtil.activeWorkbook(workbook);
            }
            if (this.sheetNos != null && this.sheetNos.length() > 0) {
                sheet = StringUtil.csv2ArrayExt((String)this.sheetNos, (int)(workbook.getNumberOfSheets() - 1));
                sheetArray = new Sheet[((Sheet)sheet).length];
                for (n = 0; n < ((Sheet)sheet).length; ++n) {
                    sheetArray[n] = workbook.getSheetAt(Integer.parseInt((String)sheet[n]));
                }
            } else if (this.sheetName != null && this.sheetName.length() > 0) {
                sheet = workbook.getSheet(this.sheetName);
                if (sheet == null) {
                    String string = "\u5bfe\u5fdc\u3059\u308b\u30b7\u30fc\u30c8\u304c\u5b58\u5728\u3057\u307e\u305b\u3093\u3002 Sheet=[" + this.sheetName + "]";
                    throw new HybsSystemException(string);
                }
                sheetArray = new Sheet[]{sheet};
            } else {
                sheet = workbook.getSheetAt(0);
                sheetArray = new Sheet[]{sheet};
            }
            boolean bl2 = true;
            this.table = DBTableModelUtil.newDBTable();
            n = 0;
            headerData = new HeaderData();
            headerData.setDebug(bl);
            headerData.setUseNumber(this.isUseNumber());
            headerData.setSheetConstData(this.constKeys, this.constAdrs);
            int n2 = -1;
            if (headerData.setColumns(this.columns)) {
                bl2 = false;
                this.table.init(headerData.getColumnSize());
                this.setTableDBColumn(headerData.getNames());
                n2 = this.table.getColumnNo(this.nullBreakClm, false);
            }
            int n3 = this.getSkipRowCount();
            for (int i = 0; i < sheetArray.length; ++i) {
                Sheet sheet2 = sheetArray[i];
                headerData.setSheetConstValues(sheet2);
                int n4 = sheet2.getFirstRowNum();
                if (n4 < n3) {
                    n4 = n3;
                }
                int n5 = sheet2.getLastRowNum();
                if (bl) {
                    System.out.println(" Debug: \u884c\u9023\u756a=" + n + " : Sheet= " + sheet2.getSheetName() + " , \u958b\u59cb=" + n4 + " , \u7d42\u4e86=" + n5);
                }
                for (int j = n4; j <= n5; ++j) {
                    Row row = sheet2.getRow(j);
                    if (headerData.isSkip(row)) continue;
                    if (bl2) {
                        bl2 = false;
                        this.table.init(headerData.getColumnSize());
                        this.setTableDBColumn(headerData.getNames());
                        n2 = this.table.getColumnNo(this.nullBreakClm, false);
                    }
                    if (n < this.getMaxRowCount()) {
                        String[] stringArray = headerData.row2Array(row);
                        if (n2 >= 0 && (stringArray[n2] == null || stringArray[n2].isEmpty())) break;
                        this.setTableColumnValues(stringArray);
                        ++n;
                        continue;
                    }
                    this.table.setOverflow(true);
                }
                if (!bl2) continue;
                String string = "\u6700\u5f8c\u307e\u3067\u3001#NAME \u304c\u898b\u3064\u304b\u308a\u307e\u305b\u3093\u3067\u3057\u305f\u3002" + HybsSystem.CR + "\u30d5\u30a1\u30a4\u30eb\u304c\u7a7a\u304b\u3001\u3082\u3057\u304f\u306f\u640d\u50b7\u3057\u3066\u3044\u308b\u53ef\u80fd\u6027\u304c\u3042\u308a\u307e\u3059\u3002" + HybsSystem.CR;
                throw new HybsSystemException(string);
            }
        }
        catch (IOException iOException) {
            try {
                String string = "\u30d5\u30a1\u30a4\u30eb\u8aad\u8fbc\u307f\u30a8\u30e9\u30fc[" + this.filename + "]";
                if (headerData == null) throw new HybsSystemException(string, (Throwable)iOException);
                string = string + headerData.getLastCellMsg();
                throw new HybsSystemException(string, (Throwable)iOException);
                catch (InvalidFormatException invalidFormatException) {
                    String string2 = "\u30d5\u30a1\u30a4\u30eb\u5f62\u5f0f\u30a8\u30e9\u30fc[" + this.filename + "]";
                    if (headerData == null) throw new HybsSystemException(string2, (Throwable)invalidFormatException);
                    string2 = string2 + headerData.getLastCellMsg();
                    throw new HybsSystemException(string2, (Throwable)invalidFormatException);
                }
            }
            catch (Throwable throwable) {
                Closer.ioClose(fileInputStream);
                throw throwable;
            }
        }
        Closer.ioClose((Closeable)fileInputStream);
    }

    @Override
    public void readDBTable(BufferedReader bufferedReader) {
        String string = "\u3053\u306e\u30af\u30e9\u30b9\u3067\u306f\u5b9f\u88c5\u3055\u308c\u3066\u3044\u307e\u305b\u3093\u3002";
        throw new UnsupportedOperationException(string);
    }

    public void setSheetName(String string) {
        this.sheetName = string;
    }

    public void setSheetNos(String string) {
        this.sheetNos = string;
    }

    public void setSheetConstData(String string, String string2) {
        this.constKeys = string;
        this.constAdrs = string2;
    }

    public void setNullBreakClm(String string) {
        this.nullBreakClm = string;
    }

    public boolean isExcel() {
        return true;
    }

    public void setFilename(String string) {
        this.filename = string;
        if (string == null) {
            String string2 = "\u30d5\u30a1\u30a4\u30eb\u540d\u304c\u6307\u5b9a\u3055\u308c\u3066\u3044\u307e\u305b\u3093\u3002";
            throw new HybsSystemException(string2);
        }
    }
}

