/*
 * Decompiled with CFR 0.152.
 */
package org.opengion.hayabusa.taglib;

import java.io.File;
import java.io.FileFilter;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.Serializable;
import java.util.Arrays;
import java.util.Comparator;
import javax.servlet.jsp.tagext.Tag;
import org.opengion.fukurou.util.Attributes;
import org.opengion.fukurou.util.StringUtil;
import org.opengion.fukurou.util.ToString;
import org.opengion.fukurou.util.XHTMLTag;
import org.opengion.hayabusa.common.HybsSystem;
import org.opengion.hayabusa.common.HybsSystemException;
import org.opengion.hayabusa.taglib.CommonTagSupport;
import org.opengion.hayabusa.taglib.SelectTag;

public class FileOptionTag
extends CommonTagSupport {
    private static final String VERSION = "5.3.4.0 (2011/04/01)";
    private static final long serialVersionUID = 534020110401L;
    private String orderBy = null;
    private boolean desc = false;
    private String from = HybsSystem.sys("FILE_URL");
    private String selValue = null;
    private transient FileFilter filter = null;
    private static final String[] ORDER_BY = new String[]{"NAME", "LASTMODIFIED", "FILE_LENGTH", "LENGTH"};

    @Override
    public int doStartTag() {
        return 2;
    }

    @Override
    public int doAfterBody() {
        return 0;
    }

    @Override
    public int doEndTag() {
        this.debugPrint();
        SelectTag selectTag = (SelectTag)FileOptionTag.findAncestorWithClass((Tag)this, SelectTag.class);
        if (selectTag == null) {
            String string = "\u3053\u306e\u30bf\u30b0\u306f\u3001SelectTag \u306eBODY \u306b\u8a18\u8ff0\u3059\u308b\u5fc5\u8981\u304c\u3042\u308a\u307e\u3059\u3002";
            throw new HybsSystemException(string);
        }
        Comparator<File> comparator = this.makeComparator(this.orderBy, this.desc);
        this.makeLabel(selectTag, comparator);
        return 6;
    }

    @Override
    protected void release2() {
        super.release2();
        this.orderBy = null;
        this.desc = false;
        this.from = HybsSystem.sys("FILE_URL");
        this.filter = null;
        this.selValue = null;
    }

    private Comparator<File> makeComparator(String string, boolean bl) {
        if (string == null) {
            return null;
        }
        Serializable serializable = null;
        if ("NAME".equalsIgnoreCase(string)) {
            serializable = new NameComparator(bl);
        } else if ("LASTMODIFIED".equalsIgnoreCase(string)) {
            serializable = new ModifiedComparator(bl);
        } else if ("FILE_LENGTH".equalsIgnoreCase(string) || "LENGTH".equalsIgnoreCase(string)) {
            serializable = new LengthComparator(bl);
        }
        return serializable;
    }

    private void makeLabel(SelectTag selectTag, Comparator<File> comparator) {
        File file = new File(this.from);
        File[] fileArray = file.listFiles(this.filter);
        boolean bl = selectTag.isMultipleAll();
        if (fileArray != null) {
            Arrays.sort(fileArray, comparator);
            for (int i = 0; i < fileArray.length; ++i) {
                if (fileArray[i].isDirectory()) continue;
                Attributes attributes = new Attributes();
                String string = fileArray[i].getName();
                attributes.set("value", string);
                if (this.selValue != null && this.selValue.equalsIgnoreCase(string) || bl) {
                    attributes.set("selected", "selected");
                }
                attributes.set("body", string);
                selectTag.addOption(XHTMLTag.option((Attributes)attributes));
            }
        }
    }

    public void setValue(String string) {
        this.selValue = StringUtil.nval((String)this.getRequestParameter(string), (String)this.selValue);
    }

    public void setFrom(String string) {
        char c;
        String string2 = StringUtil.nval((String)this.getRequestParameter(string), null);
        if (string2 != null && (c = string2.charAt(string2.length() - 1)) != '/' && c != '\\') {
            string2 = string2 + "/";
        }
        string2 = StringUtil.urlAppend((String)this.from, (String)string2, (String[])new String[0]);
        string2 = StringUtil.urlAppend((String)string2, (String)".", (String[])new String[0]);
        this.from = HybsSystem.url2dir(string2);
    }

    public void setOrderBy(String string) {
        this.orderBy = StringUtil.nval((String)this.getRequestParameter(string), (String)this.orderBy);
        if (this.orderBy != null && !this.check(this.orderBy, ORDER_BY)) {
            StringBuilder stringBuilder = new StringBuilder();
            stringBuilder.append("orderBy \u5c5e\u6027\u306b\u3001\u4e0b\u8a18\u306e\u5c5e\u6027\u540d\u4ee5\u5916\u306e\u5024\u304c\u8a2d\u5b9a\u3055\u308c\u307e\u3057\u305f\u3002");
            stringBuilder.append(HybsSystem.CR);
            stringBuilder.append(" orderBy=[").append(this.orderBy).append("]");
            stringBuilder.append(HybsSystem.CR);
            stringBuilder.append(" orderBy List=[");
            stringBuilder.append(StringUtil.array2csv((String[])ORDER_BY));
            stringBuilder.append("]");
            throw new HybsSystemException(stringBuilder.toString());
        }
    }

    public void setDesc(String string) {
        this.desc = StringUtil.nval((String)this.getRequestParameter(string), (boolean)this.desc);
    }

    protected void setFileFilter(FileFilter fileFilter) {
        this.filter = fileFilter;
    }

    private void writeObject(ObjectOutputStream objectOutputStream) throws IOException {
        objectOutputStream.defaultWriteObject();
    }

    private void readObject(ObjectInputStream objectInputStream) throws IOException, ClassNotFoundException {
        objectInputStream.defaultReadObject();
    }

    @Override
    public String toString() {
        return ToString.title((String)((Object)((Object)this)).getClass().getName()).println("VERSION", (Object)VERSION).println("orderBy", (Object)this.orderBy).println("desc", (Object)this.desc).println("from", (Object)this.from).println("selValue", (Object)this.selValue).println("Other...", (Object)this.getAttributes().getAttribute()).fixForm().toString();
    }

    static class LengthComparator
    implements Comparator<File>,
    Serializable {
        private static final long serialVersionUID = 4000L;
        private final boolean desc;

        public LengthComparator(boolean bl) {
            this.desc = bl;
        }

        @Override
        public int compare(File file, File file2) {
            File file3 = this.desc ? file2 : file;
            File file4 = this.desc ? file : file2;
            return (int)(file3.length() - file4.length());
        }
    }

    static class ModifiedComparator
    implements Comparator<File>,
    Serializable {
        private static final long serialVersionUID = 4000L;
        private final boolean desc;

        public ModifiedComparator(boolean bl) {
            this.desc = bl;
        }

        @Override
        public int compare(File file, File file2) {
            File file3 = this.desc ? file2 : file;
            File file4 = this.desc ? file : file2;
            return (int)(file3.lastModified() - file4.lastModified());
        }
    }

    static class NameComparator
    implements Comparator<File>,
    Serializable {
        private static final long serialVersionUID = 4000L;
        private final boolean desc;

        public NameComparator(boolean bl) {
            this.desc = bl;
        }

        @Override
        public int compare(File file, File file2) {
            File file3 = this.desc ? file2 : file;
            File file4 = this.desc ? file : file2;
            return file3.getName().compareTo(file4.getName());
        }
    }
}

