/*
 * Decompiled with CFR 0.152.
 */
package org.opengion.plugin.query;

import java.sql.CallableStatement;
import java.sql.Connection;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.Map;
import oracle.jdbc.OracleCallableStatement;
import oracle.sql.ARRAY;
import oracle.sql.ArrayDescriptor;
import org.opengion.fukurou.util.Closer;
import org.opengion.fukurou.util.ErrorMessage;
import org.opengion.fukurou.util.StringUtil;
import org.opengion.hayabusa.common.HybsSystem;
import org.opengion.hayabusa.common.HybsSystemException;
import org.opengion.hayabusa.db.AbstractQuery;
import org.opengion.hayabusa.db.DBErrMsg;

public class Query_JDBCErrMsg
extends AbstractQuery {
    private static final String VERSION = "4.0.0.0 (2005/08/31)";

    public void execute() {
        this.execute(null);
    }

    public void execute(String[] stringArray) {
        CallableStatement callableStatement = null;
        ResultSet resultSet = null;
        try {
            Connection connection = this.getConnection();
            callableStatement = this.getConnection().prepareCall(this.getStatement());
            callableStatement.setQueryTimeout(DB_MAX_QUERY_TIMEOUT);
            Map<String, Class<?>> map = connection.getTypeMap();
            map.put("ERR_MSG", DBErrMsg.class);
            ArrayDescriptor arrayDescriptor = ArrayDescriptor.createDescriptor((String)"ARG_ARRAY", (Connection)connection);
            ARRAY aRRAY = new ARRAY(arrayDescriptor, connection, (Object)StringUtil.rTrims((String[])stringArray));
            callableStatement.registerOutParameter(1, 4);
            callableStatement.registerOutParameter(2, 2003, "ERR_MSG_ARRAY");
            callableStatement.registerOutParameter(3, -10);
            ((OracleCallableStatement)callableStatement).setARRAY(4, aRRAY);
            callableStatement.execute();
            int n = callableStatement.getInt(1);
            this.setErrorCode(n);
            if (n < 2) {
                resultSet = ((OracleCallableStatement)callableStatement).getCursor(3);
                this.createTableModel(resultSet);
            }
            if (n > 0) {
                DBErrMsg dBErrMsg;
                ARRAY aRRAY2 = ((OracleCallableStatement)callableStatement).getARRAY(2);
                Object[] objectArray = (Object[])aRRAY2.getArray();
                ErrorMessage errorMessage = new ErrorMessage("Query_JDBCErrMsg Error!!");
                for (int i = 0; i < objectArray.length && (dBErrMsg = (DBErrMsg)objectArray[i]) != null; ++i) {
                    errorMessage.addMessage(dBErrMsg.getErrMsg());
                }
                this.setErrorMessage(errorMessage);
            }
        }
        catch (SQLException sQLException) {
            try {
                this.setErrorCode(8);
                String string = sQLException.getMessage() + ":" + sQLException.getSQLState() + HybsSystem.CR + this.getStatement() + HybsSystem.CR;
                this.rollback();
                this.realClose();
                throw new HybsSystemException(string, (Throwable)sQLException);
            }
            catch (Throwable throwable) {
                Closer.resultClose(resultSet);
                Closer.stmtClose(callableStatement);
                throw throwable;
            }
        }
        Closer.resultClose(resultSet);
        Closer.stmtClose((Statement)callableStatement);
    }
}

