<?xml version="1.0" encoding="UTF-8" ?>
<jsp:root
	xmlns:jsp="http://java.sun.com/JSP/Page"
	xmlns:og="hybs-taglib.tld"
	version="2.0">
<jsp:directive.page language="java" contentType="text/html; charset=UTF-8" />

<og:head headType="query" />
<jsp:directive.include file="/jsp/custom/query_info.jsp" />
<og:comment
	system   = "GE"
	pgid     = "TRANS02"
	title    = "ﾃﾞｰﾓﾝ起動"
	date     = "2008/10/14"
	author   = "M.Takahashi"
	text     = "新規作成"
	version  = "001"
/>

<og:query command="NEW" debug="{@debug}" maxRowCount="{@maxRowCount}">
	SELECT A.SYSTEM_ID || '_' || A.KBREAD || '_' || A.DMN_GRP AS TASKNAME
			,'SET' AS CMD_SET, 'REMOVE' AS CMD_REMOVE, A.SYSTEM_ID
			,A.KBREAD, A.DMN_GRP, MIN(A.DMN_TIME) AS DMN_TIME
			,B.CONTXT_PATH
	FROM GE62 A LEFT OUTER JOIN GE12 B
	ON  B.PARAM_ID = ( 'CONTEXT_INITIAL_CALL_URL_' || A.SYSTEM_ID || '_' || A.KBREAD || '_' || A.DMN_GRP )
	AND B.FGJ = '1'
	WHERE A.FGJ = '1'
	GROUP BY A.SYSTEM_ID,A.KBREAD,A.DMN_GRP,B.CONTXT_PATH
	ORDER BY A.DMN_GRP
</og:query>

<!-- ViewLinkTag は、指定のカラムにリンクを張ります。keysと、valsに、URLエンコードする値を設定します。 -->
<!-- 子要素の LinkTag は、単独でも使用できます。[カラム名] で、検索結果の各行毎の値を使用できます。 -->
<og:viewLink command="NEW">
	<og:link column="CMD_SET" href="result.jsp" target="RESULT"
		keys="command,SYSTEM_ID,KBREAD,DMN_GRP,CMD,NAME_JA,PERIOD"
		vals="NEW,[SYSTEM_ID],[KBREAD],[DMN_GRP],SET,[TASKNAME],[DMN_TIME]" lbl="ENTRY" />
	<og:link column="CMD_REMOVE" href="result.jsp" target="RESULT"
		keys="command,SYSTEM_ID,KBREAD,DMN_GRP,CMD,NAME_JA,AUTORUN"
		vals="NEW,[SYSTEM_ID],[KBREAD],[DMN_GRP],REMOVE,[TASKNAME],[CONTXT_PATH]" lbl="DELETE" />
</og:viewLink>

<div>
<og:message lbl="MSG0078"/>
</div>

<og:view
	viewFormType = "HTMLCustomTable"
	command    = "NEW"
	checked    = "{@checked}"
	startNo    = "{@startNo}"
	pageSize   = "{@pageSize}"
	writable   = "false"
	useScrollBar = "false"
	rowspan    = "1" >
	<og:thead rowspan="1" >
		<tr>
			<td>TaskName</td><td colspan="2">Deamon</td><td>System ID</td><td>AutoRun</td>
			<td>Read Kbn</td><td>Daemon Group</td><td>Daemon Time</td>
		</tr>
	</og:thead>

	<og:tbody rowspan="1">
		<tr>
			<td>[TASKNAME]</td><td>[CMD_SET]</td><td>[CMD_REMOVE]</td><td>[SYSTEM_ID]</td><td>[CONTXT_PATH]</td>
			<td>[KBREAD]</td><td>[DMN_GRP]</td><td>[DMN_TIME]</td>
		</tr>
	</og:tbody>
</og:view>
<br />
<og:link href="result.jsp" target="RESULT" keys="CMD" vals="VIEW" >
[<og:message lbl="QUERY" />]
</og:link>
<og:img src="{@SYS.JSP}/image/ecblank.gif" alt=" " width="10px" height="10px"  />
<og:link href="result.jsp" target="RESULT" keys="CMD" vals="CANCEL" >
[ALL <og:message lbl="RESET" />]
</og:link>

<jsp:directive.include file="/jsp/common/htmlend.jsp" />
</jsp:root>
