<?xml version="1.0" encoding="UTF-8" ?>
<jsp:root
	xmlns:jsp="http://java.sun.com/JSP/Page"
	xmlns:og="hybs-taglib.tld"
	version="2.0">
<jsp:directive.page language="java" contentType="text/html; charset=UTF-8" />

<og:head headType="result" />
<jsp:directive.include file="/jsp/custom/result_info.jsp" />
<og:comment
	system   = "GE:エンジンサンプル"
	pgid     = "GE0007"
	title    = "システムパラメータ"
	date     = "2007/12/12"
	author   = "K.HASEGAWA"
	text     = "ZZZZ"
	version  = "001"
/>

<!-- ワーニングメッセージです。ここでは、登録完了のメッセージを表示します。 -->
<og:errorMessage command="{@command}" clear="{@clear}" displayMsg="{@displayMsg}" />

<og:columnCheck
	command   = "{@command}"
	columns   = "SYSTEM_ID"
/>

<!-- 取り消しボタンが押された時に必要です。 -->
<og:entry command = "{@command}" />

<og:query command = "{@command}" dbid="{@DBID}" maxRowCount="{@maxRowCount}">
		select '1' as WRITABLE,CASE WHEN PARAM_LVL &gt;= '8' THEN '0' ELSE '1' END as WRITABLE,
			SYSTEM_ID,TITLE,PARAM_ID,PARAM,PARAM_LVL,SEQNO,CONTENTS,KBSAKU,CONTXT_PATH,UNIQ,FGJ
		from GE12
		where SYSTEM_ID in ( '{@SYSTEM_ID}','{@AST}' )
	<og:where startKey="and">
		<og:and value = "FGJ		=		'{@FGJ}'"			/>
		<og:and value = "PARAM_ID	like	'{@PARAM_ID}%'"		/>
		<og:and value = "CONTENTS	like	'{@CONTENTS}%'"		/>
		<og:and value = "PARAM		like	'{@PARAM}%'" 		/>
		<og:and value = "CONTXT_PATH like	'{@CONTXT_PATH}%'"	/>
		<og:and value = "KBSAKU	=		'{@KBSAKU}'"		/>
		<og:and value = "PARAM_LVL	=		'{@PARAM_LVL}'"		/>
	</og:where>
	<og:appear startKey = "order by" value = "{@ORDER_BY}"
				defaultVal = "CONTXT_PATH,PARAM_ID,SYSTEM_ID DESC,KBSAKU DESC" />
</og:query>

<!-- PARAM_ID キーでグループ化します。先行優先です。-->
<og:tableMerge
	action        = "GROUP"
	masterKeys    = "PARAM_ID,CONTXT_PATH"
	display       = "false"
/>

<!-- ViewMarkerTag は、指定のカラムをマーキングします。 -->
<og:viewMarker command="{@command}">
	<og:columnMarker column="PARAM" onMark="PASS" markList="[PARAM_ID]" >
		<span>****</span>
	</og:columnMarker>
	<og:columnMarker column="PARAM_ID" onMark="[PARAM_LVL]" markList="5" >
		<span style="background-color:#ccff00">[PARAM_ID]</span>
	</og:columnMarker>
	<og:columnMarker column="PARAM_LVL" onMark="[PARAM_LVL]" markList="012" >
		<span style="background-color:#ff66cc">[PARAM_LVL]</span>
	</og:columnMarker>
</og:viewMarker>

<og:columnEditor column="TITLE"    size="100" />
<og:columnEditor column="CONTENTS" editor="AUTOAREA" parameter="3-15,100-100" />

<form onSubmit="return oneClick();" method="POST" action="forward.jsp" target="RESULT">
<og:writeCheck>
	<og:input name="repeatCount" value="1" lbl="" td="false" size="2"/>
	<og:submit  value="update"   lbl="COPY"      command="COPY"   accesskey="C"
		keys="noWritable" vals="null" />
	<og:submit  value="update"   lbl="MODIFY"    command="MODIFY" accesskey="M"
		keys="noWritable" vals='"SYSTEM_ID,PARAM_ID,PARAM_LVL"' />
	<og:submit  value="update"   lbl="DELETE"    command="DELETE" accesskey="Z"
		keys="columnWritable,logicalDelete" vals="null,true" />
	<og:submit  value="update"   lbl="DELETE_PH" command="DELETE" roles="DEL"
		keys="columnWritable" vals="null" />
	<og:equals val1="{@ACTION}" val2="{@ACTION}" notEquals="true">
		<fieldset style="display:inline;">
			<legend><strong><og:message lbl="INSERT_GE12" /></strong></legend>
			<og:column  name="SYSTEM_ID" useRequestValue="false" td="no" />
			<og:submit  value="update" lbl="COPY" command="COPY"
				keys="noWritable,sysins" vals="null,true" />
		</fieldset>
	</og:equals>
	<br />
</og:writeCheck>

<og:view
	viewFormType = "HTMLCustomTable"
	command    = "{@command}"
	noDisplay  = "UNIQ"
	checked    = "{@checked}"
	startNo    = "{@startNo}"
	pageSize   = "{@pageSize}"
>
<jsp:directive.include file="view.jsp" />
</og:view>
</form>

<jsp:directive.include file="/jsp/common/htmlend.jsp" />
</jsp:root>
