/*
 * Copyright (c) 2009 The openGion Project.
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND,
 * either express or implied. See the License for the specific language
 * governing permissions and limitations under the License.
 */
package org.opengion.hayabusa.db;

/**
 * データベース登録時に、固定値カラムの設定を行う情報を管理するクラスです。
 * 具体的には、
 *     更新フラグ  FGUPD
 *     作成日時    DYSET
 *     作成ＰＧ    PGSET
 *     作成社員    USRSET
 *     更新日時    DYUPD
 *     更新ＰＧ    PGUPD
 *     更新社員    USRUPD
 * などの情報を、INSERT、UPDATE の状況に応じて提供します。
 * 具体的には、サブクラスでの実装になります。
 * 初期設定条件として、テーブル名、ユーザーID,画面ID を受け取ります。
 * 登録時刻は、このオブジェクトが生成された時間を通常は使用します。
 * テーブル名を渡すのは、ワークなど、テーブル単位に処理するカラムが
 * 異なるので、それへの対応です。
 * 処理が簡素化できるように、ルールを規定すべきです。
 *
 * @og.rev 4.1.2.0 (2008/03/12) 新規追加
 * @og.group データ登録
 *
 * @version  4.0
 * @author   Kazuhiko Hasegawa
 * @since    JDK5.0,
 */
public interface DBConstValue {

	/**
	 * 初期化情報を設定します。
	 *
	 * @param	table	テーブル名
	 * @param	user 	ユーザーID
	 * @param	gamen	画面ID
	 */
	void init( String table, String user, String gamen ) ;

	/**
	 * INSERT する場合のキー配列を返します。
	 *
	 * 指定の値がなければ、長さゼロ配列を返します。
	 *
	 * @return	キー配列(非null)
	 */
	String[] getInsertKeys() ;

	/**
	 * INSERT する場合の値配列を返します。
	 *
	 * 指定の値がなければ、長さゼロ配列を返します。
	 *
	 * @return	値配列(非null)
	 */
	String[] getInsertVals() ;

	/**
	 * UPDATE する場合のキー配列を返します。
	 *
	 * 指定の値がなければ、長さゼロ配列を返します。
	 *
	 * @return	キー配列(非null)
	 */
	String[] getUpdateKeys() ;

	/**
	 * UPDATE する場合の値配列を返します。
	 *
	 * 指定の値がなければ、長さゼロ配列を返します。
	 *
	 * @return	値配列(非null)
	 */
	String[] getUpdateVals() ;

	/**
	 * DELETE(論理削除) する場合のキー配列を返します。
	 *
	 * 指定の値がなければ、長さゼロ配列を返します。
	 *
	 * @return	キー配列(非null)
	 */
	String[] getLogicalDeleteKeys() ;

	/**
	 * DELETE(論理削除) する場合の値配列を返します。
	 *
	 * 指定の値がなければ、長さゼロ配列を返します。
	 *
	 * @return	値配列(非null)
	 */
	String[] getLogicalDeleteVals() ;
}
