/****************************************************************************/
/* GE16 ( ﾕｰｻﾞｰﾊﾟﾗﾒｰﾀ定義 )                                                 */
/*                                                                          */
/* Created : 2014/06/13 18:57:36                                            */
/****************************************************************************/
CREATE TABLE GE16 (
   SYSTEM_ID    VARCHAR2 (  10 )                    NOT NULL            /*  10 ｼｽﾃﾑID       */
 , USERID       VARCHAR2 (  10 )                    NOT NULL            /*  20 ﾕｰｻﾞｰID      */
 , PARAM_ID     VARCHAR2 (  50 )                    NOT NULL            /*  30 ﾊﾟﾗﾒｰﾀID     */
 , PARAM        VARCHAR2 ( 500 )                                        /*  40 設定値       */
 , FGCRYPT      VARCHAR2 (   1 )        DEFAULT '0' NOT NULL            /* 120 暗号化ﾌﾗｸﾞ   */
 , UNIQ         NUMBER   (   9 )        DEFAULT 0   NOT NULL            /* 800 ﾕﾆｰｸｷｰ       */
 , FGJ          VARCHAR2 (   1 )        DEFAULT '1' NOT NULL            /* 810 状態ﾌﾗｸﾞ     */
 , DYSET        VARCHAR2 (  14 )                                        /* 820 登録日時     */
 , PGSET        VARCHAR2 (  10 )                                        /* 830 作成PG       */
 , PGPSET       VARCHAR2 (  10 )                                        /* 840 作成親PG     */
 , USRSET       VARCHAR2 (  10 )                                        /* 850 作成社員     */
 , DYUPD        VARCHAR2 (  14 )                                        /* 860 更新日時     */
 , PGUPD        VARCHAR2 (  10 )                                        /* 870 更新PG       */
 , PGPUPD       VARCHAR2 (  10 )                                        /* 880 更新親PG     */
 , USRUPD       VARCHAR2 (  10 )                                        /* 890 更新者       */
)
TABLESPACE GETBL01
STORAGE( INITIAL 16K NEXT 16K PCTINCREASE 0 );

CREATE SEQUENCE GE16S00 
  INCREMENT BY 1 START WITH 1 MAXVALUE 999999999 CYCLE NOCACHE;

CREATE OR REPLACE TRIGGER GE16T00 
  BEFORE INSERT ON GE16
  FOR EACH ROW 
  BEGIN 
    SELECT GE16S00.NEXTVAL INTO :NEW.UNIQ FROM DUAL; 
  END; 
/
