/************************************************************************************/
/* 入力値自動変換機能 (query画面用)                                                 */
/* dbType に従って、カンマやスラッシュの削除を行います                              */
/* 完全にエンジンのチェックと一致しているわけではありません。                       */
/*                                                                                  */
/* S9,R：カンマ削除                                                                 */
/* PN  ：ハイフン削除                                                               */
/* YM,DATE系：スラッシュ削除                                                        */
/* HSM ：コロン削除                                                                 */
/*                                                                                  */
/* @og.rev 5.6.0.3 (2013/01/24) 新規追加                                            */
/* Revision: $Id$                                                                   */
/************************************************************************************/
$(function(){
	setEvent( "textarea,input[type=\"text\"]", "focusout", function(){ queryConvert( this ); } );
});

function queryConvert( obj ) {
	var val , cls ;

	val = obj.value;
	cls = obj.className;
	if( val != null && cls != null ) {
		if( (cls.match( /S9/ ) || cls.match( /R/ )) && !cls.match( /\S+R\S*/ ) && !cls.match( /\S*R\S+/ ) ) {
			obj.value = val.replace(',','');
		}
		else if( cls.match( /PN/ ) ) {
			obj.value = val.replace('-','');
		}
		else if( cls.match( /YM/ ) || cls.match( /DATE/ ) ) {
			obj.value = val.replace('/','');
		}
		else if( cls.match( /HMS/ ) ) {
			obj.value = val.replace(':','');
		}
	}
	return true;
}