/*
 * Decompiled with CFR 0.152.
 */
package org.opengion.hayabusa.common;

import java.io.BufferedReader;
import java.io.File;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.PrintWriter;
import java.io.Reader;
import java.io.UnsupportedEncodingException;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.ArrayList;
import java.util.Locale;
import org.opengion.fukurou.db.DBUtil;
import org.opengion.fukurou.util.Closer;
import org.opengion.fukurou.util.FileUtil;
import org.opengion.fukurou.util.StringUtil;
import org.opengion.fukurou.util.ZipFileUtil;
import org.opengion.fukurou.xml.HybsXMLSave;
import org.opengion.hayabusa.common.HybsSystem;

public final class SystemInstaller {
    private final Connection defConn;
    private final Connection rscConn;
    private final PrintWriter out;
    private final String DBNAME;
    public static final String GE12_XML = "org/opengion/hayabusa/common/GE12.xml";
    public static final String SEL_MAX_ENG = "select PARAM from GE12 where SYSTEM_ID='**' and PARAM_ID='ENGINE_INFO' and FGJ='1' and KBSAKU='0'";
    public static final String SEL_SYS_ENG = "select PARAM from GE12 where SYSTEM_ID=? and PARAM_ID='ENGINE_INFO' and KBSAKU='0' and CONTXT_PATH=? and FGJ='1'";
    private static final String FS = File.separator;
    private static final String APP_BASE = System.getenv("APP_BASE") + FS;

    public SystemInstaller(Connection connection, Connection connection2, PrintWriter printWriter) {
        this.defConn = connection;
        this.rscConn = connection2;
        this.out = printWriter;
        this.DBNAME = DBUtil.getProductName((Connection)connection);
    }

    public void autoInsUpd(String string, String string2, String string3) throws UnsupportedEncodingException {
        String string4 = this.getOldMaxVersion();
        String string5 = this.getOldSystemVersion(string, string3);
        this.out.println("    System Version Information ( " + string + " )");
        this.out.println("      Load Version [ openGion 5.8.0.0 Release5 Builds (14251) ]");
        this.out.println("        -> Resource Version[ " + string4 + " ]");
        this.out.println("        -> System   Version[ " + string5 + " ]");
        if ("none".equalsIgnoreCase(string4)) {
            this.out.println("      !!! openGion ENVIROMENT IS NOT INSTALLED !!!");
            String string6 = System.getenv("INSTALL_CONTEXTS");
            if (string6 == null || string6.length() == 0) {
                this.out.println("        !!! \"INSTALL_CONTEXT\" IS NOT CONFIGURED\" !!!");
                this.out.println("        !!! \"SET ENRIVOMENT PARAMETER NAMED \"INSTALL_CONTEXT\" ON INIT_SCRIPT !!!");
                return;
            }
            this.out.println("      Start Initiall Enviroment Install : install type ( " + string6 + " )");
            String[] stringArray = StringUtil.csv2Array((String)string6);
            for (int i = 0; i < stringArray.length; ++i) {
                this.out.println("        install    ( " + stringArray[i] + " )");
                this.loadXMLScript(EXEC_TYPE.INSTALL, stringArray[i]);
                this.out.println("        completed  ( " + stringArray[i] + " )");
            }
            this.out.println("      Start SystemParameter reload");
            this.dbXMLResourceInsert();
            this.out.println("      completed");
        } else {
            if (string5 == null || string5.compareTo("openGion 5.8.0.0 Release5 Builds (14251)") < 0) {
                this.out.println("      Start Enviroment Update ( " + string2 + " )");
                this.loadXMLScript(EXEC_TYPE.UPDATE, string2);
                this.out.println("      completed               ( " + string2 + " )");
            }
            if (string4 == null || string4.compareTo("openGion 5.8.0.0 Release5 Builds (14251)") < 0) {
                this.out.println("      Start SystemParameter Reload");
                this.dbXMLResourceInsert();
                this.out.println("      completed");
            }
        }
    }

    public void install(File file) {
        String string;
        File[] fileArray;
        String string2 = HybsSystem.sys("REAL_PATH") + HybsSystem.sys("FILE_URL") + System.currentTimeMillis() + FS;
        String string3 = System.getenv("CATALINA_HOME") + FS + "conf" + FS + System.getenv("ENGINE_NAME") + FS + "localhost" + FS;
        this.out.println("      Check Archive File and Enviroment");
        if (!file.exists()) {
            this.out.println("        !!! Archive File does not exists File=[ " + file.getAbsolutePath() + "] !!!");
            this.out.println("        !!! Install Aborted !!! ");
            return;
        }
        ZipFileUtil.unCompress((String)string2, (String)file.getAbsolutePath());
        for (File file2 : fileArray = new File(string2).listFiles()) {
            string = file2.getName();
            if (file2.isDirectory()) {
                File file3 = new File(string2 + string + FS + "WEB-INF" + FS + string + ".xml");
                if (!file3.exists()) {
                    this.out.println("        !!! Context XML Does not exists =[ " + file3.getAbsolutePath() + "] !!!");
                    this.out.println("        !!! Install Aborted !!! ");
                    return;
                }
                File file4 = new File(string3 + string + ".xml");
                if (file4.exists()) {
                    this.out.println("        !!! Context XML File Already Installed File=[ " + file4.getAbsolutePath() + "] !!!");
                    this.out.println("        !!! Install Aborted !!! ");
                    return;
                }
                File file5 = new File(APP_BASE + string);
                if (file5.exists()) {
                    this.out.println("        !!! Context Path Already Exists Path=[ " + file5.getAbsolutePath() + "] !!!");
                    this.out.println("        !!! Install Aborted !!! ");
                    return;
                }
            } else {
                this.out.println("        !!! This Archive is not Installer. Because include FILE not DIRECTORY. File=[ " + string + "] !!!");
                this.out.println("        !!! Install Aborted !!! ");
                return;
            }
            this.out.println("        This Archive includes SYSTEM ( " + string + " ) for Install");
        }
        for (File file2 : fileArray) {
            string = file2.getName();
            this.out.println("      Start Enviroment Install ( " + string + " )");
            FileUtil.copyDirectry((String)(string2 + string), (String)(APP_BASE + string));
            FileUtil.copy((String)(string2 + string + FS + "WEB-INF" + FS + string + ".xml"), (String)(string3 + string + ".xml"));
            this.loadXMLScript(EXEC_TYPE.INSTALL, string);
            this.out.println("      completed                ( " + string + " )");
        }
        this.out.println("      Install Process All Completed.");
    }

    private void loadXMLScript(EXEC_TYPE eXEC_TYPE, String string) {
        String string2 = APP_BASE + string.toLowerCase(Locale.JAPAN) + FS + "db";
        File[] fileArray = new File(string2).listFiles();
        if (fileArray == null || fileArray.length == 0) {
            this.out.println("             DB Folder not found. [" + string2 + "]");
            return;
        }
        String string3 = null;
        for (int i = 0; i < fileArray.length; ++i) {
            if (this.DBNAME.indexOf(fileArray[i].getName()) < 0) continue;
            string3 = fileArray[i].getAbsolutePath();
            break;
        }
        if (string3 == null) {
            this.out.println("             !!! Script Folder for [ " + this.DBNAME + " ] not found !!!");
            return;
        }
        this.execScripts(eXEC_TYPE, string3, this.defConn);
        this.execScripts(eXEC_TYPE, string2 + FS + "common", this.defConn);
        this.execScripts(eXEC_TYPE, string2 + FS + "resource", this.rscConn);
    }

    private void execScripts(EXEC_TYPE eXEC_TYPE, String string, Connection connection) {
        ArrayList arrayList = new ArrayList();
        if (eXEC_TYPE == EXEC_TYPE.INSTALL) {
            FileUtil.getFileList((File)new File(string + FS + "xml" + FS + "install"), (boolean)true, arrayList);
            FileUtil.getFileList((File)new File(string + FS + "xml" + FS + "update"), (boolean)true, arrayList);
        } else {
            FileUtil.getFileList((File)new File(string + FS + "xml" + FS + "update"), (boolean)true, arrayList);
        }
        if (!arrayList.isEmpty()) {
            String string2 = null;
            for (String string3 : arrayList) {
                if (!string3.endsWith(".xml")) continue;
                File file = new File(string3);
                String string4 = file.getParent();
                if (string2 == null || !string2.equalsIgnoreCase(string4)) {
                    this.out.println("            processing ... " + string4);
                    string2 = string4;
                    Closer.commit((Connection)connection);
                }
                BufferedReader bufferedReader = new BufferedReader(FileUtil.getBufferedReader((File)file, (String)"UTF-8"));
                HybsXMLSave hybsXMLSave = new HybsXMLSave(connection, file.getName());
                hybsXMLSave.onExecErrException(false);
                hybsXMLSave.insertXML((Reader)bufferedReader);
            }
            Closer.commit((Connection)connection);
            this.out.println("            DB Enviroment " + (Object)((Object)eXEC_TYPE) + "ed , [ " + arrayList.size() + " ] scripts loaded ");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private String getOldMaxVersion() {
        Statement statement = null;
        ResultSet resultSet = null;
        String string = "none";
        try {
            statement = this.rscConn.createStatement();
            resultSet = statement.executeQuery(SEL_MAX_ENG);
            while (resultSet.next()) {
                string = resultSet.getString(1);
            }
        }
        catch (SQLException sQLException) {
            try {
                Closer.rollback((Connection)this.rscConn);
            }
            catch (Throwable throwable) {
                Closer.resultClose(resultSet);
                Closer.stmtClose((Statement)statement);
                throw throwable;
            }
            Closer.resultClose((ResultSet)resultSet);
            Closer.stmtClose((Statement)statement);
        }
        Closer.resultClose((ResultSet)resultSet);
        Closer.stmtClose((Statement)statement);
        return string;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private String getOldSystemVersion(String string, String string2) {
        String string3;
        block6: {
            PreparedStatement preparedStatement = null;
            ResultSet resultSet = null;
            string3 = null;
            try {
                preparedStatement = this.rscConn.prepareStatement(SEL_SYS_ENG);
                preparedStatement.setString(1, string);
                preparedStatement.setString(2, string2);
                resultSet = preparedStatement.executeQuery();
                while (resultSet.next()) {
                    string3 = resultSet.getString(1);
                }
                Closer.resultClose((ResultSet)resultSet);
            }
            catch (SQLException sQLException) {
                Closer.rollback((Connection)this.rscConn);
                break block6;
            }
            finally {
                Closer.resultClose(resultSet);
                Closer.stmtClose((Statement)preparedStatement);
            }
            Closer.stmtClose((Statement)preparedStatement);
        }
        return string3;
    }

    private void dbXMLResourceInsert() throws UnsupportedEncodingException {
        ClassLoader classLoader = Thread.currentThread().getContextClassLoader();
        InputStream inputStream = classLoader.getResourceAsStream(GE12_XML);
        BufferedReader bufferedReader = new BufferedReader(new InputStreamReader(inputStream, "UTF-8"));
        HybsXMLSave hybsXMLSave = new HybsXMLSave(this.rscConn, "GE12");
        hybsXMLSave.onExecErrException(false);
        hybsXMLSave.insertXML((Reader)bufferedReader);
        int n = hybsXMLSave.getInsertCount();
        int n2 = hybsXMLSave.getDeleteCount();
        this.out.print("        XML Engine Resource Reconfiguration ");
        this.out.println("DELETE=[" + n2 + "],INSERT=[" + n + "] finished.");
        Closer.commit((Connection)this.rscConn);
    }

    private static enum EXEC_TYPE {
        INSTALL,
        UPDATE;

    }
}

