/*
 * Decompiled with CFR 0.152.
 */
package org.apache.poi.hslf.model;

import java.awt.Color;
import java.awt.Font;
import java.awt.Graphics2D;
import java.awt.font.FontRenderContext;
import java.awt.font.LineBreakMeasurer;
import java.awt.font.TextAttribute;
import java.awt.font.TextLayout;
import java.awt.geom.AffineTransform;
import java.awt.geom.Point2D;
import java.awt.geom.Rectangle2D;
import java.text.AttributedCharacterIterator;
import java.text.AttributedString;
import java.util.ArrayList;
import org.apache.poi.hslf.model.PPFont;
import org.apache.poi.hslf.model.TextRun;
import org.apache.poi.hslf.model.TextShape;
import org.apache.poi.hslf.record.TextRulerAtom;
import org.apache.poi.hslf.usermodel.RichTextRun;
import org.apache.poi.util.POILogFactory;
import org.apache.poi.util.POILogger;

public final class TextPainter {
    protected POILogger logger = POILogFactory.getLogger(this.getClass());
    protected static final char DEFAULT_BULLET_CHAR = '\u25a0';
    protected TextShape _shape;

    public TextPainter(TextShape shape) {
        this._shape = shape;
    }

    public AttributedString getAttributedString(TextRun txrun) {
        String text = txrun.getText();
        text = text.replace('\t', ' ');
        text = text.replace('\u00a0', ' ');
        AttributedString at = new AttributedString(text);
        RichTextRun[] rt = txrun.getRichTextRuns();
        for (int i = 0; i < rt.length; ++i) {
            int superScript;
            int end;
            int start = rt[i].getStartIndex();
            if (start == (end = rt[i].getEndIndex())) {
                this.logger.log(3, (Object)"Skipping RichTextRun with zero length");
                continue;
            }
            at.addAttribute(TextAttribute.FAMILY, rt[i].getFontName(), start, end);
            at.addAttribute(TextAttribute.SIZE, new Float(rt[i].getFontSize()), start, end);
            at.addAttribute(TextAttribute.FOREGROUND, rt[i].getFontColor(), start, end);
            if (rt[i].isBold()) {
                at.addAttribute(TextAttribute.WEIGHT, TextAttribute.WEIGHT_BOLD, start, end);
            }
            if (rt[i].isItalic()) {
                at.addAttribute(TextAttribute.POSTURE, TextAttribute.POSTURE_OBLIQUE, start, end);
            }
            if (rt[i].isUnderlined()) {
                at.addAttribute(TextAttribute.UNDERLINE, TextAttribute.UNDERLINE_ON, start, end);
                at.addAttribute(TextAttribute.INPUT_METHOD_UNDERLINE, TextAttribute.UNDERLINE_LOW_TWO_PIXEL, start, end);
            }
            if (rt[i].isStrikethrough()) {
                at.addAttribute(TextAttribute.STRIKETHROUGH, TextAttribute.STRIKETHROUGH_ON, start, end);
            }
            if ((superScript = rt[i].getSuperscript()) == 0) continue;
            at.addAttribute(TextAttribute.SUPERSCRIPT, superScript > 0 ? TextAttribute.SUPERSCRIPT_SUPER : TextAttribute.SUPERSCRIPT_SUB, start, end);
        }
        return at;
    }

    public void paint(Graphics2D graphics) {
        AffineTransform tx = graphics.getTransform();
        Rectangle2D anchor = this._shape.getLogicalAnchor2D();
        TextElement[] elem = this.getTextElements((float)anchor.getWidth(), graphics.getFontRenderContext());
        if (elem == null) {
            return;
        }
        float textHeight = 0.0f;
        for (int i = 0; i < elem.length; ++i) {
            textHeight += elem[i].ascent + elem[i].descent;
        }
        int valign = this._shape.getVerticalAlignment();
        double y0 = anchor.getY();
        switch (valign) {
            case 0: 
            case 6: {
                y0 += (double)this._shape.getMarginTop();
                break;
            }
            case 2: {
                y0 += anchor.getHeight() - (double)textHeight - (double)this._shape.getMarginBottom();
                break;
            }
            default: {
                float delta = (float)anchor.getHeight() - textHeight - this._shape.getMarginTop() - this._shape.getMarginBottom();
                y0 += (double)(this._shape.getMarginTop() + delta / 2.0f);
            }
        }
        if (this._shape.getFlipVertical()) {
            graphics.translate(anchor.getX(), anchor.getY() + anchor.getHeight());
            graphics.scale(1.0, -1.0);
            graphics.translate(-anchor.getX(), -anchor.getY());
            double centerX = anchor.getX() + anchor.getWidth() / 2.0;
            double centerY = anchor.getY() + anchor.getHeight() / 2.0;
            graphics.translate(centerX, centerY);
            graphics.rotate(Math.toRadians(180.0));
            graphics.translate(-centerX, -centerY);
        }
        if (this._shape.getFlipHorizontal()) {
            graphics.translate(anchor.getX() + anchor.getWidth(), anchor.getY());
            graphics.scale(-1.0, 1.0);
            graphics.translate(-anchor.getX(), -anchor.getY());
        }
        for (int i = 0; i < elem.length; ++i) {
            AttributedCharacterIterator chIt;
            Point2D.Double pen = new Point2D.Double();
            pen.y = y0 += (double)elem[i].ascent;
            switch (elem[i]._align) {
                default: {
                    pen.x = anchor.getX() + (double)this._shape.getMarginLeft();
                    break;
                }
                case 1: {
                    pen.x = anchor.getX() + (double)this._shape.getMarginLeft() + (anchor.getWidth() - (double)elem[i].advance - (double)this._shape.getMarginLeft() - (double)this._shape.getMarginRight()) / 2.0;
                    break;
                }
                case 2: {
                    pen.x = anchor.getX() + (double)this._shape.getMarginLeft() + (anchor.getWidth() - (double)elem[i].advance - (double)this._shape.getMarginLeft() - (double)this._shape.getMarginRight());
                }
            }
            if (elem[i]._bullet != null) {
                graphics.drawString(elem[i]._bullet.getIterator(), (float)(pen.x + (double)elem[i]._bulletOffset), (float)pen.y);
            }
            if ((chIt = elem[i]._text.getIterator()).getEndIndex() > chIt.getBeginIndex()) {
                graphics.drawString(chIt, (float)(pen.x + (double)elem[i]._textOffset), (float)pen.y);
            }
            y0 += (double)elem[i].descent;
        }
        graphics.setTransform(tx);
    }

    public TextElement[] getTextElements(float textWidth, FontRenderContext frc) {
        TextRun run = this._shape.getTextRun();
        if (run == null) {
            return null;
        }
        String text = run.getText();
        if (text == null || text.equals("")) {
            return null;
        }
        AttributedString at = this.getAttributedString(run);
        AttributedCharacterIterator it = at.getIterator();
        int paragraphStart = it.getBeginIndex();
        int paragraphEnd = it.getEndIndex();
        ArrayList<TextElement> lines = new ArrayList<TextElement>();
        LineBreakMeasurer measurer = new LineBreakMeasurer(it, frc);
        measurer.setPosition(paragraphStart);
        while (measurer.getPosition() < paragraphEnd) {
            TextLayout textLayout;
            RichTextRun rt;
            boolean prStart;
            int startIndex = measurer.getPosition();
            int nextBreak = text.indexOf(10, measurer.getPosition() + 1);
            boolean bl = prStart = text.charAt(startIndex) == '\n';
            if (prStart) {
                measurer.setPosition(startIndex++);
            }
            if ((rt = run.getRichTextRunAt(startIndex == text.length() ? startIndex - 1 : startIndex)) == null) {
                this.logger.log(5, (Object)("RichTextRun not found at pos" + startIndex + "; text.length: " + text.length()));
                break;
            }
            float wrappingWidth = textWidth - this._shape.getMarginLeft() - this._shape.getMarginRight();
            int bulletOffset = rt.getBulletOffset();
            int textOffset = rt.getTextOffset();
            int indent = rt.getIndentLevel();
            TextRulerAtom ruler = run.getTextRuler();
            if (ruler != null) {
                int text_val;
                int bullet_val = ruler.getBulletOffsets()[indent] * 72 / 576;
                if (bullet_val > (text_val = ruler.getTextOffsets()[indent] * 72 / 576)) {
                    int a = bullet_val;
                    bullet_val = text_val;
                    text_val = a;
                }
                if (bullet_val != 0) {
                    bulletOffset = bullet_val;
                }
                if (text_val != 0) {
                    textOffset = text_val;
                }
            }
            if (bulletOffset > 0 || prStart || startIndex == 0) {
                wrappingWidth -= (float)textOffset;
            }
            if (this._shape.getWordWrap() == 2) {
                wrappingWidth = this._shape.getSheet().getSlideShow().getPageSize().width;
            }
            if ((textLayout = measurer.nextLayout(wrappingWidth + 1.0f, nextBreak == -1 ? paragraphEnd : nextBreak, true)) == null) {
                textLayout = measurer.nextLayout(textWidth, nextBreak == -1 ? paragraphEnd : nextBreak, false);
            }
            if (textLayout == null) {
                this.logger.log(5, (Object)("Failed to break text into lines: wrappingWidth: " + wrappingWidth + "; text: " + rt.getText()));
                measurer.setPosition(rt.getEndIndex());
                continue;
            }
            int endIndex = measurer.getPosition();
            float lineHeight = (float)textLayout.getBounds().getHeight();
            int linespacing = rt.getLineSpacing();
            if (linespacing == 0) {
                linespacing = 100;
            }
            TextElement el = new TextElement();
            el.ascent = linespacing >= 0 ? textLayout.getAscent() * (float)linespacing / 100.0f : (float)(-linespacing * 72 / 576);
            el._align = rt.getAlignment();
            el.advance = textLayout.getAdvance();
            el._textOffset = textOffset;
            el._text = new AttributedString(it, startIndex, endIndex);
            el.textStartIndex = startIndex;
            el.textEndIndex = endIndex;
            if (prStart) {
                int sp = rt.getSpaceBefore();
                float spaceBefore = sp >= 0 ? lineHeight * (float)sp / 100.0f : (float)(-sp * 72 / 576);
                el.ascent += spaceBefore;
            }
            float descent = linespacing >= 0 ? (textLayout.getDescent() + textLayout.getLeading()) * (float)linespacing / 100.0f : (float)(-linespacing * 72 / 576);
            if (prStart) {
                int sp = rt.getSpaceAfter();
                float spaceAfter = sp >= 0 ? lineHeight * (float)sp / 100.0f : (float)(-sp * 72 / 576);
                el.ascent += spaceAfter;
            }
            el.descent = descent;
            if (rt.isBullet() && (prStart || startIndex == 0)) {
                it.setIndex(startIndex);
                AttributedString bat = new AttributedString(Character.toString(rt.getBulletChar()));
                Color clr = rt.getBulletColor();
                if (clr != null) {
                    bat.addAttribute(TextAttribute.FOREGROUND, clr);
                } else {
                    bat.addAttribute(TextAttribute.FOREGROUND, it.getAttribute(TextAttribute.FOREGROUND));
                }
                int fontIdx = rt.getBulletFont();
                if (fontIdx == -1) {
                    fontIdx = rt.getFontIndex();
                }
                PPFont bulletFont = this._shape.getSheet().getSlideShow().getFont(fontIdx);
                bat.addAttribute(TextAttribute.FAMILY, bulletFont.getFontName());
                int bulletSize = rt.getBulletSize();
                int fontSize = rt.getFontSize();
                if (bulletSize != -1) {
                    fontSize = Math.round((float)(fontSize * bulletSize) * 0.01f);
                }
                bat.addAttribute(TextAttribute.SIZE, new Float(fontSize));
                if (!new Font(bulletFont.getFontName(), 0, 1).canDisplay(rt.getBulletChar())) {
                    bat.addAttribute(TextAttribute.FAMILY, "Arial");
                    bat = new AttributedString("\u25a0", bat.getIterator().getAttributes());
                }
                if (text.substring(startIndex, endIndex).length() > 1) {
                    el._bullet = bat;
                    el._bulletOffset = bulletOffset;
                }
            }
            lines.add(el);
        }
        TextElement[] elems = new TextElement[lines.size()];
        return lines.toArray(elems);
    }

    public static class TextElement {
        public AttributedString _text;
        public int _textOffset;
        public AttributedString _bullet;
        public int _bulletOffset;
        public int _align;
        public float ascent;
        public float descent;
        public float advance;
        public int textStartIndex;
        public int textEndIndex;
    }
}

