/*
 * Decompiled with CFR 0.152.
 */
package org.odftoolkit.odfdom.type;

import org.odftoolkit.odfdom.type.OdfDataType;

public class Color
implements OdfDataType {
    private String mColor;

    public Color(String color) throws IllegalArgumentException {
        if (color == null || !color.matches("^#[0-9a-fA-F]{6}$")) {
            throw new IllegalArgumentException("parameter is invalidate for datatype Color");
        }
        this.mColor = color;
    }

    public String toString() {
        return this.mColor;
    }

    public static Color valueOf(String stringValue) throws IllegalArgumentException {
        return new Color(stringValue);
    }

    public static boolean isValid(String stringValue) {
        return stringValue != null && stringValue.matches("^#[0-9a-fA-F]{6}$");
    }

    public static String mapColorFromRgbToHex(String colorValue) {
        if (colorValue.startsWith("rgb")) {
            colorValue = colorValue.substring(3);
            String[] rgbValues = (colorValue = colorValue.substring(colorValue.indexOf("(") + 1, colorValue.indexOf(")"))).split(",");
            if (rgbValues.length == 3) {
                int r = Integer.parseInt(rgbValues[0].trim());
                int g = Integer.parseInt(rgbValues[1].trim());
                int b = Integer.parseInt(rgbValues[2].trim());
                String rs = Integer.toHexString(r);
                String gs = Integer.toHexString(g);
                String bs = Integer.toHexString(b);
                String hexColor = "#";
                if (r < 16) {
                    hexColor = hexColor + "0";
                }
                hexColor = hexColor + rs;
                if (g < 16) {
                    hexColor = hexColor + "0";
                }
                hexColor = hexColor + gs;
                if (b < 16) {
                    hexColor = hexColor + "0";
                }
                hexColor = hexColor + bs;
                return hexColor;
            }
        }
        return colorValue;
    }
}

