/*
 * Decompiled with CFR 0.152.
 */
package org.firebirdsql.encodings;

import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.nio.charset.Charset;
import java.sql.SQLException;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.Properties;
import org.firebirdsql.encodings.CharacterTranslator;
import org.firebirdsql.encodings.Encoding;
import org.firebirdsql.encodings.Encoding_Cp1250;
import org.firebirdsql.encodings.Encoding_Cp1251;
import org.firebirdsql.encodings.Encoding_Cp1252;
import org.firebirdsql.encodings.Encoding_Cp1253;
import org.firebirdsql.encodings.Encoding_Cp1254;
import org.firebirdsql.encodings.Encoding_Cp1255;
import org.firebirdsql.encodings.Encoding_Cp1256;
import org.firebirdsql.encodings.Encoding_Cp1257;
import org.firebirdsql.encodings.Encoding_Cp437;
import org.firebirdsql.encodings.Encoding_Cp737;
import org.firebirdsql.encodings.Encoding_Cp775;
import org.firebirdsql.encodings.Encoding_Cp850;
import org.firebirdsql.encodings.Encoding_Cp852;
import org.firebirdsql.encodings.Encoding_Cp857;
import org.firebirdsql.encodings.Encoding_Cp858;
import org.firebirdsql.encodings.Encoding_Cp860;
import org.firebirdsql.encodings.Encoding_Cp861;
import org.firebirdsql.encodings.Encoding_Cp862;
import org.firebirdsql.encodings.Encoding_Cp863;
import org.firebirdsql.encodings.Encoding_Cp864;
import org.firebirdsql.encodings.Encoding_Cp865;
import org.firebirdsql.encodings.Encoding_Cp866;
import org.firebirdsql.encodings.Encoding_Cp869;
import org.firebirdsql.encodings.Encoding_ISO8859_1;
import org.firebirdsql.encodings.Encoding_ISO8859_13;
import org.firebirdsql.encodings.Encoding_ISO8859_2;
import org.firebirdsql.encodings.Encoding_ISO8859_3;
import org.firebirdsql.encodings.Encoding_ISO8859_4;
import org.firebirdsql.encodings.Encoding_ISO8859_5;
import org.firebirdsql.encodings.Encoding_ISO8859_6;
import org.firebirdsql.encodings.Encoding_ISO8859_7;
import org.firebirdsql.encodings.Encoding_ISO8859_8;
import org.firebirdsql.encodings.Encoding_ISO8859_9;
import org.firebirdsql.encodings.Encoding_NotOneByte;

public class EncodingFactory {
    private static final int[][] CHARSET_MAXIMUM_SIZE = new int[][]{{0, 1}, {1, 1}, {2, 1}, {3, 3}, {4, 4}, {5, 2}, {6, 2}, {9, 1}, {10, 1}, {11, 1}, {12, 1}, {13, 1}, {14, 1}, {15, 1}, {16, 1}, {17, 1}, {18, 1}, {19, 1}, {21, 1}, {22, 1}, {23, 1}, {34, 1}, {35, 1}, {36, 1}, {37, 1}, {38, 1}, {39, 1}, {40, 1}, {44, 2}, {45, 1}, {46, 1}, {47, 1}, {48, 1}, {49, 1}, {50, 1}, {51, 1}, {52, 1}, {53, 1}, {54, 1}, {55, 1}, {56, 2}, {57, 2}, {58, 1}, {59, 1}, {60, 1}, {63, 1}, {64, 1}, {65, 1}};
    public static final char[] DEFAULT_MAPPING = new char[65536];
    static final String defaultEncoding;
    private static volatile boolean encodingSizesLoaded;
    private static volatile boolean encodingsLoaded;
    public static final String ISC_ENCODING_SIZE_RESOURCE = "isc_encoding_size.properties";
    public static final String ISC_ENCODINGS_RESOURCE = "isc_encodings.properties";
    private static final Map<String, String> iscEncodings;
    private static final Map<String, Byte> iscEncodingSizes;
    private static final Map<String, String> javaEncodings;
    private static final Map<String, String> javaAliases;
    private static final Map translations;

    public static Encoding createEncoding(String encoding) {
        if (encoding.equals("NONE")) {
            encoding = defaultEncoding;
        } else {
            String tempEncoding = javaAliases.get(encoding);
            if (tempEncoding != null) {
                encoding = tempEncoding;
            }
        }
        if (encoding.equals("Cp1250")) {
            return new Encoding_Cp1250();
        }
        if (encoding.equals("Cp1251")) {
            return new Encoding_Cp1251();
        }
        if (encoding.equals("Cp1252")) {
            return new Encoding_Cp1252();
        }
        if (encoding.equals("Cp1253")) {
            return new Encoding_Cp1253();
        }
        if (encoding.equals("Cp1254")) {
            return new Encoding_Cp1254();
        }
        if (encoding.equals("Cp1255")) {
            return new Encoding_Cp1255();
        }
        if (encoding.equals("Cp1256")) {
            return new Encoding_Cp1256();
        }
        if (encoding.equals("Cp1257")) {
            return new Encoding_Cp1257();
        }
        if (encoding.equals("Cp437")) {
            return new Encoding_Cp437();
        }
        if (encoding.equals("Cp737")) {
            return new Encoding_Cp737();
        }
        if (encoding.equals("Cp775")) {
            return new Encoding_Cp775();
        }
        if (encoding.equals("Cp850")) {
            return new Encoding_Cp850();
        }
        if (encoding.equals("Cp852")) {
            return new Encoding_Cp852();
        }
        if (encoding.equals("Cp857")) {
            return new Encoding_Cp857();
        }
        if (encoding.equals("Cp858")) {
            return new Encoding_Cp858();
        }
        if (encoding.equals("Cp860")) {
            return new Encoding_Cp860();
        }
        if (encoding.equals("Cp861")) {
            return new Encoding_Cp861();
        }
        if (encoding.equals("Cp862")) {
            return new Encoding_Cp862();
        }
        if (encoding.equals("Cp863")) {
            return new Encoding_Cp863();
        }
        if (encoding.equals("Cp864")) {
            return new Encoding_Cp864();
        }
        if (encoding.equals("Cp865")) {
            return new Encoding_Cp865();
        }
        if (encoding.equals("Cp866")) {
            return new Encoding_Cp866();
        }
        if (encoding.equals("Cp869")) {
            return new Encoding_Cp869();
        }
        if (encoding.equals("ISO8859_1")) {
            return new Encoding_ISO8859_1();
        }
        if (encoding.equals("ISO8859_2")) {
            return new Encoding_ISO8859_2();
        }
        if (encoding.equals("ISO8859_3")) {
            return new Encoding_ISO8859_3();
        }
        if (encoding.equals("ISO8859_4")) {
            return new Encoding_ISO8859_4();
        }
        if (encoding.equals("ISO8859_5")) {
            return new Encoding_ISO8859_5();
        }
        if (encoding.equals("ISO8859_6")) {
            return new Encoding_ISO8859_6();
        }
        if (encoding.equals("ISO8859_7")) {
            return new Encoding_ISO8859_7();
        }
        if (encoding.equals("ISO8859_8")) {
            return new Encoding_ISO8859_8();
        }
        if (encoding.equals("ISO8859_9")) {
            return new Encoding_ISO8859_9();
        }
        if (encoding.equals("ISO8859_13")) {
            return new Encoding_ISO8859_13();
        }
        return new Encoding_NotOneByte(encoding);
    }

    public static int getCharacterSetSize(int characterSetId) {
        for (int i = 0; i < CHARSET_MAXIMUM_SIZE.length; ++i) {
            if (CHARSET_MAXIMUM_SIZE[i][0] != characterSetId) continue;
            return CHARSET_MAXIMUM_SIZE[i][1];
        }
        return 1;
    }

    public static Encoding getEncoding(String encoding) {
        if (encoding == null) {
            encoding = defaultEncoding;
        }
        return EncodingFactory.createEncoding(encoding);
    }

    public static Encoding getEncoding(String encoding, char[] charMapping) {
        if (encoding == null || encoding.equals("NONE")) {
            encoding = defaultEncoding;
        } else {
            String tempEncoding = javaAliases.get(encoding);
            if (tempEncoding != null) {
                encoding = tempEncoding;
            }
        }
        if (encoding.equals("Cp1250")) {
            return new Encoding_Cp1250(charMapping);
        }
        if (encoding.equals("Cp1251")) {
            return new Encoding_Cp1251(charMapping);
        }
        if (encoding.equals("Cp1252")) {
            return new Encoding_Cp1252(charMapping);
        }
        if (encoding.equals("Cp1253")) {
            return new Encoding_Cp1253(charMapping);
        }
        if (encoding.equals("Cp1254")) {
            return new Encoding_Cp1254(charMapping);
        }
        if (encoding.equals("Cp1255")) {
            return new Encoding_Cp1255(charMapping);
        }
        if (encoding.equals("Cp1256")) {
            return new Encoding_Cp1256(charMapping);
        }
        if (encoding.equals("Cp1257")) {
            return new Encoding_Cp1257(charMapping);
        }
        if (encoding.equals("Cp437")) {
            return new Encoding_Cp437(charMapping);
        }
        if (encoding.equals("Cp737")) {
            return new Encoding_Cp737(charMapping);
        }
        if (encoding.equals("Cp775")) {
            return new Encoding_Cp775(charMapping);
        }
        if (encoding.equals("Cp850")) {
            return new Encoding_Cp850(charMapping);
        }
        if (encoding.equals("Cp852")) {
            return new Encoding_Cp852(charMapping);
        }
        if (encoding.equals("Cp857")) {
            return new Encoding_Cp857(charMapping);
        }
        if (encoding.equals("Cp858")) {
            return new Encoding_Cp858(charMapping);
        }
        if (encoding.equals("Cp860")) {
            return new Encoding_Cp860(charMapping);
        }
        if (encoding.equals("Cp861")) {
            return new Encoding_Cp861(charMapping);
        }
        if (encoding.equals("Cp862")) {
            return new Encoding_Cp862(charMapping);
        }
        if (encoding.equals("Cp863")) {
            return new Encoding_Cp863(charMapping);
        }
        if (encoding.equals("Cp864")) {
            return new Encoding_Cp864(charMapping);
        }
        if (encoding.equals("Cp865")) {
            return new Encoding_Cp865(charMapping);
        }
        if (encoding.equals("Cp866")) {
            return new Encoding_Cp866(charMapping);
        }
        if (encoding.equals("Cp869")) {
            return new Encoding_Cp869(charMapping);
        }
        if (encoding.equals("ISO8859_1")) {
            return new Encoding_ISO8859_1(charMapping);
        }
        if (encoding.equals("ISO8859_2")) {
            return new Encoding_ISO8859_2(charMapping);
        }
        if (encoding.equals("ISO8859_3")) {
            return new Encoding_ISO8859_3(charMapping);
        }
        if (encoding.equals("ISO8859_4")) {
            return new Encoding_ISO8859_4(charMapping);
        }
        if (encoding.equals("ISO8859_5")) {
            return new Encoding_ISO8859_5(charMapping);
        }
        if (encoding.equals("ISO8859_6")) {
            return new Encoding_ISO8859_6(charMapping);
        }
        if (encoding.equals("ISO8859_7")) {
            return new Encoding_ISO8859_7(charMapping);
        }
        if (encoding.equals("ISO8859_8")) {
            return new Encoding_ISO8859_8(charMapping);
        }
        if (encoding.equals("ISO8859_9")) {
            return new Encoding_ISO8859_9(charMapping);
        }
        if (encoding.equals("ISO8859_13")) {
            return new Encoding_ISO8859_13(charMapping);
        }
        return new Encoding_NotOneByte(encoding, charMapping);
    }

    public static Encoding getEncoding(String encoding, String mappingPath) throws SQLException {
        if (mappingPath == null) {
            return EncodingFactory.getEncoding(encoding);
        }
        CharacterTranslator translator = EncodingFactory.getTranslator(mappingPath);
        return EncodingFactory.getEncoding(encoding, translator.getMapping());
    }

    public static String getIscEncoding(String javaEncoding) {
        if (javaEncoding == null) {
            return null;
        }
        if (!encodingsLoaded) {
            EncodingFactory.loadEncodings();
        }
        return javaEncodings.get(javaEncoding.toLowerCase());
    }

    public static int getIscEncodingSize(String iscEncoding) {
        Byte result;
        if (iscEncoding == null) {
            return 1;
        }
        if (!encodingSizesLoaded) {
            EncodingFactory.loadEncodingSizes();
        }
        if ((result = iscEncodingSizes.get(iscEncoding.toLowerCase())) == null) {
            return 1;
        }
        return result.byteValue();
    }

    public static String getJavaEncoding(String iscEncoding) {
        String javaEncoding;
        if (iscEncoding == null) {
            return null;
        }
        if (!encodingsLoaded) {
            EncodingFactory.loadEncodings();
        }
        if ((javaEncoding = iscEncodings.get(iscEncoding.toLowerCase())) == null || javaEncoding.equalsIgnoreCase(defaultEncoding)) {
            return null;
        }
        return javaEncoding;
    }

    public static String getJavaEncodingForAlias(String javaAlias) {
        String javaEncoding;
        if (javaAlias == null) {
            return null;
        }
        if (!encodingsLoaded) {
            EncodingFactory.loadEncodings();
        }
        if ((javaEncoding = javaAliases.get(javaAlias.toLowerCase())) == null || javaEncoding.equalsIgnoreCase(defaultEncoding)) {
            return null;
        }
        return javaEncoding;
    }

    public static CharacterTranslator getTranslator(String mappingPath) throws SQLException {
        CharacterTranslator translator = (CharacterTranslator)translations.get(mappingPath);
        if (translator == null) {
            translator = new CharacterTranslator();
            translator.init(mappingPath);
            translations.put(mappingPath, translator);
        }
        return translator;
    }

    private static synchronized void loadEncodings() {
        Properties props;
        if (encodingsLoaded) {
            return;
        }
        try {
            props = EncodingFactory.loadProperties(ISC_ENCODINGS_RESOURCE);
        }
        catch (IOException ioex) {
            ioex.printStackTrace();
            return;
        }
        for (Map.Entry<Object, Object> entry : props.entrySet()) {
            String iscEncoding = (String)entry.getKey();
            String javaEncoding = (String)entry.getValue();
            iscEncodings.put(iscEncoding.toLowerCase(), javaEncoding);
            if ("UNICODE_FSS".equals(iscEncoding)) continue;
            Charset javaCharset = Charset.forName(javaEncoding);
            String canonicalNameLowerCase = javaCharset.name().toLowerCase();
            javaEncodings.put(canonicalNameLowerCase, iscEncoding);
            javaAliases.put(canonicalNameLowerCase, javaEncoding);
            for (String alias : javaCharset.aliases()) {
                String lowerCaseAlias = alias.toLowerCase();
                javaEncodings.put(lowerCaseAlias, iscEncoding);
                javaAliases.put(lowerCaseAlias, javaEncoding);
            }
        }
        encodingsLoaded = true;
    }

    private static synchronized void loadEncodingSizes() {
        Properties props;
        if (encodingSizesLoaded) {
            return;
        }
        try {
            props = EncodingFactory.loadProperties(ISC_ENCODING_SIZE_RESOURCE);
        }
        catch (IOException ex) {
            ex.printStackTrace();
            return;
        }
        for (Map.Entry<Object, Object> entry : props.entrySet()) {
            String iscEncoding = (String)entry.getKey();
            String size = (String)entry.getValue();
            byte byteSize = Byte.parseByte(size);
            iscEncodingSizes.put(iscEncoding.toLowerCase(), byteSize);
        }
        encodingSizesLoaded = true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static Properties loadProperties(String resource) throws IOException {
        ClassLoader cl = EncodingFactory.class.getClassLoader();
        InputStream in = null;
        in = cl == null ? ClassLoader.getSystemResourceAsStream(resource) : cl.getResourceAsStream(resource);
        if (in == null) {
            return null;
        }
        try {
            Properties props = new Properties();
            props.load(in);
            Properties properties = props;
            return properties;
        }
        finally {
            in.close();
        }
    }

    static {
        encodingSizesLoaded = false;
        encodingsLoaded = false;
        iscEncodings = new HashMap<String, String>();
        iscEncodingSizes = new HashMap<String, Byte>();
        javaEncodings = new HashMap<String, String>();
        javaAliases = new HashMap<String, String>();
        translations = Collections.synchronizedMap(new HashMap());
        for (int i = 0; i < DEFAULT_MAPPING.length; ++i) {
            EncodingFactory.DEFAULT_MAPPING[i] = (char)i;
        }
        InputStreamReader reader = new InputStreamReader(new ByteArrayInputStream(new byte[2]));
        defaultEncoding = reader.getEncoding();
        try {
            reader.close();
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }
}

