/*
 * Decompiled with CFR 0.152.
 */
package org.firebirdsql.logging;

import org.firebirdsql.logging.Log4jLogger;
import org.firebirdsql.logging.Logger;

public class LoggerFactory {
    private static final boolean forceConsoleLogger = false;
    private static boolean checked = false;
    private static boolean log4j = false;

    public static Logger getLogger(String name, boolean def) {
        if (!checked) {
            String sLog4j = System.getProperty("FBLog4j");
            log4j = !def ? sLog4j != null && sLog4j.equals("true") : sLog4j == null || !sLog4j.equals("false");
            if (log4j) {
                try {
                    Class.forName("org.apache.log4j.Category");
                    log4j = true;
                }
                catch (ClassNotFoundException cnfe) {
                    log4j = false;
                }
            }
            checked = true;
        }
        if (log4j) {
            return new Log4jLogger(name);
        }
        return null;
    }

    public static Logger getLogger(Class clazz, boolean def) {
        return LoggerFactory.getLogger(clazz.getName(), def);
    }
}

