/*
 * Decompiled with CFR 0.152.
 */
package org.firebirdsql.gds;

import java.sql.Date;
import java.sql.SQLException;
import java.sql.Time;
import java.sql.Timestamp;
import java.util.Calendar;
import java.util.GregorianCalendar;
import org.firebirdsql.encodings.Encoding;
import org.firebirdsql.encodings.EncodingFactory;

public class XSQLVAR {
    public int sqltype;
    public int sqlscale;
    public int sqlsubtype;
    public int sqllen;
    public byte[] sqldata;
    public Object cachedobject;
    public String sqlname;
    public String relname;
    public String relaliasname;
    public String ownname;
    public String aliasname;
    protected Encoding coder;

    public XSQLVAR deepCopy() {
        XSQLVAR result = new XSQLVAR();
        result.copyFrom(this);
        return result;
    }

    public void copyFrom(XSQLVAR original) {
        this.copyFrom(original, true);
    }

    public void copyFrom(XSQLVAR original, boolean copyData) {
        this.sqltype = original.sqltype;
        this.sqlscale = original.sqlscale;
        this.sqlsubtype = original.sqlsubtype;
        this.sqllen = original.sqllen;
        if (original.sqldata != null && copyData) {
            this.sqldata = new byte[original.sqldata.length];
            System.arraycopy(original.sqldata, 0, this.sqldata, 0, original.sqldata.length);
        } else {
            this.sqldata = null;
        }
        this.sqlname = original.sqlname;
        this.relname = original.relname;
        this.relaliasname = original.relaliasname;
        this.ownname = original.ownname;
        this.aliasname = original.aliasname;
    }

    public byte[] encodeShort(short value) {
        return this.encodeInt(value);
    }

    public short decodeShort(byte[] byte_int) {
        return (short)this.decodeInt(byte_int);
    }

    public byte[] encodeInt(int value) {
        byte[] ret = new byte[]{(byte)(value >>> 24 & 0xFF), (byte)(value >>> 16 & 0xFF), (byte)(value >>> 8 & 0xFF), (byte)(value & 0xFF)};
        return ret;
    }

    public int decodeInt(byte[] byte_int) {
        int b1 = byte_int[0] & 0xFF;
        int b2 = byte_int[1] & 0xFF;
        int b3 = byte_int[2] & 0xFF;
        int b4 = byte_int[3] & 0xFF;
        return (b1 << 24) + (b2 << 16) + (b3 << 8) + b4;
    }

    public byte[] encodeLong(long value) {
        byte[] ret = new byte[]{(byte)(value >>> 56 & 0xFFL), (byte)(value >>> 48 & 0xFFL), (byte)(value >>> 40 & 0xFFL), (byte)(value >>> 32 & 0xFFL), (byte)(value >>> 24 & 0xFFL), (byte)(value >>> 16 & 0xFFL), (byte)(value >>> 8 & 0xFFL), (byte)(value & 0xFFL)};
        return ret;
    }

    public long decodeLong(byte[] byte_int) {
        long b1 = byte_int[0] & 0xFF;
        long b2 = byte_int[1] & 0xFF;
        long b3 = byte_int[2] & 0xFF;
        long b4 = byte_int[3] & 0xFF;
        long b5 = byte_int[4] & 0xFF;
        long b6 = byte_int[5] & 0xFF;
        long b7 = byte_int[6] & 0xFF;
        long b8 = byte_int[7] & 0xFF;
        return (b1 << 56) + (b2 << 48) + (b3 << 40) + (b4 << 32) + (b5 << 24) + (b6 << 16) + (b7 << 8) + b8;
    }

    public byte[] encodeFloat(float value) {
        return this.encodeInt(Float.floatToIntBits(value));
    }

    public float decodeFloat(byte[] byte_int) {
        return Float.intBitsToFloat(this.decodeInt(byte_int));
    }

    public byte[] encodeDouble(double value) {
        return this.encodeLong(Double.doubleToLongBits(value));
    }

    public double decodeDouble(byte[] byte_int) {
        return Double.longBitsToDouble(this.decodeLong(byte_int));
    }

    public byte[] encodeString(String value, String encoding, String mappingPath) throws SQLException {
        if (this.coder == null) {
            this.coder = EncodingFactory.getEncoding(encoding, mappingPath);
        }
        return this.coder.encodeToCharset(value);
    }

    public byte[] encodeString(byte[] value, String encoding, String mappingPath) throws SQLException {
        if (encoding == null) {
            return value;
        }
        if (this.coder == null) {
            this.coder = EncodingFactory.getEncoding(encoding, mappingPath);
        }
        return this.coder.encodeToCharset(this.coder.decodeFromCharset(value));
    }

    public String decodeString(byte[] value, String encoding, String mappingPath) throws SQLException {
        if (this.coder == null) {
            this.coder = EncodingFactory.getEncoding(encoding, mappingPath);
        }
        return this.coder.decodeFromCharset(value);
    }

    public Timestamp encodeTimestamp(Timestamp value, Calendar cal) {
        return this.encodeTimestamp(value, cal, false);
    }

    public Timestamp encodeTimestamp(Timestamp value, Calendar cal, boolean invertTimeZone) {
        if (cal == null) {
            return value;
        }
        long time = value.getTime() + (long)((invertTimeZone ? -1 : 1) * (cal.getTimeZone().getRawOffset() - Calendar.getInstance().getTimeZone().getRawOffset()));
        return new Timestamp(time);
    }

    public byte[] encodeTimestamp(Timestamp value) {
        return this.encodeTimestampCalendar(value, new GregorianCalendar());
    }

    public byte[] encodeTimestampCalendar(Timestamp value, Calendar c) {
        datetime d = new datetime(value, c);
        byte[] date = d.toDateBytes();
        byte[] time = d.toTimeBytes();
        byte[] result = new byte[8];
        System.arraycopy(date, 0, result, 0, 4);
        System.arraycopy(time, 0, result, 4, 4);
        return result;
    }

    public Timestamp decodeTimestamp(Timestamp value, Calendar cal) {
        return this.decodeTimestamp(value, cal, false);
    }

    public Timestamp decodeTimestamp(Timestamp value, Calendar cal, boolean invertTimeZone) {
        if (cal == null) {
            return value;
        }
        long time = value.getTime() - (long)((invertTimeZone ? -1 : 1) * (cal.getTimeZone().getRawOffset() - Calendar.getInstance().getTimeZone().getRawOffset()));
        return new Timestamp(time);
    }

    public Timestamp decodeTimestamp(byte[] byte_int) {
        return this.decodeTimestampCalendar(byte_int, new GregorianCalendar());
    }

    public Timestamp decodeTimestampCalendar(byte[] byte_int, Calendar c) {
        if (byte_int.length != 8) {
            throw new IllegalArgumentException("Bad parameter to decode");
        }
        byte[] date = new byte[4];
        byte[] time = new byte[4];
        System.arraycopy(byte_int, 0, date, 0, 4);
        System.arraycopy(byte_int, 4, time, 0, 4);
        datetime d = new datetime(date, time);
        return d.toTimestamp(c);
    }

    public Time encodeTime(Time d, Calendar cal, boolean invertTimeZone) {
        if (cal == null) {
            return d;
        }
        long time = d.getTime() + (long)((invertTimeZone ? -1 : 1) * (cal.getTimeZone().getRawOffset() - Calendar.getInstance().getTimeZone().getRawOffset()));
        return new Time(time);
    }

    public byte[] encodeTime(Time d) {
        return this.encodeTimeCalendar(d, new GregorianCalendar());
    }

    public byte[] encodeTimeCalendar(Time d, Calendar c) {
        datetime dt = new datetime(d, c);
        return dt.toTimeBytes();
    }

    public Time decodeTime(Time d, Calendar cal, boolean invertTimeZone) {
        if (cal == null) {
            return d;
        }
        long time = d.getTime() - (long)((invertTimeZone ? -1 : 1) * (cal.getTimeZone().getRawOffset() - Calendar.getInstance().getTimeZone().getRawOffset()));
        return new Time(time);
    }

    public Time decodeTime(byte[] int_byte) {
        return this.decodeTimeCalendar(int_byte, new GregorianCalendar());
    }

    public Time decodeTimeCalendar(byte[] int_byte, Calendar c) {
        datetime dt = new datetime(null, int_byte);
        return dt.toTime(c);
    }

    public Date encodeDate(Date d, Calendar cal) {
        if (cal == null) {
            return d;
        }
        cal.setTime(d);
        return new Date(cal.getTime().getTime());
    }

    public byte[] encodeDate(Date d) {
        return this.encodeDateCalendar(d, new GregorianCalendar());
    }

    public byte[] encodeDateCalendar(Date d, Calendar c) {
        datetime dt = new datetime(d, c);
        return dt.toDateBytes();
    }

    public Date decodeDate(Date d, Calendar cal) {
        if (cal == null || d == null) {
            return d;
        }
        cal.setTime(d);
        return new Date(cal.getTime().getTime());
    }

    public Date decodeDate(byte[] byte_int) {
        return this.decodeDateCalendar(byte_int, new GregorianCalendar());
    }

    public Date decodeDateCalendar(byte[] byte_int, Calendar c) {
        datetime dt = new datetime(byte_int, null);
        return dt.toDate(c);
    }

    public boolean decodeBoolean(byte[] data) {
        return data[0] != 0;
    }

    public byte[] encodeBoolean(boolean value) {
        return new byte[]{(byte)(value ? 1 : 0)};
    }

    public byte[] encodeLocalTime(int hour, int minute, int second, int nanos) {
        datetime dt = new datetime(0, 0, 0, hour, minute, second, nanos);
        return dt.toTimeBytes();
    }

    public byte[] encodeLocalDate(int year, int month, int day) {
        datetime dt = new datetime(year, month, day, 0, 0, 0, 0);
        return dt.toDateBytes();
    }

    public byte[] encodeLocalDateTime(int year, int month, int day, int hour, int minute, int second, int nanos) {
        datetime dt = new datetime(year, month, day, hour, minute, second, nanos);
        byte[] date = dt.toDateBytes();
        byte[] time = dt.toTimeBytes();
        byte[] result = new byte[8];
        System.arraycopy(date, 0, result, 0, 4);
        System.arraycopy(time, 0, result, 4, 4);
        return result;
    }

    private class datetime {
        private static final int NANOSECONDS_PER_FRACTION = 100000;
        private static final int FRACTIONS_PER_MILLISECOND = 10;
        private static final int FRACTIONS_PER_SECOND = 10000;
        private static final int FRACTIONS_PER_MINUTE = 600000;
        private static final int FRACTIONS_PER_HOUR = 36000000;
        int year;
        int month;
        int day;
        int hour;
        int minute;
        int second;
        int fractions;

        datetime(int year, int month, int day, int hour, int minute, int second, int nanos) {
            this.year = year;
            this.month = month;
            this.day = day;
            this.hour = hour;
            this.minute = minute;
            this.second = second;
            this.fractions = nanos / 100000 % 10000;
        }

        datetime(Timestamp value, Calendar cOrig) {
            Calendar c = (Calendar)cOrig.clone();
            c.setTime(value);
            this.year = c.get(1);
            this.month = c.get(2) + 1;
            this.day = c.get(5);
            this.hour = c.get(11);
            this.minute = c.get(12);
            this.second = c.get(13);
            this.fractions = value.getNanos() / 100000;
        }

        datetime(Date value, Calendar cOrig) {
            Calendar c = (Calendar)cOrig.clone();
            c.setTime(value);
            this.year = c.get(1);
            this.month = c.get(2) + 1;
            this.day = c.get(5);
            this.hour = 0;
            this.minute = 0;
            this.second = 0;
            this.fractions = 0;
        }

        datetime(Time value, Calendar cOrig) {
            Calendar c = (Calendar)cOrig.clone();
            c.setTime(value);
            this.year = 0;
            this.month = 0;
            this.day = 0;
            this.hour = c.get(11);
            this.minute = c.get(12);
            this.second = c.get(13);
            this.fractions = c.get(14) * 10;
        }

        datetime(byte[] date, byte[] time) {
            if (date != null) {
                int sql_date = XSQLVAR.this.decodeInt(date);
                int century = (4 * (sql_date += 678882) - 1) / 146097;
                sql_date = 4 * sql_date - 1 - 146097 * century;
                this.day = sql_date / 4;
                sql_date = (4 * this.day + 3) / 1461;
                this.day = 4 * this.day + 3 - 1461 * sql_date;
                this.day = (this.day + 4) / 4;
                this.month = (5 * this.day - 3) / 153;
                this.day = 5 * this.day - 3 - 153 * this.month;
                this.day = (this.day + 5) / 5;
                this.year = 100 * century + sql_date;
                if (this.month < 10) {
                    this.month += 3;
                } else {
                    this.month -= 9;
                    ++this.year;
                }
            }
            if (time != null) {
                int fractionsInDay = XSQLVAR.this.decodeInt(time);
                this.hour = fractionsInDay / 36000000;
                this.minute = (fractionsInDay -= this.hour * 36000000) / 600000;
                this.second = (fractionsInDay -= this.minute * 600000) / 10000;
                this.fractions = fractionsInDay - this.second * 10000;
            }
        }

        byte[] toTimeBytes() {
            int fractionsInDay = this.hour * 36000000 + this.minute * 600000 + this.second * 10000 + this.fractions;
            return XSQLVAR.this.encodeInt(fractionsInDay);
        }

        byte[] toDateBytes() {
            int cpMonth = this.month;
            int cpYear = this.year;
            if (cpMonth > 2) {
                cpMonth -= 3;
            } else {
                cpMonth += 9;
                --cpYear;
            }
            int c = cpYear / 100;
            int ya = cpYear - 100 * c;
            int value = 146097 * c / 4 + 1461 * ya / 4 + (153 * cpMonth + 2) / 5 + this.day + 1721119 - 2400001;
            return XSQLVAR.this.encodeInt(value);
        }

        Time toTime(Calendar cOrig) {
            Calendar c = (Calendar)cOrig.clone();
            c.set(1, 1970);
            c.set(2, 0);
            c.set(5, 1);
            c.set(11, this.hour);
            c.set(12, this.minute);
            c.set(13, this.second);
            c.set(14, this.fractions / 10);
            return new Time(c.getTime().getTime());
        }

        Timestamp toTimestamp(Calendar cOrig) {
            Calendar c = (Calendar)cOrig.clone();
            c.set(1, this.year);
            c.set(2, this.month - 1);
            c.set(5, this.day);
            c.set(11, this.hour);
            c.set(12, this.minute);
            c.set(13, this.second);
            Timestamp timestamp = new Timestamp(c.getTime().getTime());
            timestamp.setNanos(this.fractions * 100000);
            return timestamp;
        }

        Date toDate(Calendar cOrig) {
            Calendar c = (Calendar)cOrig.clone();
            c.set(1, this.year);
            c.set(2, this.month - 1);
            c.set(5, this.day);
            c.set(11, 0);
            c.set(12, 0);
            c.set(13, 0);
            c.set(14, 0);
            return new Date(c.getTime().getTime());
        }
    }
}

