/****************************************************************************/
/* SYSTEM_ID : GF                                                           */
/* TYPESB01 ( PACKAGE )                                                     */
/* Created : 2014/05/23 18:59:14                                            */
/****************************************************************************/
CREATE PACKAGE TYPESB01 
PACKAGE TYPESB01 AS
/*************************************************************************/
/*	 title 		：	品番マスタ検索処理								 	 */
/*	 version	：	001												 	 */
/*	 date/author：	2003/06/30	K.Hasegawa(MIS)							 */
/*	 text		：	変更履歴管理開始									 */
/*************************************************************************/
	TYPE CUST_CURSOR IS REF CURSOR;
	PROCEDURE TYPESB01(
		P_KEKKA		OUT	NUMBER,
		P_ERRMSGS	OUT	ERR_MSG_ARRAY,
		P_RC1		OUT	CUST_CURSOR,
		P_ARGS		IN	ARG_ARRAY );
END;
/
/****************************************************************************/
/* SYSTEM_ID : GF                                                           */
/* TYPESB01 ( PACKAGE BODY )                                                */
/* Created : 2014/05/23 18:59:14                                            */
/****************************************************************************/
CREATE PACKAGE BODY TYPESB01 
PACKAGE BODY TYPESB01 AS
/*****************************************************************************/
/*	品番マスタ検索処理													 	 */
/*****************************************************************************/

	PROCEDURE TYPESB01(
		P_KEKKA		OUT	NUMBER,
		P_ERRMSGS	OUT	ERR_MSG_ARRAY,
		P_RC1		OUT	CUST_CURSOR,
		P_ARGS		IN	ARG_ARRAY ) IS
-------------------------------------------------------------------------------
---------------------------<< 変数宣言 >> -------------------------------------
-------------------------------------------------------------------------------
	-- エラーラベル
	SUBSCRIPT_NOT_EXISTS	EXCEPTION;	-- 配列要素エラー
	TOO_MANY_ERRORS			EXCEPTION;	-- エラー件数最大数オーバーエラー
	ACQUIRE_WITH_NOWAIT		EXCEPTION;	-- NOWAIT時ロックエラー

	TEST_ERROR				EXCEPTION;

	P_SYSTEM_ID		GF41.SYSTEM_ID%TYPE	:= P_ARGS(1);	--システムＩＤ
	P_LANG			GF41.LANG%TYPE		:= P_ARGS(2);	--言語
	P_CLM			GF41.CLM%TYPE		:= P_ARGS(3);	--項目
	P_NAME_JA		GF41.NAME_JA%TYPE	:= P_ARGS(4);	--名称（漢字）
	P_LABEL_NAME	GF41.LABEL_NAME%TYPE	:= P_ARGS(5);	--表示名称
	P_KBSAKU		GF41.KBSAKU%TYPE		:= P_ARGS(6);	--作成区分

	BEGIN
		P_KEKKA := 0;

		OPEN P_RC1 FOR
			SELECT CLM,NAME_JA,LABEL_NAME,KBSAKU,SYSTEM_ID,LANG,FGJ,DECODE(KBSAKU,'0','0','1') AS ONMARK
			FROM  GF41
			WHERE	FGJ         in  ('0','1')
			AND		SYSTEM_ID   like P_SYSTEM_ID	|| '%'
			AND		LANG        like P_LANG			|| '%'
			AND		CLM         like P_CLM			|| '%'
			AND		NAME_JA     like P_NAME_JA		|| '%'
			AND		LABEL_NAME  like P_LABEL_NAME	|| '%'
			AND		KBSAKU      like P_KBSAKU		|| '%'
			ORDER BY SYSTEM_ID,CLM,LANG ;

	EXCEPTION
		WHEN HYBS.TOO_MANY_ERRORS THEN
			HYBS.SET_LIMITOVER(P_ERRMSGS);
			P_KEKKA := 2;
		WHEN TEST_ERROR THEN
			HYBS.SET_ERRMSGS(P_ERRMSGS,				-- エラーメッセージ配列
						1,							-- 行番号
						2,							-- エラー結果(0:正常 1:警告 2:異常)
						'TEST_ERROR',				-- オラクルエラーコード
						substrb( SQLERRM,1,100 ));	-- オラクルエラーメッセージ
			P_KEKKA := 2;
		WHEN OTHERS THEN
--			オラクルエラー。
			HYBS.SET_ERRMSGS(P_ERRMSGS,				-- エラーメッセージ配列
						2,							-- 行番号
						2,							-- エラー結果(0:正常 1:警告 2:異常)
						to_char(SQLCODE),			-- オラクルエラーコード
						substrb( SQLERRM,1,100 ));	-- オラクルエラーメッセージ
			P_KEKKA := 2;
	END TYPESB01;

END TYPESB01;
/
