<?xml version="1.0" encoding="UTF-8" ?>
<jsp:root
	xmlns:jsp="http://java.sun.com/JSP/Page"
	xmlns:og="hybs-taglib.tld"
	version="2.0">
<jsp:directive.page language="java" contentType="text/html; charset=UTF-8" />

<og:head headType="result" />
<jsp:directive.include file="/jsp/custom/result_info.jsp" />
<og:comment
	system	= "GF:エンジンサンプル"
	pgid	= "GF2180"
	title	= "テーブル"
	date	= "2014/05/01"
	author	= "K.Hasegawa"
	text	= ""
	version	= "001"
/>

<og:errorMessage command="{@command}" clear="{@clear}" displayMsg="{@displayMsg}" />

<og:columnCheck
	command   = "{@command}"
/>

<og:entry command = "{@command}" />

<og:query command="{@command}" debug="{@debug}" maxRowCount="{@maxRowCount}">
		select SYSTEM_ID , TBLSYU , TABLE_NAME , NAME_JA , NOJUN , '←' as ARROW , CDIKOU
				, F_SYSTEM_ID , F_TABLE_NAME , F_NAME_JA , SUIKOU , F_FILEPATH , DESCRIPTION
				, FGJ , UNIQ
		from GF84
	<og:where>
		<og:and value = "FGJ			in   ('0','1')"				/>
		<og:and value = "SYSTEM_ID		=    '{@SYSTEM_ID}'"		/>
		<og:and value = "TBLSYU			=    '{@TBLSYU}'"			/>
		<og:and value = "TABLE_NAME		like '{@TABLE_NAME}%'"		/>
		<og:and value = "NAME_JA		like '{@NAME_JA}%'"			/>
		<og:and value = "CDIKOU			=    '{@CDIKOU}'"			/>
		<og:and value = "F_SYSTEM_ID	=    '{@F_SYSTEM_ID}'"		/>
		<og:and value = "F_TABLE_NAME	like '{@F_TABLE_NAME}%'"	/>
		<og:and value = "F_NAME_JA		like '{@F_NAME_JA}%'"		/>
		<og:and value = "DESCRIPTION	like '{@DESCRIPTION}%'"		/>
	</og:where>
	<og:appear startKey = "order by" value = "{@ORDER_BY}"
				defaultVal = "SYSTEM_ID,TBLSYU,NOJUN,TABLE_NAME" />
</og:query>

<og:columnEditor column="ARROW" label="" />

<form onSubmit="return oneClick();" method="POST" action="forward.jsp" target="RESULT">
	<og:writeCheck>
		<og:input name="repeatCount" value="1" lbl="" td="false" size="2"/>
		<og:submit  action="COPY"    noWritable="ARROW" />
		<og:submit  action="MODIFY"  noWritable="ARROW,SYSTEM_ID,TBLSYU,TABLE_NAME" />
		<og:submit  action="DELETE"  columnWritable="null" />

		<og:fieldset lbl="INSERT_GF84">
			<og:hidden  name="SYSTEM_ID" value="{@SYSTEM_ID}"/>
			<!-- must="true" にすると、隠れていると判らないので、色だけ付けて、insertGF84.jsp でチェック -->
			<og:column  name="SYSTEM_ID" size="5" td="no" clazz="must" />
			<og:column  name="TBLSYU"    defaultVal="D" addNoValue="false" td="no" />
			<og:column  name="TABLE_NAME" size="10" td="no" clazz="aimai" />
			<og:submit  value="insertGF84" lbl="INSERT" command="INSERT" />
		</og:fieldset>

		<og:fieldset lbl="{@LBL.NOJUN} Plus">
			<og:column  name="PLUS" size="5" />
			<og:submit  command="MODIFY"  value="update" columnWritable="NOJUN" />
		</og:fieldset>
		<br />
	</og:writeCheck>

	<og:view
		viewFormType  = "HTMLTable"
		command       = "{@command}"
		noDisplay     = "UNIQ,FGJ"
		checked       = "{@checked}"
		startNo       = "{@startNo}"
		pageSize      = "{@pageSize}" />
</form>

<jsp:directive.include file="/jsp/common/htmlend.jsp" />
</jsp:root>
