/*
 * Copyright (c) 2009 The openGion Project.
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND,
 * either express or implied. See the License for the specific language
 * governing permissions and limitations under the License.
 */
package org.opengion.plugin.column;

import org.opengion.hayabusa.db.AbstractDBType;

/**
 * 一般的な半角文字列を扱う為の、カラム属性を定義します。
 *
 * 半角文字列とは、「 c &lt; 0x20 || c &gt; 0x7e 以外」でのみ
 * 構成された文字列のことです。
 *
 * タイプチェックとして、以下の条件を判定します。
 * ・文字列長は、Byte換算での文字数との比較
 * ・半角文字列チェック「 c &lt; 0x20 || c &gt; 0x7e 以外」エラー
 * ・文字パラメータの 正規表現チェック
 * ・クロスサイトスクリプティングチェック
 *
 * @og.group データ属性
 *
 * @version  4.0
 * @author   Kazuhiko Hasegawa
 * @since    JDK5.0,
 */
public class DBType_X extends AbstractDBType {
	//* このプログラムのVERSION文字列を設定します。	{@value} */
	private static final String VERSION = "4.0.0.0 (2005/08/31)" ;

	/**
	 * デフォルトコンストラクター
	 *
	 * @og.rev 4.0.0.0 (2005/01/31) type 廃止
	 */
	public DBType_X() {}

	/**
	 * コンストラクター
	 * 各サブクラスのタイプ値とデフォルト値を設定して、オブジェクトを構築します。
	 *
	 * @og.rev 4.0.0.0 (2005/01/31) type 廃止
	 *
	 * @param  defValue データのデフォルト値
	 */
	public DBType_X( final String defValue ) {
		super( defValue );
	}
}
