/*
 * Copyright (c) 2009 The openGion Project.
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND,
 * either express or implied. See the License for the specific language
 * governing permissions and limitations under the License.
 */
package org.opengion.plugin.column;

import org.opengion.hayabusa.db.CellEditor;
import org.opengion.hayabusa.db.DBColumn;
import org.opengion.hayabusa.db.SelectionFactory;		// 5.7.3.0 (2014/02/07)

/**
 * カラムの編集パラメーターの開始、終了、ステップ、フォーマット、titleフォーマットの情報より、
 * プルダウンメニューを作成して編集する場合に使用するエディタークラスです。
 *
 * パラメータの初期値は、開始(0)、終了(14)、ステップ(1)、フォーマット(MM/dd)、titleフォーマット(null) です。
 * 
 * ここでは、日付(年/月/日）の自動生成を行います。
 * 基準は、実行日に対して、＋－の数字を指定します。
 * 例：20130206 に対して、-2,3,1 を指定すると、20130204,20130205,20130206,20130207,20130208,20130209 となります。
 * 
 * 開始、終了に、特殊なコマンドを指定する事も可能です。
 * ・SD ：当月の最初の日付にセットします。(当月１日)
 * ・ED ：当月の最後の日付にセットします。(当月月末)
 * ・SW ：日付処理の週初め(月曜日)にセットします。日付は当日より前に移動します。
 * ・EW ：日付処理の週末(日曜日)にセットします。日付は当日より後ろに移動します。
 * ・D1 ～ DXXX ：日を指定の分だけ進めます。D1なら翌日、D200 なら200日後
 * ・M1 ～ MXXX ：月を指定の分だけ進めます。M1なら翌月、M6 なら半年後
 * ・BSD ：先月の最初の日付にセットします。(先月１日)
 * ・BED ：先月の最後の日付にセットします。(先月月末)
 * ・ASD ：翌月の最初の日付にセットします。(翌月１日)
 * ・AED ：翌月の最後の日付にセットします。(翌月月末)
 * ・M1  ：１か月先。数字部分は、任意に指定できるため、M5 とすれば、５か月先。M-2 は、２か月前
 *
 * ステップは、無指定の場合は、１日単位です。例えば、SW,M6,7 とすれば、毎週月曜日を６か月先まで作成します。
 * また、M1 は、１か月単位になります。ただし、開始日を SD などにしないと、大の月と小の月で、おかしくなるので
 * ご注意ください。
 *
 * キーは、８文字の yyyyMMdd 形式で与えられます。ラベルは、フォーマットの指定に準拠します。
 * フォーマットを指定する場合は、ステップは、必須となります。
 * フォーマットの初期値は、MM/dd です。
 * titleフォーマット は、tips表示する場合のフォーマットになります。初期値は、ありません。
 *
 * カラムの表示に必要な属性は, DBColumn オブジェクト より取り出します。
 * このクラスは、DBColumn オブジェクト毎に１つ作成されます。
 *
 * @og.rev 5.6.1.1 (2013/02/08) 新規作成
 * @og.group データ編集
 *
 * @version  4.0
 * @author	 Kazuhiko Hasegawa
 * @since    JDK5.0,
 */
public class Editor_YMDMENU extends Editor_MENU {
	//* このプログラムのVERSION文字列を設定します。	{@value} */
	private static final String VERSION = "5.7.3.0 (2014/02/07)" ;

	/**
	 * デフォルトコンストラクター。
	 * このコンストラクターで、基本オブジェクトを作成します。
	 *
	 */
	public Editor_YMDMENU() {
		super();
	}

	/**
	 * コンストラクター。
	 *
	 * ここでは、親クラスの Editor_MENU で初期化を行い、セレクションオブジェクト に、
	 * Selection_YMD を使用するように再設定します。
	 *
	 * @og.rev 5.7.3.0 (2014/02/07) SelectionFactory 対応
	 *
	 * @param	clm	DBColumnオブジェクト
	 */
	private Editor_YMDMENU( final DBColumn clm ) {
		super( clm );

		selection = SelectionFactory.newSelection( "YMD" , clm.getCodeData() );
	}

	/**
	 * 各オブジェクトから自分のインスタンスを返します。
	 * 自分自身をキャッシュするのか、新たに作成するのかは、各サブクラスの実装に
	 * まかされます。
	 *
	 * @param	clm	DBColumnオブジェクト
	 *
	 * @return	CellEditorオブジェクト
	 */
	@Override
	public CellEditor newInstance( final DBColumn clm ) {
		return new Editor_YMDMENU( clm );
	}
}
