/*
 * Copyright (c) 2009 The openGion Project.
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND,
 * either express or implied. See the License for the specific language
 * governing permissions and limitations under the License.
 */
package org.opengion.plugin.io;

import java.io.PrintWriter;

import org.opengion.hayabusa.db.DBTableModel;

/**
 * 固定長文字ファイルの書き出しクラスです。
 * DefaultTableWriter を継承していますので，ラベル，名前，サイズ，データの
 * 出力部のみオーバーライドして，固定長文字ファイルの出力機能を実現しています。
 *
 * なお，固定長出力されるのは，データ部のみで，ラベル，名前，サイズは，
 * separator で指定された区切り記号で連結されて出力されます。
 *
 * @og.group ファイル出力
 *
 * @version  4.0
 * @author   Kazuhiko Hasegawa
 * @since    JDK5.0,
 */
public class TableWriter_Fixed extends TableWriter_Default {
	//* このプログラムのVERSION文字列を設定します。	{@value} */
	private static final String VERSION = "4.0.0.0 (2005/08/31)" ;

	/**
	 * PrintWriter に DBTableModelのテーブル情報を書き込みます。
	 *
	 * @og.rev 2.3.1.2 (2003/01/28) データ出力時に、改行が余分に出される箇所を修正。
	 * @og.rev 3.1.1.0 (2003/03/28) 同期メソッド(synchronized付き)を非同期に変更する。
	 * @og.rev 3.5.4.5 (2004/01/23) 文字列のエンコード指定(桁数判定)
	 *
	 * @param	table  DBTableModelオブジェクト
	 * @param	writer PrintWriterオブジェクト
	 */
	@Override
	protected void writeData( final DBTableModel table,final PrintWriter writer ) {
		int numberOfRows    =  table.getRowCount();
		String encode = getEncode();

		for( int row=0; row<numberOfRows; row++ ) {
			for( int i=0; i<numberOfColumns; i++ ) {
				int clm = clmNo[i];
				writer.print( dbColumn[clm].getWriterValue( table.getValue(row,clm),encode ) );
			}
			writer.println();
		}
	}
}
