/*
 * Decompiled with CFR 0.152.
 */
package org.opengion.fukurou.util;

import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Calendar;
import java.util.Date;
import java.util.HashMap;
import java.util.Locale;
import java.util.Map;

public final class HybsDateUtil {
    private static final Map<String, String> DATE_FORMAT = new HashMap<String, String>();

    private HybsDateUtil() {
    }

    public static String getDate() {
        SimpleDateFormat simpleDateFormat = new SimpleDateFormat("yyyy/MM/dd HH:mm:ss", Locale.JAPAN);
        return simpleDateFormat.format(new Date());
    }

    public static String getDate(String string) {
        SimpleDateFormat simpleDateFormat = new SimpleDateFormat(string, Locale.JAPAN);
        return simpleDateFormat.format(new Date());
    }

    public static String getDate(long l, String string) {
        SimpleDateFormat simpleDateFormat = new SimpleDateFormat(string, Locale.JAPAN);
        return simpleDateFormat.format(new Date(l));
    }

    public static String parseNumber(String string) {
        if (string == null) {
            return "";
        }
        StringBuilder stringBuilder = new StringBuilder();
        for (int i = 0; i < string.length(); ++i) {
            char c = string.charAt(i);
            if (c == '/' || c == '-' || c == ' ' || c == ':') continue;
            stringBuilder.append(c);
        }
        return stringBuilder.toString();
    }

    public static String parseTimestamp(String string) {
        if (string == null || string.length() != 8 && string.length() != 14) {
            String string2 = "\u65e5\u4ed8\u6587\u5b57\u5217\u306b\u3001\u4e0d\u6b63\u306a\u5024\u304c\u6307\u5b9a\u3055\u308c\u307e\u3057\u305f\u3002\uff18\u6841 \u307e\u305f\u306f\u3001\uff11\uff14\u6841\u3067\u6307\u5b9a\u3057\u3066\u304f\u3060\u3055\u3044\u3002 value=[" + string + "]";
            throw new RuntimeException(string2);
        }
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append(string.substring(0, 4)).append("-");
        stringBuilder.append(string.substring(4, 6)).append("-");
        stringBuilder.append(string.substring(6, 8)).append(" ");
        if (string.length() == 8) {
            stringBuilder.append("00:00:00");
        } else {
            stringBuilder.append(string.substring(8, 10)).append(":");
            stringBuilder.append(string.substring(10, 12)).append(":");
            stringBuilder.append(string.substring(12, 14));
        }
        return stringBuilder.toString();
    }

    public static String parseDate(String string, int n) {
        return HybsDateUtil.parseDate(string, n, n);
    }

    public static String parseDate(String string, int n, int n2) {
        if (string == null) {
            return "";
        }
        String string2 = HybsDateUtil.parseNumber(string);
        if (n2 > 14) {
            String string3 = "\u65e5\u4ed8\u767b\u9332\u306b\u8a31\u53ef\u3067\u304d\u308b\u6700\u5927\u6841\u6570\u306f\u3001\uff11\uff14\u30b1\u30bf\u3067\u3059\u3002 maxSize=[" + n2 + "]";
            throw new RuntimeException(string3);
        }
        int n3 = string2.length();
        if (n3 == n2) {
            string2 = string;
        } else {
            if (n3 < n || n3 > n2) {
                String string4 = "\u65e5\u4ed8\u6587\u5b57\u5217\u306b\u3001\u4e0d\u6b63\u306a\u5024\u304c\u6307\u5b9a\u3055\u308c\u307e\u3057\u305f\u3002\u6700\u5c0f[" + n + "] \u304b\u3089\u3001\u6700\u5927[" + n2 + "]\u306e\u7bc4\u56f2\u3067\u6307\u5b9a\u3057\u3066\u304f\u3060\u3055\u3044\u3002" + " value=[" + string + "]";
                throw new RuntimeException(string4);
            }
            string2 = string2 + "20000101000000".substring(n3, n2);
        }
        return string2;
    }

    public static boolean isStrict(String string) {
        boolean bl;
        if (string == null || string.length() != 8 && string.length() != 14) {
            return false;
        }
        String string2 = string.length() == 8 ? "yyyyMMdd" : "yyyyMMddHHmmss";
        SimpleDateFormat simpleDateFormat = new SimpleDateFormat(string2, Locale.JAPAN);
        simpleDateFormat.setLenient(false);
        try {
            simpleDateFormat.parse(string);
            bl = true;
        }
        catch (ParseException parseException) {
            bl = false;
        }
        return bl;
    }

    public static String getDateFormat(String string, String string2, String string3) {
        return HybsDateUtil.getDateFormat(string, string2, string3, 0);
    }

    public static String getDateFormat(String string, String string2, String string3, int n) {
        Calendar calendar = HybsDateUtil.getCalendar(string2);
        HybsDateUtil.calendarCalc(calendar, string3, n);
        String string4 = DATE_FORMAT.get(string);
        if (string4 == null) {
            string4 = string;
        }
        SimpleDateFormat simpleDateFormat = null;
        simpleDateFormat = string.indexOf(71) == 0 ? new SimpleDateFormat(string4, new Locale("ja", "JP", "JP")) : new SimpleDateFormat(string4, Locale.JAPAN);
        return simpleDateFormat.format(calendar.getTime());
    }

    public static void calendarCalc(Calendar calendar, String string) {
        HybsDateUtil.calendarCalc(calendar, string, 0);
    }

    public static void calendarCalc(Calendar calendar, String string, int n) {
        if (string != null) {
            if ("SD".equals(string)) {
                if (n != 0) {
                    calendar.add(2, n);
                }
                calendar.set(5, 1);
            } else if ("ED".equals(string)) {
                if (n != 0) {
                    calendar.add(2, n);
                }
                calendar.set(5, calendar.getActualMaximum(5));
            } else if ("BSD".equals(string)) {
                calendar.add(2, n - 1);
                calendar.set(5, 1);
            } else if ("BED".equals(string)) {
                calendar.add(2, n - 1);
                calendar.set(5, calendar.getActualMaximum(5));
            } else if ("ASD".equals(string)) {
                calendar.add(2, n + 1);
                calendar.set(5, 1);
            } else if ("AED".equals(string)) {
                calendar.add(2, n + 1);
                calendar.set(5, calendar.getActualMaximum(5));
            } else if ("SW".equals(string)) {
                int n2;
                if (n != 0) {
                    calendar.add(5, n * 7);
                }
                if ((n2 = calendar.get(7) - 2) > 0) {
                    calendar.add(5, -n2);
                } else if (n2 < 0) {
                    calendar.add(5, -6);
                }
            } else if ("EW".equals(string)) {
                int n3;
                if (n != 0) {
                    calendar.add(5, n * 7);
                }
                if ((n3 = calendar.get(7)) != 1) {
                    calendar.add(5, 8 - n3);
                }
            } else if (string.startsWith("H")) {
                int n4 = n;
                if (string.length() > 1) {
                    n4 += Integer.parseInt(string.substring(1));
                }
                calendar.add(11, n4);
            } else if (string.startsWith("D")) {
                int n5 = n;
                if (string.length() > 1) {
                    n5 += Integer.parseInt(string.substring(1));
                }
                calendar.add(5, n5);
            } else if (string.startsWith("M")) {
                int n6 = n;
                if (string.length() > 1) {
                    n6 += Integer.parseInt(string.substring(1));
                }
                calendar.add(2, n6);
            } else {
                try {
                    int n7 = Integer.parseInt(string) + n;
                    calendar.add(5, n7);
                }
                catch (NumberFormatException numberFormatException) {
                    String string2 = "\u65e5\u4ed8\u5909\u6570\u30d1\u30e9\u30e1\u30fc\u30bf\u306b\u3001\u4e0d\u6b63\u306a\u5024\u304c\u6307\u5b9a\u3055\u308c\u307e\u3057\u305f\u3002\u4ee5\u4e0b\u306e\u4e2d\u304b\u3089\u6307\u5b9a\u3057\u306a\u304a\u3057\u3066\u304f\u3060\u3055\u3044\u3002\u6307\u5b9a\u53ef\u80fd\uff1a[SD,ED,BSD,BED,ASD,AED,SW,EW,H1\uff5eHXXX,D1\uff5eDXXX,M1\uff5eMXXX] prmB=[" + string + "]";
                    throw new RuntimeException(string2, numberFormatException);
                }
            }
        }
    }

    public static Calendar getCalendar(String string) {
        Calendar calendar = Calendar.getInstance();
        if (string == null || string.isEmpty()) {
            return calendar;
        }
        String string2 = HybsDateUtil.parseNumber(string);
        if (string2.length() == 6) {
            string2 = string2 + "01";
        } else if (string2.length() < 8) {
            String string3 = "\u65e5\u4ed8\u6307\u5b9a\u30d1\u30e9\u30e1\u30fc\u30bf\u306b\u3001\u4e0d\u6b63\u306a\u5024\u304c\u6307\u5b9a\u3055\u308c\u307e\u3057\u305f\u3002value=[" + string + "]";
            throw new RuntimeException(string3);
        }
        calendar.clear();
        int n = Integer.parseInt(string2.substring(0, 4));
        int n2 = Integer.parseInt(string2.substring(4, 6)) - 1;
        int n3 = Integer.parseInt(string2.substring(6, 8));
        int n4 = 0;
        int n5 = 0;
        int n6 = 0;
        if (string2.length() >= 14) {
            n4 = Integer.parseInt(string2.substring(8, 10));
            n5 = Integer.parseInt(string2.substring(10, 12));
            n6 = Integer.parseInt(string2.substring(12, 14));
        }
        calendar.set(n, n2, n3, n4, n5, n6);
        return calendar;
    }

    public static String getDatePlus(String string, int n) {
        Calendar calendar = HybsDateUtil.getCalendar(string);
        calendar.add(5, n);
        return HybsDateUtil.getDate(calendar.getTimeInMillis(), "yyyyMMdd");
    }

    public static String getMonthPlus(String string, int n) {
        Calendar calendar = HybsDateUtil.getCalendar(string);
        calendar.set(5, 1);
        calendar.add(2, n);
        return HybsDateUtil.getDate(calendar.getTimeInMillis(), "yyyyMM");
    }

    public static String getDatePlus(String string, String string2, int n, String string3) {
        int n2 = 1;
        int n3 = n;
        if (string2 != null && !string2.isEmpty()) {
            boolean bl = true;
            char c = string2.charAt(string2.length() - 1);
            switch (c) {
                case 'y': {
                    n3 = 1;
                    break;
                }
                case 'M': {
                    n3 = 2;
                    break;
                }
                case 'd': {
                    n3 = 5;
                    break;
                }
                case 'H': {
                    n3 = 11;
                    break;
                }
                case 'm': {
                    n3 = 12;
                    break;
                }
                case 's': {
                    n3 = 13;
                    break;
                }
                default: {
                    bl = false;
                }
            }
            n2 = bl ? Integer.parseInt(string2.substring(0, string2.length() - 1)) : Integer.parseInt(string2);
        }
        Calendar calendar = HybsDateUtil.getCalendar(string);
        calendar.add(n3, n2);
        return HybsDateUtil.getDate(calendar.getTimeInMillis(), string3);
    }

    static {
        DATE_FORMAT.put("YMD", "yyyyMMdd");
        DATE_FORMAT.put("Y2MD", "yyMMdd");
        DATE_FORMAT.put("YM", "yyyyMM");
        DATE_FORMAT.put("MD", "MMdd");
        DATE_FORMAT.put("HMS", "HHmmss");
        DATE_FORMAT.put("YMDHMS", "yyyyMMddHHmmss");
        DATE_FORMAT.put("EEE", "EEE");
        DATE_FORMAT.put("YMDF", "yyyy/MM/dd");
        DATE_FORMAT.put("Y2MDF", "yy/MM/dd");
        DATE_FORMAT.put("YMF", "yyyy/MM");
        DATE_FORMAT.put("HMSF", "HH:mm:ss");
        DATE_FORMAT.put("YMDHMSF", "yyyy/MM/dd HH:mm:ss");
        DATE_FORMAT.put("MDF", "MM/dd");
        DATE_FORMAT.put("MDEF", "MM/dd(EEE)");
        DATE_FORMAT.put("MD2F", "MM\u6708dd\u65e5");
        DATE_FORMAT.put("GYMDF", "GGGGyyyy\u5e74MM\u6708dd\u65e5");
        DATE_FORMAT.put("G2YMDF", "Gyyyy/MM/dd");
        DATE_FORMAT.put("GYMF", "GGGGyyyy\u5e74MM\u6708");
        DATE_FORMAT.put("GYF", "GGGGyyyy");
    }
}

