/*
 * Decompiled with CFR 0.152.
 */
package org.opengion.fukurou.util;

import com.sun.media.jai.codec.FileSeekableStream;
import com.sun.media.jai.util.SimpleCMYKColorSpace;
import java.awt.color.ColorSpace;
import java.awt.color.ICC_ColorSpace;
import java.awt.color.ICC_Profile;
import java.awt.geom.AffineTransform;
import java.awt.image.AffineTransformOp;
import java.awt.image.BufferedImage;
import java.awt.image.ColorConvertOp;
import java.awt.image.RenderedImage;
import java.io.Closeable;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.util.Arrays;
import java.util.Locale;
import javax.imageio.IIOException;
import javax.imageio.ImageIO;
import javax.media.jai.JAI;
import org.opengion.fukurou.util.Closer;
import org.opengion.fukurou.util.LogWriter;

public class ImageResizer {
    private static final String CR = System.getProperty("line.separator");
    private static final String ICC_PROFILE = "ISOcoated_v2_eci.icc";
    private final BufferedImage inputImage;
    private final int inSizeX;
    private final int inSizeY;
    public static final String READER_SUFFIXES;
    public static final String WRITER_SUFFIXES;

    /*
     * Loose catch block
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public ImageResizer(String string) {
        BufferedImage bufferedImage = null;
        if (!ImageResizer.isReaderSuffix(string)) {
            String string2 = "\u5165\u529b\u30d5\u30a1\u30a4\u30eb\u306f" + READER_SUFFIXES + "\u306e\u3044\u305a\u308c\u304b\u306e\u5f62\u5f0f\u306e\u307f\u6307\u5b9a\u53ef\u80fd\u3067\u3059\u3002" + "File=[" + string + "]";
            throw new RuntimeException(string2);
        }
        File file = new File(string);
        try {
            bufferedImage = ImageIO.read(file);
        }
        catch (IIOException iIOException) {
        }
        catch (IOException iOException) {
            String string3 = "\u30a4\u30e1\u30fc\u30b8\u30d5\u30a1\u30a4\u30eb\u306e\u8aad\u8fbc\u306b\u5931\u6557\u3057\u307e\u3057\u305f\u3002File=[" + string + "]";
            throw new RuntimeException(string3, iOException);
        }
        if (bufferedImage == null) {
            FileSeekableStream fileSeekableStream = null;
            try {
                fileSeekableStream = new FileSeekableStream(file.getAbsolutePath());
                bufferedImage = this.cmykToSRGB(JAI.create((String)"stream", (Object)fileSeekableStream).getAsBufferedImage(null, null));
            }
            catch (IOException iOException) {
                try {
                    String string4 = "\u30a4\u30e1\u30fc\u30b8\u30d5\u30a1\u30a4\u30eb\u306e\u8aad\u8fbc(JAI)\u306b\u5931\u6557\u3057\u307e\u3057\u305f\u3002File=[" + string + "]";
                    throw new RuntimeException(string4, iOException);
                    catch (Exception exception) {
                        String string5 = "\u30a4\u30e1\u30fc\u30b8\u30d5\u30a1\u30a4\u30eb\u306e\u8aad\u8fbc(JAI)\u306b\u5931\u6557\u3057\u307e\u3057\u305f\u3002\u30d5\u30a1\u30a4\u30eb\u304c\u58ca\u308c\u3066\u3044\u308b\u53ef\u80fd\u6027\u304c\u3042\u308a\u307e\u3059\u3002File=[" + string + "]";
                        throw new RuntimeException(string5, exception);
                    }
                }
                catch (Throwable throwable) {
                    Closer.ioClose(fileSeekableStream);
                    throw throwable;
                }
            }
            Closer.ioClose((Closeable)fileSeekableStream);
        }
        this.inputImage = bufferedImage;
        this.inSizeX = this.inputImage.getWidth();
        this.inSizeY = this.inputImage.getHeight();
    }

    public void resizeByPixel(String string, int n) {
        int n2 = 0;
        int n3 = 0;
        if (this.inSizeX > this.inSizeY) {
            n2 = n;
            n3 = this.inSizeY * n / this.inSizeX;
        } else {
            n2 = this.inSizeX * n / this.inSizeY;
            n3 = n;
        }
        this.convert(this.inputImage, string, n2, n3);
    }

    public void resizeByPixel(String string, int n, int n2) {
        this.convert(this.inputImage, string, n, n2);
    }

    public void resizeByRatio(String string, double d) {
        int n = (int)((double)this.inSizeX * d);
        int n2 = (int)((double)this.inSizeY * d);
        this.convert(this.inputImage, string, n, n2);
    }

    private void convert(BufferedImage bufferedImage, String string, int n, int n2) {
        if (!ImageResizer.isWriterSuffix(string)) {
            String string2 = "\u51fa\u529b\u30d5\u30a1\u30a4\u30eb\u306f" + WRITER_SUFFIXES + "\u306e\u3044\u305a\u308c\u304b\u306e\u5f62\u5f0f\u306e\u307f\u6307\u5b9a\u53ef\u80fd\u3067\u3059\u3002" + "File=[" + string + "]";
            throw new RuntimeException(string2);
        }
        File file = new File(string);
        int n3 = bufferedImage.getType();
        BufferedImage bufferedImage2 = null;
        bufferedImage2 = n3 == 0 ? new BufferedImage(n, n2, 7) : new BufferedImage(n, n2, bufferedImage.getType());
        AffineTransformOp affineTransformOp = null;
        affineTransformOp = new AffineTransformOp(AffineTransform.getScaleInstance((double)n / (double)this.inSizeX, (double)n2 / (double)this.inSizeY), null);
        affineTransformOp.filter(bufferedImage, bufferedImage2);
        try {
            String string3 = ImageResizer.getSuffix(string);
            ImageIO.write((RenderedImage)bufferedImage2, string3, file);
        }
        catch (IOException iOException) {
            String string4 = "\u30a4\u30e1\u30fc\u30b8\u30d5\u30a1\u30a4\u30eb\u306e\u4f5c\u6210\u306b\u5931\u6557\u3057\u307e\u3057\u305f\u3002File=[" + string + "]";
            throw new RuntimeException(string4, iOException);
        }
    }

    public static String getSuffix(String string) {
        int n;
        String string2 = null;
        if (string != null && (n = string.lastIndexOf(46)) >= 0) {
            string2 = string.substring(n + 1).toLowerCase(Locale.JAPAN);
        }
        return string2;
    }

    public static final boolean isReaderSuffix(String string) {
        String string2 = ImageResizer.getSuffix(string);
        return string2 != null && READER_SUFFIXES.indexOf(string2) >= 0;
    }

    public static final boolean isWriterSuffix(String string) {
        String string2 = ImageResizer.getSuffix(string);
        return string2 != null && WRITER_SUFFIXES.indexOf(string2) >= 0;
    }

    public BufferedImage cmykToSRGB(BufferedImage bufferedImage) throws IOException {
        Object object;
        ClassLoader classLoader = Thread.currentThread().getContextClassLoader();
        InputStream inputStream = classLoader.getResourceAsStream(ICC_PROFILE);
        ColorSpace colorSpace = null;
        if (inputStream != null) {
            object = ICC_Profile.getInstance(inputStream);
            colorSpace = new ICC_ColorSpace((ICC_Profile)object);
        } else {
            object = "ISOcoated_v2_eci.icc \u304c\u898b\u3064\u304b\u308a\u307e\u305b\u3093\u3002" + CR + " CLASSPATH\u306e\u8a2d\u5b9a\u3055\u308c\u3066\u3044\u308b\u5834\u6240\u306b\u914d\u5099\u3057\u3066\u304f\u3060\u3055\u3044\u3002" + CR + " \u6a19\u6e96\u306eSimpleCMYKColorSpace\u3092\u4f7f\u7528\u3057\u307e\u3059\u306e\u3067\u30a8\u30e9\u30fc\u306b\u306f\u306a\u308a\u307e\u305b\u3093\u304c\u3001\u975e\u5e38\u306b\u9045\u3044\u3067\u3059\u3002";
            System.out.println((String)object);
            colorSpace = SimpleCMYKColorSpace.getInstance();
        }
        object = new BufferedImage(bufferedImage.getWidth(), bufferedImage.getHeight(), 1);
        ColorSpace colorSpace2 = ((BufferedImage)object).getColorModel().getColorSpace();
        ColorConvertOp colorConvertOp = new ColorConvertOp(colorSpace, colorSpace2, null);
        colorConvertOp.filter(bufferedImage, (BufferedImage)object);
        int n = ((BufferedImage)object).getWidth();
        int n2 = ((BufferedImage)object).getHeight();
        for (int i = 0; i < n; ++i) {
            for (int j = 0; j < n2; ++j) {
                int n3 = ((BufferedImage)object).getRGB(i, j);
                int n4 = (n3 & 0xFF0000) >> 16;
                int n5 = (n3 & 0xFF00) >> 8;
                int n6 = n3 & 0xFF;
                n3 = (Math.abs(n4 - 255) << 16) + (Math.abs(n5 - 255) << 8) + Math.abs(n6 - 255);
                ((BufferedImage)object).setRGB(i, j, n3);
            }
        }
        return object;
    }

    public static void main(String[] stringArray) {
        if (stringArray.length < 3) {
            LogWriter.log("Usage: java org.opengion.fukurou.util.ImageResizer [Input Filename] [OutputFilename] [MaxResize]");
            return;
        }
        ImageResizer imageResizer = new ImageResizer(stringArray[0]);
        imageResizer.resizeByPixel(stringArray[1], Integer.parseInt(stringArray[2]));
    }

    static {
        Object[] objectArray = ImageIO.getReaderFileSuffixes();
        Arrays.sort(objectArray);
        READER_SUFFIXES = Arrays.toString(objectArray);
        Object[] objectArray2 = ImageIO.getWriterFileSuffixes();
        Arrays.sort(objectArray2);
        WRITER_SUFFIXES = Arrays.toString(objectArray2);
    }
}

