/*
 * Decompiled with CFR 0.152.
 */
package org.opengion.plugin.io;

import java.io.Closeable;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.PrintWriter;
import java.util.Locale;
import org.apache.poi.hssf.usermodel.HSSFWorkbook;
import org.apache.poi.ss.usermodel.Cell;
import org.apache.poi.ss.usermodel.CreationHelper;
import org.apache.poi.ss.usermodel.Font;
import org.apache.poi.ss.usermodel.RichTextString;
import org.apache.poi.ss.usermodel.Row;
import org.apache.poi.ss.usermodel.Sheet;
import org.apache.poi.ss.usermodel.Workbook;
import org.apache.poi.ss.usermodel.WorkbookFactory;
import org.apache.poi.xssf.usermodel.XSSFWorkbook;
import org.opengion.fukurou.model.NativeType;
import org.opengion.fukurou.util.Closer;
import org.opengion.fukurou.util.StringUtil;
import org.opengion.hayabusa.common.HybsSystem;
import org.opengion.hayabusa.common.HybsSystemException;
import org.opengion.hayabusa.db.DBTableModel;
import org.opengion.plugin.io.TableWriter_Default;

public class TableWriter_Excel
extends TableWriter_Default {
    private static final String VERSION = "6.0.1.2 (2014/08/08)";
    private Sheet sheet = null;
    private int nRowIndex = 0;
    private String filename = null;
    private String sheetName = "Sheet1";
    private String fontName = null;
    private short fontPoint = (short)-1;
    private String refFilename = null;
    private String refSheetName = null;
    private CreationHelper createHelper = null;
    private boolean useNumber = true;
    private int skipRowCount = 0;

    @Override
    public void writeDBTable() {
        int n;
        boolean bl;
        this.useNumber = this.isUseNumber();
        if (this.filename == null) {
            String string = "\u30d5\u30a1\u30a4\u30eb\u304c\u6307\u5b9a\u3055\u308c\u3066\u3044\u307e\u305b\u3093\u3002";
            throw new HybsSystemException(string);
        }
        if (this.isAppend()) {
            if (this.refFilename != null && !this.filename.equalsIgnoreCase(this.refFilename)) {
                String string = "\u8ffd\u52a0(append\u30e2\u30fc\u30c9)\u306e\u6642\u3001\u96db\u5f62\u30d5\u30a1\u30a4\u30eb\u306e\u6307\u5b9a\u306f\u7121\u52b9\u3067\u3059\u3002" + HybsSystem.CR + " filename=[" + this.filename + "] , refFilename=[" + this.refFilename + "]" + HybsSystem.CR;
                throw new HybsSystemException(string);
            }
            this.refFilename = this.filename;
        }
        String string = this.filename;
        boolean bl2 = bl = this.refFilename != null && this.refFilename.length() > 0;
        if (bl) {
            string = this.refFilename;
        }
        Workbook workbook = this.createWorkbook(string, bl);
        int n2 = n = bl ? workbook.getNumberOfSheets() : 0;
        if (this.isAppend()) {
            n = 0;
        }
        if (bl) {
            int n3 = 0;
            if (this.refSheetName != null) {
                n3 = workbook.getSheetIndex(this.refSheetName);
            }
            if (n3 < 0) {
                String string2 = "\u6307\u5b9a\u306e\u96db\u5f62\u30b7\u30fc\u30c8\u540d\u306f\u3001\u96db\u578b\u30d5\u30a1\u30a4\u30eb\u306b\u5b58\u5728\u3057\u307e\u305b\u3093\u3067\u3057\u305f\u3002" + HybsSystem.CR + " refFilename=[" + this.refFilename + "] , refSheetName=[" + this.refSheetName + "]" + HybsSystem.CR;
                throw new HybsSystemException(string2);
            }
            this.sheet = workbook.cloneSheet(n3);
        } else {
            Font font = workbook.getFontAt((short)0);
            if (this.fontName != null) {
                font.setFontName(this.fontName);
            }
            if (this.fontPoint > 0) {
                font.setFontHeightInPoints(this.fontPoint);
            }
            this.sheet = workbook.createSheet();
        }
        workbook.setSheetName(workbook.getNumberOfSheets() - 1, this.getNewSheetNameByName(workbook, this.sheetName));
        this.createHelper = workbook.getCreationHelper();
        this.nRowIndex = this.skipRowCount;
        super.writeDBTable(null);
        this.removeSheetRow(this.sheet, this.nRowIndex);
        if (bl) {
            for (int i = 0; i < n; ++i) {
                workbook.removeSheetAt(0);
            }
        }
        FileOutputStream fileOutputStream = null;
        try {
            fileOutputStream = new FileOutputStream(this.filename);
            workbook.write((OutputStream)fileOutputStream);
        }
        catch (IOException iOException) {
            try {
                String string3 = "\u30d5\u30a1\u30a4\u30eb\u3078\u66f8\u8fbc\u307f\u4e2d\u306b\u30a8\u30e9\u30fc\u304c\u767a\u751f\u3057\u307e\u3057\u305f\u3002" + HybsSystem.CR + iOException.getMessage() + HybsSystem.CR + "  File=" + this.filename;
                throw new HybsSystemException(string3, (Throwable)iOException);
            }
            catch (Throwable throwable) {
                Closer.ioClose(fileOutputStream);
                if (null != this.sheet) {
                    this.sheet = null;
                }
                if (null != workbook) {
                    workbook = null;
                }
                throw throwable;
            }
        }
        Closer.ioClose((Closeable)fileOutputStream);
        if (null != this.sheet) {
            this.sheet = null;
        }
        if (null != workbook) {
            workbook = null;
        }
    }

    protected void writeLabel(DBTableModel dBTableModel, PrintWriter printWriter) {
        int n = 0;
        int n2 = n;
        n = (short)(n + 1);
        Row row = this.setFirstCellValue(this.nRowIndex++, n2, "#Label");
        for (int i = 0; i < this.numberOfColumns; ++i) {
            int n3 = this.clmNo[i];
            if (n3 < 0) {
                int n4 = n;
                n = (short)(n + 1);
                this.setRowCellValue(row, n4, "", 1);
                continue;
            }
            String string = this.dbColumn[n3].getLabel();
            if (i == 0 && !this.useNumber) {
                n = (short)(n - 1);
                string = "#" + string;
            }
            int n5 = n;
            n = (short)(n + 1);
            this.setRowCellValue(row, n5, string, 1);
        }
        this.removeRowCell(row, n);
    }

    protected void writeName(DBTableModel dBTableModel, PrintWriter printWriter) {
        int n = 0;
        int n2 = n;
        n = (short)(n + 1);
        Row row = this.setFirstCellValue(this.nRowIndex++, n2, "#Name");
        for (int i = 0; i < this.numberOfColumns; ++i) {
            int n3 = this.clmNo[i];
            if (n3 < 0) {
                int n4 = n;
                n = (short)(n + 1);
                this.setRowCellValue(row, n4, "", 1);
                continue;
            }
            String string = dBTableModel.getColumnName(n3);
            if (i == 0 && !this.useNumber) {
                n = (short)(n - 1);
                string = "#" + string;
            }
            int n5 = n;
            n = (short)(n + 1);
            this.setRowCellValue(row, n5, string, 1);
        }
        this.removeRowCell(row, n);
    }

    protected void writeSize(DBTableModel dBTableModel, PrintWriter printWriter) {
        int n = 0;
        int n2 = n;
        n = (short)(n + 1);
        Row row = this.setFirstCellValue(this.nRowIndex++, n2, "#Size");
        for (int i = 0; i < this.numberOfColumns; ++i) {
            int n3 = this.clmNo[i];
            if (n3 < 0) {
                int n4 = n;
                n = (short)(n + 1);
                this.setRowCellValue(row, n4, "", 1);
                continue;
            }
            String string = String.valueOf(this.dbColumn[n3].getTotalSize());
            if (i == 0 && !this.useNumber) {
                n = (short)(n - 1);
                string = "#" + string;
            }
            int n5 = n;
            n = (short)(n + 1);
            this.setRowCellValue(row, n5, string, 0);
        }
        this.removeRowCell(row, n);
    }

    protected void writeClass(DBTableModel dBTableModel, PrintWriter printWriter) {
        int n = 0;
        int n2 = n;
        n = (short)(n + 1);
        Row row = this.setFirstCellValue(this.nRowIndex++, n2, "#Class");
        for (int i = 0; i < this.numberOfColumns; ++i) {
            int n3 = this.clmNo[i];
            if (n3 < 0) {
                int n4 = n;
                n = (short)(n + 1);
                this.setRowCellValue(row, n4, "", 1);
                continue;
            }
            String string = this.dbColumn[n3].getClassName();
            if (i == 0 && !this.useNumber) {
                n = (short)(n - 1);
                string = "#" + string;
            }
            int n5 = n;
            n = (short)(n + 1);
            this.setRowCellValue(row, n5, string, 1);
        }
        this.removeRowCell(row, n);
    }

    protected void writeSeparator(DBTableModel dBTableModel, PrintWriter printWriter) {
        String string = "----";
        int n = 0;
        int n2 = n;
        n = (short)(n + 1);
        Row row = this.setFirstCellValue(this.nRowIndex++, n2, "#----");
        for (int i = 0; i < this.numberOfColumns; ++i) {
            if (i == 0 && !this.useNumber) continue;
            int n3 = n;
            n = (short)(n + 1);
            this.setRowCellValue(row, n3, string, 1);
        }
        this.removeRowCell(row, n);
    }

    @Override
    protected void writeData(DBTableModel dBTableModel, PrintWriter printWriter) {
        int n;
        int n2 = dBTableModel.getRowCount();
        boolean[] blArray = new boolean[this.numberOfColumns];
        int[] nArray = new int[this.numberOfColumns];
        boolean bl = this.isUseRenderer();
        for (n = 0; n < this.numberOfColumns; ++n) {
            int n3 = this.clmNo[n];
            if (n3 < 0) continue;
            if (bl && this.dbColumn[n3].isStringOutput()) {
                nArray[n] = 1;
            } else {
                NativeType nativeType = this.dbColumn[n3].getNativeType();
                switch (nativeType) {
                    case INT: 
                    case LONG: 
                    case DOUBLE: {
                        nArray[n] = 0;
                        break;
                    }
                    default: {
                        nArray[n] = 1;
                    }
                }
            }
            blArray[n] = "NVAR".equals(this.dbColumn[n3].getDbType());
        }
        for (int i = 0; i < n2; ++i) {
            n = 0;
            int n4 = n;
            n = (short)(n + 1);
            Row row = this.setFirstCellValue(this.nRowIndex++, n4, String.valueOf(i + 1));
            if (!this.useNumber) {
                n = (short)(n - 1);
            }
            for (int j = 0; j < this.numberOfColumns; ++j) {
                int n5 = this.clmNo[j];
                if (n5 < 0) {
                    int n6 = n;
                    n = (short)(n + 1);
                    this.setRowCellValue(row, n6, "", 1);
                    continue;
                }
                String string = (String)dBTableModel.getValue(i, n5);
                if (blArray[j]) {
                    string = StringUtil.getReplaceEscape((String)string);
                } else if (bl) {
                    string = StringUtil.spanCut((String)this.dbColumn[n5].getRendererValue(string));
                }
                int n7 = n;
                n = (short)(n + 1);
                this.setRowCellValue(row, n7, string, nArray[j]);
            }
            this.removeRowCell(row, n);
        }
    }

    private Row setFirstCellValue(int n, int n2, String string) {
        Cell cell;
        Row row = this.sheet.getRow(n);
        if (row == null) {
            row = this.sheet.createRow(n);
        }
        if (null == (cell = row.getCell(n2))) {
            cell = row.createCell(n2);
        }
        RichTextString richTextString = this.createHelper.createRichTextString(string);
        cell.setCellValue(richTextString);
        return row;
    }

    private void setRowCellValue(Row row, int n, String string, int n2) {
        Cell cell = row.getCell(n);
        if (null == cell) {
            cell = row.createCell(n);
        }
        if (n2 == 0) {
            cell.setCellValue(StringUtil.parseDouble((String)string));
        } else {
            RichTextString richTextString = this.createHelper.createRichTextString(string);
            cell.setCellValue(richTextString);
        }
    }

    private void removeRowCell(Row row, int n) {
        int n2;
        for (int i = n2 = row.getLastCellNum(); i >= n; --i) {
            Cell cell = row.getCell(i);
            if (null == cell) continue;
            row.removeCell(cell);
        }
    }

    private void removeSheetRow(Sheet sheet, int n) {
        int n2;
        for (int i = n2 = sheet.getLastRowNum(); i >= n; --i) {
            Row row = sheet.getRow(i);
            if (null == row) continue;
            sheet.removeRow(row);
        }
    }

    private String getNewSheetNameByName(Workbook workbook, String string) {
        String string2 = string;
        int n = 1;
        while (workbook.getSheetIndex(string2) >= 0) {
            string2 = string + "(" + n + ")";
            ++n;
        }
        return string2;
    }

    public void setFilename(String string) {
        this.filename = string;
    }

    public void setSheetName(String string) {
        if (string != null) {
            this.sheetName = string;
        }
    }

    public boolean isExcel() {
        return true;
    }

    public void setRefFilename(String string) {
        this.refFilename = string;
    }

    public void setRefSheetName(String string) {
        if (string != null) {
            this.refSheetName = string;
        }
    }

    public void setSkipRowCount(int n) {
        this.skipRowCount = n;
    }

    public void setFontName(String string) {
        this.fontName = string;
    }

    public void setFontPoint(short s) {
        this.fontPoint = s;
    }

    private Workbook createWorkbook(String string, boolean bl) {
        Object object;
        block5: {
            block4: {
                if (!bl) break block4;
                FileInputStream fileInputStream = null;
                try {
                    fileInputStream = new FileInputStream(string);
                    object = WorkbookFactory.create((InputStream)fileInputStream);
                }
                catch (Exception exception) {
                    try {
                        String string2 = "\u30d5\u30a1\u30a4\u30eb\u8aad\u8fbc\u307f\u30a8\u30e9\u30fc[" + string + "]";
                        throw new HybsSystemException(string2, (Throwable)exception);
                    }
                    catch (Throwable throwable) {
                        Closer.ioClose(fileInputStream);
                        throw throwable;
                    }
                }
                Closer.ioClose((Closeable)fileInputStream);
                break block5;
            }
            object = string.toLowerCase(Locale.JAPAN).endsWith(".xlsx") ? new XSSFWorkbook() : new HSSFWorkbook();
        }
        return object;
    }
}

