/*
 * Decompiled with CFR 0.152.
 */
package org.opengion.fukurou.db;

import java.sql.Connection;
import java.sql.ParameterMetaData;
import java.sql.PreparedStatement;
import java.sql.SQLException;
import java.util.Arrays;
import org.opengion.fukurou.db.ConnectionFactory;
import org.opengion.fukurou.model.ArrayDataModel;
import org.opengion.fukurou.model.Formatter;
import org.opengion.fukurou.util.ApplicationInfo;
import org.opengion.fukurou.util.Closer;
import org.opengion.fukurou.util.StringUtil;

public class DBSimpleTable {
    private static final String CR = System.getProperty("line.separator");
    private final String[] names;
    private String[] keys = null;
    private int[] keysNo = null;
    private String table = null;
    private String where = null;
    private int[] whereNo = null;
    private String[] constrain = null;
    private String connID = null;
    private boolean useWhere = false;
    private Connection conn = null;
    private PreparedStatement pstmt = null;
    private ParameterMetaData pMeta = null;
    private String query = null;
    private int execCnt = 0;
    private ApplicationInfo appInfo = null;
    private boolean useParamMetaData = false;

    public DBSimpleTable(String[] stringArray) {
        if (stringArray == null) {
            String string = "\u30c7\u30fc\u30bf\u914d\u5217\u306e\u30ab\u30e9\u30e0\u540d\u79f0\u306b null \u306f\u8a2d\u5b9a\u3067\u304d\u307e\u305b\u3093\u3002";
            throw new RuntimeException(string);
        }
        this.names = new String[stringArray.length];
        System.arraycopy(stringArray, 0, this.names, 0, this.names.length);
    }

    public void setKeys(String[] stringArray) {
        if (this.keys != null) {
            String string = "\u3059\u3067\u306b \u30ad\u30fc\u914d\u5217(keys)\u304c\u767b\u9332\u6e08\u307f\u3067\u3059\u3002";
            throw new RuntimeException(string);
        }
        if (stringArray != null) {
            int n = stringArray.length;
            this.keys = new String[n];
            System.arraycopy(stringArray, 0, this.keys, 0, n);
            this.constrain = new String[n];
            Arrays.fill(this.constrain, "?");
            this.keysNo = new int[n];
            for (int i = 0; i < n; ++i) {
                int n2 = this.findAddress(this.names, this.keys[i]);
                if (n2 < 0) {
                    String string = "\u6307\u5b9a\u306e key \u306f\u3001\u30ab\u30e9\u30e0\u914d\u5217(names)\u306b\u5b58\u5728\u3057\u307e\u305b\u3093 key[" + i + "]=" + stringArray[i] + " names=" + StringUtil.array2csv(this.names);
                    throw new RuntimeException(string);
                }
                this.keysNo[i] = n2;
            }
        }
    }

    private void makeKeys() {
        if (this.keys == null) {
            this.keys = this.names;
            int n = this.keys.length;
            this.constrain = new String[n];
            Arrays.fill(this.constrain, "?");
            this.keysNo = new int[n];
            for (int i = 0; i < n; ++i) {
                this.keysNo[i] = i;
            }
        }
    }

    public void setTable(String string) {
        if (string == null) {
            String string2 = "table \u306b null \u306f\u8a2d\u5b9a\u3067\u304d\u307e\u305b\u3093\u3002";
            throw new RuntimeException(string2);
        }
        this.table = string;
    }

    public void setConnectionID(String string) {
        this.connID = string;
    }

    public void setApplicationInfo(ApplicationInfo applicationInfo) {
        this.appInfo = applicationInfo;
    }

    public void addConstrain(String string, String string2) {
        int n;
        if (string == null || string2 == null) {
            String string3 = "key \u307e\u305f\u306f\u3001val \u306b null \u306f\u8a2d\u5b9a\u3067\u304d\u307e\u305b\u3093\u3002 key=[" + string + "] , val=[" + string2 + "]";
            throw new RuntimeException(string3);
        }
        if (this.keys == null) {
            this.makeKeys();
        }
        if ((n = this.findAddress(this.keys, string)) < 0) {
            String string4 = "\u6307\u5b9a\u306e key \u306f\u3001\u30ad\u30fc\u914d\u5217(keys)\u306b\u5b58\u5728\u3057\u307e\u305b\u3093 key=[" + string + "] , val=[" + string2 + "]" + " keys=" + StringUtil.array2csv(this.keys);
            throw new RuntimeException(string4);
        }
        this.constrain[n] = string2;
    }

    public void setWhere(String string) {
        if (string != null) {
            ArrayDataModel arrayDataModel = new ArrayDataModel(this.names);
            Formatter formatter = new Formatter(arrayDataModel);
            formatter.setFormat(string);
            this.where = formatter.getQueryFormatString();
            this.whereNo = formatter.getClmNos();
        } else {
            this.where = null;
        }
    }

    private String getInsertSQL() {
        int n;
        if (this.keys == null) {
            this.makeKeys();
        }
        StringBuilder stringBuilder = new StringBuilder(100);
        stringBuilder.append("INSERT INTO ").append(this.table);
        stringBuilder.append(" ( ");
        stringBuilder.append(this.keys[0]);
        for (n = 1; n < this.keys.length; ++n) {
            stringBuilder.append(',').append(this.keys[n]);
        }
        stringBuilder.append(" ) VALUES ( ");
        stringBuilder.append(this.constrain[0]);
        for (n = 1; n < this.keys.length; ++n) {
            stringBuilder.append(',').append(this.constrain[n]);
        }
        stringBuilder.append(" )");
        this.useWhere = false;
        return stringBuilder.toString();
    }

    private String getUpdateSQL() {
        if (this.keys == null) {
            this.makeKeys();
        }
        StringBuilder stringBuilder = new StringBuilder(100);
        stringBuilder.append("UPDATE ").append(this.table).append(" SET ");
        stringBuilder.append(this.keys[0]).append(" = ").append(this.constrain[0]);
        for (int i = 1; i < this.keys.length; ++i) {
            stringBuilder.append(" , ");
            stringBuilder.append(this.keys[i]).append(" = ").append(this.constrain[i]);
        }
        if (this.where != null && this.where.length() > 0) {
            stringBuilder.append(" WHERE ").append(this.where);
            this.useWhere = true;
        } else {
            this.useWhere = false;
        }
        return stringBuilder.toString();
    }

    private String getDeleteSQL() {
        this.keys = new String[0];
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append("DELETE FROM ").append(this.table);
        if (this.where != null && this.where.length() > 0) {
            stringBuilder.append(" WHERE ").append(this.where);
            this.useWhere = true;
        } else {
            this.useWhere = false;
        }
        return stringBuilder.toString();
    }

    public void startInsert() throws SQLException {
        this.execCnt = 0;
        this.query = this.getInsertSQL();
        this.conn = ConnectionFactory.connection(this.connID, this.appInfo);
        this.pstmt = this.conn.prepareStatement(this.query);
        this.useParamMetaData = ConnectionFactory.useParameterMetaData(this.connID);
        if (this.useParamMetaData) {
            this.pMeta = this.pstmt.getParameterMetaData();
        }
    }

    public void startUpdate() throws SQLException {
        this.execCnt = 0;
        this.query = this.getUpdateSQL();
        this.conn = ConnectionFactory.connection(this.connID, this.appInfo);
        this.pstmt = this.conn.prepareStatement(this.query);
        this.useParamMetaData = ConnectionFactory.useParameterMetaData(this.connID);
        if (this.useParamMetaData) {
            this.pMeta = this.pstmt.getParameterMetaData();
        }
    }

    public void startDelete() throws SQLException {
        this.execCnt = 0;
        this.query = this.getDeleteSQL();
        this.conn = ConnectionFactory.connection(this.connID, this.appInfo);
        this.pstmt = this.conn.prepareStatement(this.query);
        this.useParamMetaData = ConnectionFactory.useParameterMetaData(this.connID);
        if (this.useParamMetaData) {
            this.pMeta = this.pstmt.getParameterMetaData();
        }
    }

    public int execute(String[] stringArray) throws SQLException {
        int n;
        try {
            int n2 = 1;
            if (this.useParamMetaData) {
                String string;
                int n3;
                int n4;
                for (n4 = 0; n4 < this.keys.length; ++n4) {
                    n3 = this.pMeta.getParameterType(n2);
                    string = stringArray[this.keysNo[n4]];
                    if (string == null || string.isEmpty()) {
                        this.pstmt.setNull(n2++, n3);
                        continue;
                    }
                    this.pstmt.setObject(n2++, (Object)string, n3);
                }
                if (this.useWhere) {
                    for (n4 = 0; n4 < this.whereNo.length; ++n4) {
                        n3 = this.pMeta.getParameterType(n2);
                        string = stringArray[this.whereNo[n4]];
                        if (string == null || string.isEmpty()) {
                            this.pstmt.setNull(n2++, n3);
                            continue;
                        }
                        this.pstmt.setObject(n2++, (Object)string, n3);
                    }
                }
            } else {
                int n5;
                for (n5 = 0; n5 < this.keys.length; ++n5) {
                    this.pstmt.setObject(n2++, stringArray[this.keysNo[n5]]);
                }
                if (this.useWhere) {
                    for (n5 = 0; n5 < this.whereNo.length; ++n5) {
                        this.pstmt.setObject(n2++, stringArray[this.whereNo[n5]]);
                    }
                }
            }
            n = this.pstmt.executeUpdate();
            this.execCnt += n;
        }
        catch (SQLException sQLException) {
            Closer.stmtClose(this.pstmt);
            this.pMeta = null;
            if (this.conn != null) {
                this.conn.rollback();
                ConnectionFactory.remove(this.conn, this.connID);
                this.conn = null;
            }
            String string = "DB\u51e6\u7406\u306e\u5b9f\u884c\u306b\u5931\u6557\u3057\u307e\u3057\u305f\u3002" + CR + " query=[" + this.query + "]" + CR + " values=" + StringUtil.array2csv(stringArray);
            throw new RuntimeException(string, sQLException);
        }
        return n;
    }

    public int close(boolean bl) {
        if (this.conn != null) {
            try {
                if (bl) {
                    this.conn.commit();
                } else {
                    this.conn.rollback();
                }
            }
            catch (SQLException sQLException) {
                ConnectionFactory.remove(this.conn, this.connID);
                this.conn = null;
                String string = "DB\u51e6\u7406\u3092\u78ba\u5b9a(COMMIT)\u3067\u304d\u307e\u305b\u3093\u3067\u3057\u305f\u3002" + CR + " query=[" + this.query + "]" + CR;
                throw new RuntimeException(string, sQLException);
            }
            finally {
                Closer.stmtClose(this.pstmt);
                this.pMeta = null;
                ConnectionFactory.close(this.conn, this.connID);
                this.conn = null;
            }
        }
        return this.execCnt;
    }

    private int findAddress(String[] stringArray, String string) {
        int n = -1;
        if (stringArray != null && string != null) {
            for (int i = 0; i < stringArray.length; ++i) {
                if (!string.equalsIgnoreCase(stringArray[i])) continue;
                n = i;
                break;
            }
        }
        return n;
    }
}

