/*
 * Decompiled with CFR 0.152.
 */
package org.opengion.fukurou.db;

import java.io.IOException;
import java.io.Reader;
import java.sql.CallableStatement;
import java.sql.Clob;
import java.sql.Connection;
import java.sql.Date;
import java.sql.ParameterMetaData;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.ResultSetMetaData;
import java.sql.SQLException;
import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.Locale;
import org.opengion.fukurou.db.ConnectionFactory;
import org.opengion.fukurou.db.Transaction;
import org.opengion.fukurou.db.TransactionReal;
import org.opengion.fukurou.util.ApplicationInfo;
import org.opengion.fukurou.util.Closer;
import org.opengion.fukurou.util.HybsDateUtil;
import org.opengion.fukurou.util.StringUtil;

public final class DBUtil {
    private static final String CR = System.getProperty("line.separator");

    private DBUtil() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static String[][] dbExecute(String string, String[] stringArray, ApplicationInfo applicationInfo) {
        try (TransactionReal transactionReal = new TransactionReal(applicationInfo);){
            String[][] stringArray2 = DBUtil.dbExecute(string, stringArray, transactionReal, null, false);
            return stringArray2;
        }
    }

    public static String[][] dbExecute(String string, String[] stringArray, Transaction transaction) {
        return DBUtil.dbExecute(string, stringArray, transaction, null, false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static String[][] dbExecute(String string, String[] stringArray, ApplicationInfo applicationInfo, String string2) {
        try (TransactionReal transactionReal = new TransactionReal(applicationInfo);){
            String[][] stringArray2 = DBUtil.dbExecute(string, stringArray, transactionReal, string2, false);
            return stringArray2;
        }
    }

    public static String[][] dbExecute(String string, String[] stringArray, Transaction transaction, String string2) {
        return DBUtil.dbExecute(string, stringArray, transaction, string2, false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static String[][] dbExecute(String string, String[] stringArray, ApplicationInfo applicationInfo, String string2, boolean bl) {
        try (TransactionReal transactionReal = new TransactionReal(applicationInfo);){
            String[][] stringArray2 = DBUtil.dbExecute(string, stringArray, transactionReal, string2, bl);
            return stringArray2;
        }
    }

    public static String[][] dbExecute(String string, String[] stringArray, Transaction transaction, String string2, boolean bl) {
        String[][] stringArray2;
        ResultSet resultSet;
        PreparedStatement preparedStatement;
        block11: {
            preparedStatement = null;
            resultSet = null;
            stringArray2 = null;
            try {
                boolean bl2;
                Connection connection = transaction.getConnection(string2);
                preparedStatement = connection.prepareStatement(string);
                if (stringArray != null) {
                    bl2 = ConnectionFactory.useParameterMetaData(string2);
                    if (bl2) {
                        ParameterMetaData parameterMetaData = preparedStatement.getParameterMetaData();
                        for (int i = 0; i < stringArray.length; ++i) {
                            int n = parameterMetaData.getParameterType(i + 1);
                            String string3 = stringArray[i];
                            if (string3 == null || string3.isEmpty()) {
                                preparedStatement.setNull(i + 1, n);
                                continue;
                            }
                            preparedStatement.setObject(i + 1, (Object)string3, n);
                        }
                    } else {
                        for (int i = 0; i < stringArray.length; ++i) {
                            preparedStatement.setObject(i + 1, stringArray[i]);
                        }
                    }
                }
                if (bl2 = preparedStatement.execute()) {
                    resultSet = preparedStatement.getResultSet();
                    stringArray2 = DBUtil.resultToArray(resultSet, bl);
                    break block11;
                }
                transaction.commit();
            }
            catch (SQLException sQLException) {
                try {
                    transaction.rollback();
                    String string4 = sQLException.getMessage() + ":" + sQLException.getSQLState() + CR + "SQL=[" + string + "]" + CR + "ARG=[" + StringUtil.array2csv(stringArray) + "]" + CR + "DBID=[" + string2 + "]" + CR;
                    throw new RuntimeException(string4, sQLException);
                }
                catch (Throwable throwable) {
                    Closer.resultClose(resultSet);
                    Closer.stmtClose(preparedStatement);
                    throw throwable;
                }
            }
        }
        Closer.resultClose(resultSet);
        Closer.stmtClose(preparedStatement);
        return stringArray2;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static String[] dbCallExecute(String string, String[] stringArray, ApplicationInfo applicationInfo) {
        try (TransactionReal transactionReal = new TransactionReal(applicationInfo);){
            String[] stringArray2 = DBUtil.dbCallExecute(string, stringArray, transactionReal, null);
            return stringArray2;
        }
    }

    public static String[] dbCallExecute(String string, String[] stringArray, Transaction transaction) {
        return DBUtil.dbCallExecute(string, stringArray, transaction, null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static String[] dbCallExecute(String string, String[] stringArray, ApplicationInfo applicationInfo, String string2) {
        try (TransactionReal transactionReal = new TransactionReal(applicationInfo);){
            String[] stringArray2 = DBUtil.dbCallExecute(string, stringArray, transactionReal, string2);
            return stringArray2;
        }
    }

    public static String[] dbCallExecute(String string, String[] stringArray, Transaction transaction, String string2) {
        CallableStatement callableStatement = null;
        String[] stringArray2 = new String[2];
        try {
            Connection connection = transaction.getConnection(string2);
            callableStatement = connection.prepareCall(string);
            callableStatement.registerOutParameter(1, 4);
            callableStatement.registerOutParameter(2, 12);
            if (stringArray != null) {
                for (int i = 0; i < stringArray.length; ++i) {
                    callableStatement.setObject(i + 3, (Object)stringArray[i]);
                }
            }
            callableStatement.execute();
            stringArray2[0] = String.valueOf(callableStatement.getInt(1));
            stringArray2[1] = callableStatement.getString(2);
            transaction.commit();
        }
        catch (SQLException sQLException) {
            try {
                transaction.rollback();
                String string3 = sQLException.getMessage() + ":" + sQLException.getSQLState() + CR + "SQL=[" + string + "]" + CR + "ARG=[" + StringUtil.array2csv(stringArray) + "]" + CR + "DBID=[" + string2 + "]" + CR;
                throw new RuntimeException(string3, sQLException);
            }
            catch (Throwable throwable) {
                Closer.stmtClose(callableStatement);
                throw throwable;
            }
        }
        Closer.stmtClose(callableStatement);
        return stringArray2;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static int dbExist(String string, String[] stringArray, ApplicationInfo applicationInfo, String string2) {
        try (TransactionReal transactionReal = new TransactionReal(applicationInfo);){
            int n = DBUtil.dbExist(string, stringArray, transactionReal, string2);
            return n;
        }
    }

    public static int dbExist(String string, String[] stringArray, Transaction transaction, String string2) {
        PreparedStatement preparedStatement = null;
        ResultSet resultSet = null;
        int n = -1;
        try {
            Connection connection = transaction.getConnection(string2);
            preparedStatement = connection.prepareStatement(string);
            if (stringArray != null) {
                boolean bl = ConnectionFactory.useParameterMetaData(string2);
                if (bl) {
                    ParameterMetaData parameterMetaData = preparedStatement.getParameterMetaData();
                    for (int i = 0; i < stringArray.length; ++i) {
                        int n2 = parameterMetaData.getParameterType(i + 1);
                        String string3 = stringArray[i];
                        if (string3 == null || string3.isEmpty()) {
                            preparedStatement.setNull(i + 1, n2);
                            continue;
                        }
                        preparedStatement.setObject(i + 1, (Object)string3, n2);
                    }
                } else {
                    for (int i = 0; i < stringArray.length; ++i) {
                        preparedStatement.setObject(i + 1, stringArray[i]);
                    }
                }
            }
            if ((resultSet = preparedStatement.executeQuery()).next()) {
                n = resultSet.getInt(1);
            }
        }
        catch (SQLException sQLException) {
            try {
                String string4 = sQLException.getMessage() + ":" + sQLException.getSQLState() + CR + "SQL=[" + string + "]" + CR + "ARG=[" + StringUtil.array2csv(stringArray) + "]" + CR + "DBID=[" + string2 + "]" + CR;
                throw new RuntimeException(string4, sQLException);
            }
            catch (Throwable throwable) {
                Closer.resultClose(resultSet);
                Closer.stmtClose(preparedStatement);
                throw throwable;
            }
        }
        Closer.resultClose(resultSet);
        Closer.stmtClose(preparedStatement);
        return n;
    }

    public static String[][] resultToArray(ResultSet resultSet, boolean bl) {
        ArrayList<String[]> arrayList = new ArrayList<String[]>();
        try {
            int n;
            ResultSetMetaData resultSetMetaData = resultSet.getMetaData();
            int n2 = resultSetMetaData.getColumnCount();
            String[] stringArray = new String[n2];
            int[] nArray = new int[n2];
            boolean bl2 = false;
            for (int i = 0; i < n2; ++i) {
                nArray[i] = n = resultSetMetaData.getColumnType(i + 1);
                if (n == 2005 || n == -8 || n == 93) {
                    bl2 = true;
                }
                if (!bl) continue;
                stringArray[i] = resultSetMetaData.getColumnLabel(i + 1).toUpperCase(Locale.JAPAN);
            }
            if (bl) {
                arrayList.add(stringArray);
            }
            while (resultSet.next()) {
                String[] stringArray2 = new String[n2];
                for (n = 0; n < n2; ++n) {
                    Object object = resultSet.getObject(n + 1);
                    stringArray2[n] = object == null ? "" : (bl2 ? DBUtil.getValue(resultSet, n, nArray[n]) : String.valueOf(object));
                }
                arrayList.add(stringArray2);
            }
        }
        catch (SQLException sQLException) {
            String string = "\u51e6\u7406\u7d50\u679c\u3092\u5b9f\u884c\u3067\u304d\u307e\u305b\u3093\u3067\u3057\u305f\u3002" + CR + sQLException.getMessage();
            throw new RuntimeException(string, sQLException);
        }
        int n = arrayList.size();
        String[][] stringArray = new String[n][];
        for (int i = 0; i < n; ++i) {
            stringArray[i] = (String[])arrayList.get(i);
        }
        return stringArray;
    }

    public static String getValue(ResultSet resultSet, int n, int n2) throws SQLException {
        String string = null;
        Object object = resultSet.getObject(n + 1);
        if (object == null) {
            string = "";
        } else {
            switch (n2) {
                case 2005: {
                    string = DBUtil.getClobData((Clob)object);
                    break;
                }
                case -8: {
                    string = resultSet.getString(n + 1);
                    break;
                }
                case 93: {
                    string = HybsDateUtil.getDate(((Timestamp)object).getTime(), "yyyyMMddHHmmss");
                    break;
                }
                default: {
                    string = String.valueOf(object);
                }
            }
        }
        return string;
    }

    public static String getProductName(Connection connection) {
        String string;
        try {
            string = connection.getMetaData().getDatabaseProductName().toLowerCase(Locale.JAPAN);
        }
        catch (SQLException sQLException) {
            string = "none";
        }
        return string;
    }

    public static String type2ClassName(int n) {
        String string;
        switch (n) {
            case -7: 
            case 1: 
            case 12: {
                string = "VARCHAR2";
                break;
            }
            case -1: {
                string = "LONG";
                break;
            }
            case -6: 
            case -5: 
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: {
                string = "NUMBER";
                break;
            }
            case 91: 
            case 92: 
            case 93: {
                string = "DATE";
                break;
            }
            case 2005: {
                string = "CLOB";
                break;
            }
            default: {
                string = "NONE";
            }
        }
        return string;
    }

    public static Number getNumber(int n, Object object) {
        Number number = null;
        switch (n) {
            case -6: 
            case -5: 
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: {
                number = (Number)object;
                break;
            }
            case 91: 
            case 92: {
                Date date = (Date)object;
                number = date.getTime();
                break;
            }
            case 93: {
                Timestamp timestamp = (Timestamp)object;
                number = timestamp.getTime();
                break;
            }
            case -1: 
            case 1: 
            case 12: {
                String string = (String)object;
                try {
                    number = Double.valueOf(string);
                    break;
                }
                catch (NumberFormatException numberFormatException) {
                    String string2 = "\u6570\u5b57\u5909\u63db\u3067\u304d\u307e\u305b\u3093\u3067\u3057\u305f\u3002in=" + string + CR + numberFormatException.getMessage();
                    throw new RuntimeException(string2, numberFormatException);
                }
            }
        }
        return number;
    }

    private static String getClobData(Clob clob) throws SQLException {
        if (clob == null) {
            return "";
        }
        Reader reader = null;
        StringBuilder stringBuilder = new StringBuilder(10000);
        try {
            int n;
            reader = clob.getCharacterStream();
            char[] cArray = new char[10000];
            while ((n = reader.read(cArray)) >= 0) {
                stringBuilder.append(cArray, 0, n);
            }
        }
        catch (IOException iOException) {
            String string = "CLOB\u30c7\u30fc\u30bf\u306e\u8aad\u307f\u8fbc\u307f\u306b\u5931\u6557\u3057\u307e\u3057\u305f\u3002";
            throw new RuntimeException(string, iOException);
        }
        finally {
            Closer.ioClose(reader);
        }
        return stringBuilder.toString();
    }
}

