/*
 * Decompiled with CFR 0.152.
 */
package org.opengion.fukurou.process;

import java.io.BufferedReader;
import java.io.File;
import java.io.IOException;
import java.util.LinkedHashMap;
import java.util.Map;
import org.opengion.fukurou.process.AbstractProcess;
import org.opengion.fukurou.process.FirstProcess;
import org.opengion.fukurou.process.LineModel;
import org.opengion.fukurou.process.ParamProcess;
import org.opengion.fukurou.util.Argument;
import org.opengion.fukurou.util.Closer;
import org.opengion.fukurou.util.FileUtil;
import org.opengion.fukurou.util.LogWriter;
import org.opengion.fukurou.util.StringUtil;

public class Process_TableReader
extends AbstractProcess
implements FirstProcess {
    private char separator = (char)9;
    private String infile = null;
    private BufferedReader reader = null;
    private LineModel model = null;
    private String line = null;
    private int[] clmNos = null;
    private boolean useNumber = true;
    private boolean nameNull = false;
    private boolean display = false;
    private boolean debug = false;
    private int inCount = 0;
    private int outCount = 0;
    private static final Map<String, String> mustProparty = new LinkedHashMap<String, String>();
    private static final Map<String, String> usableProparty;

    public Process_TableReader() {
        super("org.opengion.fukurou.process.Process_TableReader", mustProparty, usableProparty);
    }

    @Override
    public void init(ParamProcess paramProcess) {
        String[] stringArray;
        Argument argument = this.getArgument();
        this.infile = argument.getProparty("infile");
        boolean bl = argument.getProparty("existCheck", true);
        String string = argument.getProparty("encode", System.getProperty("file.encoding"));
        String string2 = argument.getProparty("columns");
        this.useNumber = argument.getProparty("useNumber", this.useNumber);
        this.display = argument.getProparty("display", this.display);
        this.debug = argument.getProparty("debug", this.debug);
        String string3 = argument.getProparty("sep", null);
        if (string3 != null) {
            this.separator = string3.charAt(0);
        }
        if (this.infile == null) {
            String string4 = "\u30d5\u30a1\u30a4\u30eb\u540d\u304c\u6307\u5b9a\u3055\u308c\u3066\u3044\u307e\u305b\u3093\u3002";
            throw new RuntimeException(string4);
        }
        File file = new File(this.infile);
        if (!file.exists()) {
            if (bl) {
                String string5 = "\u30d5\u30a1\u30a4\u30eb\u304c\u5b58\u5728\u3057\u307e\u305b\u3093\u3002File=[" + file + "]";
                throw new RuntimeException(string5);
            }
            this.nameNull = true;
            return;
        }
        if (!file.isFile()) {
            String string6 = "\u30d5\u30a1\u30a4\u30eb\u540d\u3092\u6307\u5b9a\u3057\u3066\u304f\u3060\u3055\u3044\u3002File=[" + file + "]";
            throw new RuntimeException(string6);
        }
        this.reader = FileUtil.getBufferedReader(file, string);
        if (string2 != null) {
            stringArray = StringUtil.csv2Array(string2);
        } else {
            String[] stringArray2 = this.readName(this.reader);
            if (stringArray2 == null || stringArray2.length == 0) {
                this.nameNull = true;
                return;
            }
            stringArray = stringArray2;
        }
        this.model = new LineModel();
        this.model.init(stringArray);
        if (this.display) {
            this.println(this.model.nameLine());
        }
        this.clmNos = new int[stringArray.length];
        for (int i = 0; i < stringArray.length; ++i) {
            int n = this.model.getColumnNo(stringArray[i]);
            if (n < 0) continue;
            this.clmNos[n] = this.useNumber ? i + 1 : i;
        }
    }

    @Override
    public void end(boolean bl) {
        Closer.ioClose(this.reader);
        this.reader = null;
    }

    @Override
    public boolean next() {
        if (this.nameNull) {
            return false;
        }
        boolean bl = false;
        try {
            while ((this.line = this.reader.readLine()) != null) {
                ++this.inCount;
                if (this.line.length() == 0 || this.line.charAt(0) == '#') continue;
                int n = StringUtil.countChar(this.line, '\"');
                if (n % 2 != 0) {
                    String string = null;
                    StringBuilder stringBuilder = new StringBuilder(this.line);
                    while (n % 2 != 0 && (string = this.reader.readLine()) != null) {
                        if (string.length() == 0 || string.charAt(0) == '#') continue;
                        stringBuilder.append(CR).append(string);
                        n += StringUtil.countChar(string, '\"');
                    }
                    this.line = stringBuilder.toString();
                }
                bl = true;
                break;
            }
        }
        catch (IOException iOException) {
            String string = "\u30d5\u30a1\u30a4\u30eb\u8aad\u8fbc\u307f\u30a8\u30e9\u30fc[" + this.reader.toString() + "]";
            throw new RuntimeException(string, iOException);
        }
        if (this.debug) {
            this.println(this.line);
        }
        return bl;
    }

    @Override
    public LineModel makeLineModel(int n) {
        ++this.outCount;
        String[] stringArray = StringUtil.csv2Array(this.line, this.separator);
        int n2 = stringArray.length;
        for (int i = 0; i < this.model.size(); ++i) {
            int n3 = this.clmNos[i];
            if (n2 > n3) {
                this.model.setValue(i, stringArray[n3]);
                continue;
            }
            this.model.setValue(i, "");
        }
        this.model.setRowNo(n);
        if (this.display) {
            this.println(this.model.dataLine());
        }
        return this.model;
    }

    private String[] readName(BufferedReader bufferedReader) {
        try {
            String string;
            while ((string = bufferedReader.readLine()) != null) {
                String string2;
                ++this.inCount;
                if (string.length() == 0) continue;
                if (string.charAt(0) == '#') {
                    string2 = string.substring(0, 5);
                    if (!"#NAME".equalsIgnoreCase(string2)) continue;
                    String string3 = string.substring(string.indexOf(9) + 1);
                    return StringUtil.csv2Array(string3, '\t');
                }
                string2 = "#NAME \u304c\u898b\u3064\u304b\u308b\u524d\u306b\u30c7\u30fc\u30bf\u304c\u898b\u3064\u304b\u308a\u307e\u3057\u305f\u3002";
                throw new RuntimeException(string2);
            }
        }
        catch (IOException iOException) {
            String string = "\u30d5\u30a1\u30a4\u30eb\u8aad\u8fbc\u307f\u30a8\u30e9\u30fc[" + bufferedReader.toString() + "]";
            throw new RuntimeException(string, iOException);
        }
        return new String[0];
    }

    @Override
    public String report() {
        String string = "[" + this.getClass().getName() + "]" + CR + '\t' + "Input  File  : " + this.infile + CR + '\t' + "Input  Count : " + this.inCount + CR + '\t' + "Output Count : " + this.outCount;
        return string;
    }

    @Override
    public String usage() {
        StringBuilder stringBuilder = new StringBuilder(600);
        stringBuilder.append("Process_TableReader\u306f\u3001\u30d5\u30a1\u30a4\u30eb\u304b\u3089\u8aad\u307f\u53d6\u3063\u305f\u5185\u5bb9\u3092\u3001LineModel \u306b\u8a2d\u5b9a\u5f8c\u3001").append(CR);
        stringBuilder.append("\u4e0b\u6d41\u306b\u6e21\u3059\u3001FirstProcess \u30a4\u30f3\u30bf\u30fc\u30d5\u30a7\u30fc\u30b9\u306e\u5b9f\u88c5\u30af\u30e9\u30b9\u3067\u3059\u3002").append(CR);
        stringBuilder.append(CR);
        stringBuilder.append("DBTableModel \u5f62\u5f0f\u306e\u30d5\u30a1\u30a4\u30eb\u3092\u8aad\u307f\u53d6\u3063\u3066\u3001\u5404\u884c\u3092 LineModel \u306b\u30bb\u30c3\u30c8\u3057\u3066\u3001").append(CR);
        stringBuilder.append("\u4e0b\u6d41(\u30d7\u30ed\u30bb\u30b9\u30c1\u30a7\u30a4\u30f3\u306e\u30c7\u30fc\u30bf\u306f\u4e0a\u6d41\u304b\u3089\u4e0b\u6d41\u306b\u6e21\u3055\u308c\u307e\u3059\u3002)\u306b\u6e21\u3057\u307e\u3059\u3002").append(CR);
        stringBuilder.append(CR);
        stringBuilder.append("columns \u5c5e\u6027\u306f\u3001#NAME \u3067\u5217\u30ab\u30e9\u30e0\u3092\u5916\u90e8\u304b\u3089\u6307\u5b9a\u3059\u308b\u5834\u5408\u306b\u4f7f\u7528\u3057\u307e\u3059\u3002").append(CR);
        stringBuilder.append("\u3053\u306e\u5c5e\u6027\u3068useNumber\u5c5e\u6027\u306f\u72ec\u7acb\u3057\u3066\u3044\u307e\u3059\u304c\u3001\u4e00\u822c\u306b\u306f\u3001#NAME \u3092\u6307\u5b9a").append(CR);
        stringBuilder.append("\u3059\u308b\u5834\u5408\u306f\u3001useNumber=\"true\"\u3068\u3057\u3066\u3001\u884c\u756a\u53f7\u6b04\u306f\u4f7f\u7528\u3057\u307e\u3059\u3057\u3001\u5916\u90e8\u304b\u3089").append(CR);
        stringBuilder.append("\u6307\u5b9a\u3059\u308b\u5834\u5408\u306f\u3001useNumber=\"false\"\u306b\u3057\u3066\u5148\u982d\u304b\u3089\u8aad\u307f\u53d6\u308a\u307e\u3059\u3002").append(CR);
        stringBuilder.append("(\u81ea\u52d5\u30bb\u30c3\u30c8\u3067\u306f\u306a\u3044\u306e\u3067\u3001\u5fc5\u8981\u306b\u5fdc\u3058\u3066\u8a2d\u5b9a\u3057\u3066\u304f\u3060\u3055\u3044)").append(CR);
        stringBuilder.append("useNumber \u306e\u521d\u671f\u5024\u306f\u3001\"true\" \u3067\u3059\u3002").append(CR);
        stringBuilder.append(CR);
        stringBuilder.append("\u5f15\u6570\u6587\u5b57\u5217\u4e2d\u306b\u7a7a\u767d\u3092\u542b\u3080\u5834\u5408\u306f\u3001\u30c0\u30d6\u30eb\u30b3\u30fc\u30c6\u30fc\u30b7\u30e7\u30f3(\"\") \u3067\u62ec\u3063\u3066\u4e0b\u3055\u3044\u3002").append(CR);
        stringBuilder.append("\u5f15\u6570\u6587\u5b57\u5217\u306e \u300e=\u300f\u306e\u524d\u5f8c\u306b\u306f\u3001\u7a7a\u767d\u306f\u631f\u3081\u307e\u305b\u3093\u3002\u5fc5\u305a\u3001-key=value \u306e\u69d8\u306b").append(CR);
        stringBuilder.append("\u7e4b\u3052\u3066\u304f\u3060\u3055\u3044\u3002").append(CR);
        stringBuilder.append(CR).append(CR);
        stringBuilder.append(this.getArgument().usage()).append(CR);
        return stringBuilder.toString();
    }

    public static void main(String[] stringArray) {
        LogWriter.log(new Process_TableReader().usage());
    }

    static {
        mustProparty.put("infile", "\u5165\u529b\u30d5\u30a1\u30a4\u30eb\u540d (\u5fc5\u9808)");
        usableProparty = new LinkedHashMap<String, String>();
        usableProparty.put("existCheck", "\u30d5\u30a1\u30a4\u30eb\u304c\u5b58\u5728\u3057\u306a\u3044\u5834\u5408\u30a8\u30e9\u30fc\u306b\u3059\u308b(\u521d\u671f\u5024:true)");
        usableProparty.put("sep", "\u533a\u5207\u308a\u6587\u5b57(\u521d\u671f\u5024:\u30bf\u30d6)");
        usableProparty.put("encode", "\u5165\u529b\u30d5\u30a1\u30a4\u30eb\u306e\u30a8\u30f3\u30b3\u30fc\u30c9\u30bf\u30a4\u30d7");
        usableProparty.put("columns", "\u5165\u529b\u30ab\u30e9\u30e0\u540d(\u30ab\u30f3\u30de\u533a\u5207\u308a)");
        usableProparty.put("useNumber", "\u884c\u756a\u53f7\u3092\u4f7f\u7528\u3059\u308b(true)\u304b\u4f7f\u7528\u3057\u306a\u3044(false)\u304b");
        usableProparty.put("display", "\u7d50\u679c\u3092\u6a19\u6e96\u51fa\u529b\u306b\u8868\u793a\u3059\u308b(true)\u304b\u3057\u306a\u3044(false)\u304b" + CR + " (\u521d\u671f\u5024:false:\u8868\u793a\u3057\u306a\u3044)");
        usableProparty.put("debug", "\u30c7\u30d0\u30c3\u30b0\u60c5\u5831\u3092\u6a19\u6e96\u51fa\u529b\u306b\u8868\u793a\u3059\u308b(true)\u304b\u3057\u306a\u3044(false)\u304b" + CR + "(\u521d\u671f\u5024:false:\u8868\u793a\u3057\u306a\u3044)");
    }
}

