/*
 * Decompiled with CFR 0.152.
 */
package org.opengion.plugin.daemon;

import java.io.File;
import java.util.Date;
import org.opengion.fukurou.util.HybsTimerTask;
import org.opengion.fukurou.util.Shell;
import org.opengion.fukurou.util.StringUtil;
import org.opengion.hayabusa.common.HybsSystem;

public class Daemon_RunShell
extends HybsTimerTask {
    private static final int LOOP_COUNTER = 24;
    private int loopCnt = 0;
    private String program = null;
    private boolean useBatch = false;
    private boolean stdout = false;
    private boolean stderr = false;
    private boolean wait = true;
    private File workDir = null;
    private final int timeout = HybsSystem.sysInt((String)"SHELL_TIMEOUT");
    private boolean debug = false;
    private Shell shell;

    public void initDaemon() {
        this.debug = StringUtil.nval((String)this.getValue("DEBUG"), (boolean)this.debug);
        this.program = StringUtil.nval((String)this.getValue("program"), (String)this.program);
        this.useBatch = StringUtil.nval((String)this.getValue("useBatch"), (boolean)this.useBatch);
        this.stdout = StringUtil.nval((String)this.getValue("stdout"), (boolean)this.stdout);
        this.stderr = StringUtil.nval((String)this.getValue("stderr"), (boolean)this.stderr);
        this.wait = StringUtil.nval((String)this.getValue("wait"), (boolean)this.wait);
        if (this.getValue("workDir") != null) {
            this.workDir = new File(this.getValue("workDir"));
        }
        this.shell = new Shell();
        this.shell.setCommand(this.program, this.useBatch);
        this.shell.setWait(this.wait);
        this.shell.setTimeout(this.timeout);
        this.shell.setWorkDir(this.workDir);
        if (this.debug) {
            System.out.println(this.program + "/" + this.useBatch + "/" + this.wait + "/" + this.timeout + "/" + this.workDir.toString());
        }
    }

    protected void startDaemon() {
        if (this.loopCnt % 24 == 0) {
            this.loopCnt = 1;
            System.out.println(this.toString() + " " + new Date() + " ");
        } else {
            ++this.loopCnt;
        }
        int n = this.shell.exec();
        if (n < 0) {
            System.out.println("Shell Run Error:" + this.program);
        }
    }
}

