/*
 * Decompiled with CFR 0.152.
 */
package org.opengion.plugin.io;

import java.io.BufferedReader;
import org.opengion.fukurou.model.ExcelModel;
import org.opengion.fukurou.util.StringUtil;
import org.opengion.hayabusa.common.HybsSystem;
import org.opengion.hayabusa.common.HybsSystemException;
import org.opengion.hayabusa.db.DBTableModelUtil;
import org.opengion.plugin.io.HeaderData;
import org.opengion.plugin.io.TableReader_Default;

public class TableReader_Excel
extends TableReader_Default {
    private static final String VERSION = "6.0.2.5 (2014/10/31)";
    private String filename = null;
    private String sheetName = null;
    private String sheetNos = null;
    private String constKeys = null;
    private String constAdrs = null;
    private String nullBreakClm = null;

    @Override
    public void readDBTable() {
        int n;
        HeaderData headerData = null;
        boolean bl = this.isDebug();
        if (bl) {
            System.out.println(" Filename=" + this.filename);
        }
        ExcelModel excelModel = new ExcelModel(this.filename, true);
        int[] nArray = null;
        if (this.sheetNos != null && this.sheetNos.length() > 0) {
            String[] stringArray = StringUtil.csv2ArrayExt((String)this.sheetNos, (int)(excelModel.getNumberOfSheets() - 1));
            nArray = new int[stringArray.length];
            for (n = 0; n < stringArray.length; ++n) {
                nArray[n] = Integer.parseInt(stringArray[n]);
            }
        } else if (this.sheetName != null && this.sheetName.length() > 0) {
            int n2 = excelModel.getSheetNo(this.sheetName);
            if (n2 < 0) {
                String string = "\u5bfe\u5fdc\u3059\u308b\u30b7\u30fc\u30c8\u304c\u5b58\u5728\u3057\u307e\u305b\u3093\u3002 Sheet=[" + this.sheetName + "]";
                throw new HybsSystemException(string);
            }
            nArray = new int[]{n2};
        } else {
            nArray = new int[]{0};
        }
        boolean bl2 = true;
        this.table = DBTableModelUtil.newDBTable();
        n = 0;
        headerData = new HeaderData();
        headerData.setDebug(bl);
        headerData.setUseNumber(this.isUseNumber());
        headerData.setSheetConstData(this.constKeys, this.constAdrs);
        int n3 = -1;
        if (headerData.setColumns(this.columns)) {
            bl2 = false;
            this.table.init(headerData.getColumnSize());
            this.setTableDBColumn(headerData.getNames());
            n3 = this.table.getColumnNo(this.nullBreakClm, false);
        }
        int n4 = this.getSkipRowCount();
        for (int i = 0; i < nArray.length; ++i) {
            String string = excelModel.getSheetName(nArray[i]);
            headerData.setSheetConstValues(excelModel, string);
            int n5 = excelModel.getFirstRowNum();
            if (n5 < n4) {
                n5 = n4;
            }
            int n6 = excelModel.getLastRowNum();
            if (bl) {
                System.out.println(" Debug: \u884c\u9023\u756a=" + n + " : Sheet=" + string + " , \u958b\u59cb=" + n5 + " , \u7d42\u4e86=" + n6);
            }
            for (int j = n5; j <= n6; ++j) {
                String[] stringArray;
                if (bl && j > 0) {
                    if (j % 50 == 0) {
                        System.err.print(".");
                    }
                    if (j % 1000 == 0) {
                        System.err.println("  Count=[" + j + "]");
                    }
                }
                if (headerData.isSkip(stringArray = excelModel.getValues(j))) continue;
                if (bl2) {
                    bl2 = false;
                    this.table.init(headerData.getColumnSize());
                    this.setTableDBColumn(headerData.getNames());
                    n3 = this.table.getColumnNo(this.nullBreakClm, false);
                }
                if (n < this.getMaxRowCount()) {
                    String[] stringArray2 = headerData.row2Array(stringArray);
                    if (n3 >= 0 && (stringArray2[n3] == null || stringArray2[n3].isEmpty())) break;
                    this.setTableColumnValues(stringArray2);
                    ++n;
                    continue;
                }
                this.table.setOverflow(true);
            }
            if (bl) {
                System.err.println("  Count=[" + n6 + "]");
            }
            if (!bl2) continue;
            String string2 = "\u6700\u5f8c\u307e\u3067\u3001#NAME \u304c\u898b\u3064\u304b\u308a\u307e\u305b\u3093\u3067\u3057\u305f\u3002" + HybsSystem.CR + "\u30d5\u30a1\u30a4\u30eb\u304c\u7a7a\u304b\u3001\u3082\u3057\u304f\u306f\u640d\u50b7\u3057\u3066\u3044\u308b\u53ef\u80fd\u6027\u304c\u3042\u308a\u307e\u3059\u3002" + HybsSystem.CR;
            throw new HybsSystemException(string2);
        }
    }

    @Override
    public void readDBTable(BufferedReader bufferedReader) {
        String string = "\u3053\u306e\u30af\u30e9\u30b9\u3067\u306f\u5b9f\u88c5\u3055\u308c\u3066\u3044\u307e\u305b\u3093\u3002";
        throw new UnsupportedOperationException(string);
    }

    public void setSheetName(String string) {
        this.sheetName = string;
    }

    public void setSheetNos(String string) {
        this.sheetNos = string;
    }

    public void setSheetConstData(String string, String string2) {
        this.constKeys = string;
        this.constAdrs = string2;
    }

    public void setNullBreakClm(String string) {
        this.nullBreakClm = string;
    }

    public boolean isExcel() {
        return true;
    }

    public void setFilename(String string) {
        this.filename = string;
        if (string == null) {
            String string2 = "\u30d5\u30a1\u30a4\u30eb\u540d\u304c\u6307\u5b9a\u3055\u308c\u3066\u3044\u307e\u305b\u3093\u3002";
            throw new HybsSystemException(string2);
        }
    }
}

