/*
 * Decompiled with CFR 0.152.
 */
package org.opengion.plugin.io;

import java.io.PrintWriter;
import org.opengion.fukurou.model.ExcelModel;
import org.opengion.fukurou.model.NativeType;
import org.opengion.fukurou.util.StringUtil;
import org.opengion.hayabusa.common.HybsSystem;
import org.opengion.hayabusa.common.HybsSystemException;
import org.opengion.hayabusa.db.DBTableModel;
import org.opengion.plugin.io.TableWriter_Default;

public class TableWriter_Excel
extends TableWriter_Default {
    private static final String VERSION = "6.0.2.0 (2014/09/19)";
    private int nRowIndex = 0;
    private String filename = null;
    private String directory = null;
    private String fileKey = null;
    private String sheetName = "Sheet";
    private String fontName = null;
    private short fontPoint = (short)-1;
    private String refFilename = null;
    private String refSheetName = null;
    private boolean useNumber = true;
    private int skipRowCount = 0;
    private ExcelModel excel = null;
    private boolean useCellStyle = false;
    private boolean useAutoCellSize = false;
    private boolean useActiveWorkbook = false;
    private String pageBreakColumn = null;
    private String fileBreakColumn = null;
    private String hLinkKeyColumn = null;
    private String hLinkValColumn = null;
    private String addTitleSheet = null;
    private int pageBreakClmNo = -1;
    private int fileBreakClmNo = -1;
    private int hLinkKeyClmNo = -1;
    private int hLinkValClmNo = -1;
    private int tblRow = 0;
    private boolean[] nvar = null;
    private boolean[] isNums = null;

    @Override
    public void writeDBTable() {
        boolean bl;
        if (!this.createDBColumn()) {
            return;
        }
        this.useNumber = this.isUseNumber();
        if (this.filename == null) {
            String string = "\u30d5\u30a1\u30a4\u30eb\u304c\u6307\u5b9a\u3055\u308c\u3066\u3044\u307e\u305b\u3093\u3002";
            throw new HybsSystemException(string);
        }
        if (this.isAppend()) {
            if (this.refFilename != null && !this.filename.equalsIgnoreCase(this.refFilename)) {
                String string = "\u8ffd\u52a0(append\u30e2\u30fc\u30c9)\u306e\u6642\u3001\u96db\u5f62\u30d5\u30a1\u30a4\u30eb\u306e\u6307\u5b9a\u306f\u7121\u52b9\u3067\u3059\u3002" + HybsSystem.CR + " filename=[" + this.filename + "] , refFilename=[" + this.refFilename + "]" + HybsSystem.CR;
                throw new HybsSystemException(string);
            }
            this.refFilename = this.filename;
        }
        String string = this.filename;
        boolean bl2 = bl = this.refFilename != null && this.refFilename.length() > 0;
        if (bl) {
            string = this.refFilename;
        }
        this.initWriteData();
        if (this.fileBreakClmNo >= 0) {
            this.fileKey = (String)this.table.getValue(this.tblRow, this.fileBreakClmNo);
        }
        while (this.fileKey != null) {
            int n;
            String string2 = StringUtil.urlAppend((String)this.directory, (String)this.fileKey, (String[])new String[0]);
            this.excel = new ExcelModel(string, bl);
            int n2 = n = bl ? this.excel.getNumberOfSheets() : 0;
            if (this.isAppend()) {
                n = 0;
            }
            if (!bl) {
                this.excel.setFont(this.fontName, this.fontPoint);
            }
            if (this.useCellStyle) {
                this.excel.setCellStyle();
            }
            this.excel.useAutoCellSize(this.useAutoCellSize);
            this.excel.setAddTitleSheet(this.addTitleSheet);
            if (bl) {
                this.excel.setRefSheetName(this.refSheetName);
            }
            if (this.pageBreakClmNo >= 0) {
                this.sheetName = (String)this.table.getValue(this.tblRow, this.pageBreakClmNo);
            }
            while (this.sheetName != null) {
                this.excel.createSheet(this.sheetName);
                this.nRowIndex = this.skipRowCount;
                super.writeDBTable(null);
                this.excel.removeRow(this.nRowIndex);
            }
            if (bl) {
                this.excel.removeSheet(0, n - 1);
            }
            if (this.useActiveWorkbook) {
                this.excel.activeWorkbook(false);
            }
            this.excel.saveFile(string2);
        }
    }

    protected void writeLabel(DBTableModel dBTableModel, PrintWriter printWriter) {
        int n = 0;
        this.excel.createRow(this.nRowIndex++);
        if (this.useNumber) {
            int n2 = n;
            n = (short)(n + 1);
            this.headerCellValue("Label", n2);
        }
        for (int i = 0; i < this.numberOfColumns; ++i) {
            int n3 = this.clmNo[i];
            if (n3 < 0) {
                n = (short)(n + 1);
                continue;
            }
            String string = this.dbColumn[n3].getLabel();
            int n4 = n;
            n = (short)(n + 1);
            this.headerCellValue(string, n4);
        }
        this.excel.removeCell(n);
    }

    protected void writeName(DBTableModel dBTableModel, PrintWriter printWriter) {
        int n = 0;
        this.excel.createRow(this.nRowIndex++);
        if (this.useNumber) {
            int n2 = n;
            n = (short)(n + 1);
            this.headerCellValue("Name", n2);
        }
        for (int i = 0; i < this.numberOfColumns; ++i) {
            int n3 = this.clmNo[i];
            if (n3 < 0) {
                n = (short)(n + 1);
                continue;
            }
            String string = dBTableModel.getColumnName(n3);
            int n4 = n;
            n = (short)(n + 1);
            this.headerCellValue(string, n4);
        }
        this.excel.removeCell(n);
    }

    protected void writeSize(DBTableModel dBTableModel, PrintWriter printWriter) {
        int n = 0;
        this.excel.createRow(this.nRowIndex++);
        if (this.useNumber) {
            int n2 = n;
            n = (short)(n + 1);
            this.headerCellValue("Size", n2);
        }
        for (int i = 0; i < this.numberOfColumns; ++i) {
            int n3 = this.clmNo[i];
            if (n3 < 0) {
                n = (short)(n + 1);
                continue;
            }
            String string = String.valueOf(this.dbColumn[n3].getTotalSize());
            int n4 = n;
            n = (short)(n + 1);
            this.headerCellValue(string, n4);
        }
        this.excel.removeCell(n);
    }

    protected void writeClass(DBTableModel dBTableModel, PrintWriter printWriter) {
        int n = 0;
        this.excel.createRow(this.nRowIndex++);
        if (this.useNumber) {
            int n2 = n;
            n = (short)(n + 1);
            this.headerCellValue("Class", n2);
        }
        for (int i = 0; i < this.numberOfColumns; ++i) {
            int n3 = this.clmNo[i];
            if (n3 < 0) {
                n = (short)(n + 1);
                continue;
            }
            String string = this.dbColumn[n3].getClassName();
            int n4 = n;
            n = (short)(n + 1);
            this.headerCellValue(string, n4);
        }
        this.excel.removeCell(n);
    }

    protected void writeSeparator(DBTableModel dBTableModel, PrintWriter printWriter) {
        int n = 0;
        this.excel.createRow(this.nRowIndex++);
        if (this.useNumber) {
            int n2 = n;
            n = (short)(n + 1);
            this.headerCellValue("----", n2);
        }
        for (int i = 0; i < this.numberOfColumns; ++i) {
            int n3 = this.clmNo[i];
            if (n3 < 0) {
                n = (short)(n + 1);
                continue;
            }
            int n4 = n;
            n = (short)(n + 1);
            this.headerCellValue("----", n4);
        }
        this.excel.removeCell(n);
    }

    private void headerCellValue(String string, int n) {
        if (n == 0) {
            this.excel.setCellValue("#" + string, n);
        } else {
            this.excel.setCellValue(string, n);
        }
    }

    private void initWriteData() {
        DBTableModel dBTableModel = this.getDBTableModel();
        this.pageBreakClmNo = dBTableModel.getColumnNo(this.pageBreakColumn, false);
        this.fileBreakClmNo = dBTableModel.getColumnNo(this.fileBreakColumn, false);
        this.hLinkKeyClmNo = dBTableModel.getColumnNo(this.hLinkKeyColumn, false);
        this.hLinkValClmNo = dBTableModel.getColumnNo(this.hLinkValColumn, false);
        this.nvar = new boolean[this.numberOfColumns];
        this.isNums = new boolean[this.numberOfColumns];
        boolean bl = this.isUseRenderer();
        for (int i = 0; i < this.numberOfColumns; ++i) {
            int n = this.clmNo[i];
            if (n < 0) continue;
            System.out.println(this.dbColumn[n].getName() + ":" + this.dbColumn[n].getLabel() + " isStringOutput=" + this.dbColumn[n].isStringOutput());
            if (bl && this.dbColumn[n].isStringOutput()) {
                this.isNums[i] = false;
            } else {
                NativeType nativeType = this.dbColumn[n].getNativeType();
                switch (nativeType) {
                    case INT: 
                    case LONG: 
                    case DOUBLE: {
                        this.isNums[i] = true;
                        break;
                    }
                    default: {
                        this.isNums[i] = false;
                    }
                }
            }
            this.nvar[i] = "NVAR".equals(this.dbColumn[n].getDbType());
            System.out.println(this.dbColumn[n].getName() + " isNums=" + this.isNums[i]);
        }
    }

    @Override
    protected void writeData(DBTableModel dBTableModel, PrintWriter printWriter) {
        int n = dBTableModel.getRowCount();
        boolean bl = this.isUseRenderer();
        if (this.useAutoCellSize) {
            this.excel.setDataStartRow(this.nRowIndex);
        }
        while (this.tblRow < n) {
            String string;
            if (this.pageBreakClmNo >= 0 && !this.sheetName.equals(string = (String)dBTableModel.getValue(this.tblRow, this.pageBreakClmNo))) {
                this.sheetName = string;
                return;
            }
            if (this.fileBreakClmNo >= 0 && !this.fileKey.equals(string = (String)dBTableModel.getValue(this.tblRow, this.fileBreakClmNo))) {
                this.fileKey = string;
                this.sheetName = null;
                return;
            }
            int n2 = 0;
            this.excel.createRow(this.nRowIndex++);
            if (this.useNumber) {
                int n3 = n2;
                n2 = (short)(n2 + 1);
                this.excel.setCellValue(String.valueOf(this.tblRow + 1), n3, true);
            }
            for (int i = 0; i < this.numberOfColumns; ++i) {
                int n4 = this.clmNo[i];
                if (n4 < 0) {
                    n2 = (short)(n2 + 1);
                    continue;
                }
                String string2 = (String)dBTableModel.getValue(this.tblRow, n4);
                if (this.nvar[i]) {
                    string2 = StringUtil.getReplaceEscape((String)string2);
                } else if (bl) {
                    string2 = StringUtil.spanCut((String)this.dbColumn[n4].getRendererValue(string2));
                }
                this.excel.setCellValue(string2, n2, this.isNums[i]);
                if (n4 == this.hLinkKeyClmNo && this.hLinkValClmNo >= 0) {
                    String string3 = (String)dBTableModel.getValue(this.tblRow, this.hLinkValClmNo);
                    this.excel.setCellLink(string3, n2);
                }
                n2 = (short)(n2 + 1);
            }
            this.excel.removeCell(n2);
            ++this.tblRow;
        }
        this.sheetName = null;
        this.fileKey = null;
    }

    public void setFilename(String string, String string2) {
        this.filename = StringUtil.urlAppend((String)string, (String)string2, (String[])new String[0]);
        this.directory = string;
        this.fileKey = string2;
    }

    public void setSheetName(String string) {
        if (string != null) {
            this.sheetName = string;
        }
    }

    public boolean isExcel() {
        return true;
    }

    public void setRefFilename(String string) {
        this.refFilename = string;
    }

    public void setRefSheetName(String string) {
        if (string != null) {
            this.refSheetName = string;
        }
    }

    public void setSkipRowCount(int n) {
        this.skipRowCount = n;
    }

    public void setFontName(String string) {
        this.fontName = string;
    }

    public void setFontPoint(short s) {
        this.fontPoint = s;
    }

    public void setUseCellStyle(boolean bl) {
        this.useCellStyle = bl;
    }

    public void setUseAutoCellSize(boolean bl) {
        this.useAutoCellSize = bl;
    }

    public void setUseActiveWorkbook(boolean bl) {
        this.useActiveWorkbook = bl;
    }

    public void setPageBreakColumn(String string) {
        this.pageBreakColumn = string;
    }

    public void setFileBreakColumn(String string) {
        this.fileBreakColumn = string;
    }

    public void setHyperLinkColumn(String string) {
        if (string != null && string.length() > 0) {
            int n = string.indexOf(58);
            if (n >= 0) {
                this.hLinkKeyColumn = string.substring(0, n);
                this.hLinkValColumn = string.substring(n + 1);
            } else {
                this.hLinkKeyColumn = string;
                this.hLinkValColumn = string;
            }
        }
    }

    public void setAddTitleSheet(String string) {
        this.addTitleSheet = string;
    }
}

